#import "MoviePlayer.h"

@implementation MoviePlayer

- (void)play:(NSString*)path click:(BOOL)click_flag loop:(BOOL)loop_flag {
    self->loop_flag = loop_flag;
    NSURL *url = [NSURL fileURLWithPath:path];
    MPMoviePlayerViewController *player = [[MPMoviePlayerViewController alloc] initWithContentURL:url];
    player.moviePlayer.controlStyle = MPMovieControlStyleNone;

    if (click_flag){
        // add tap handler
        UITapGestureRecognizer *tap_recog = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(handleTap:)];
        tap_recog.delegate = self;
        tap_recog.numberOfTapsRequired = 1;
        [player.moviePlayer.view addGestureRecognizer:tap_recog];
        [tap_recog release];
    }

    [[NSNotificationCenter defaultCenter] removeObserver:player
                                                 name:MPMoviePlayerPlaybackDidFinishNotification
                                               object:player.moviePlayer];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(finishPlayback:)
                                                 name:MPMoviePlayerPlaybackDidFinishNotification
                                               object:player.moviePlayer];

    UIWindow *uiwindow = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    [uiwindow addSubview:self.view];
    [uiwindow makeKeyAndVisible];

    [self presentViewController:player animated:YES completion:nil];

    [player.moviePlayer prepareToPlay];
    [player.moviePlayer play];

    is_running = YES;
    while(is_running)
        [[NSRunLoop currentRunLoop] runMode: NSDefaultRunLoopMode beforeDate:[NSDate dateWithTimeIntervalSinceNow:0.1]];

    [player.moviePlayer stop];
    [player release];

    uiwindow.hidden = YES;
    [uiwindow release];
}

- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch {
    return YES;
}

- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldRecognizeSimultaneouslyWithGestureRecognizer:(UIGestureRecognizer *)otherGestureRecognizer {
    return YES;
}

- (void)handleTap:(UITapGestureRecognizer *)gesture {
    is_running = NO;
}

- (void)finishPlayback:(NSNotification *)notification {
    MPMoviePlayerViewController *player = [notification object];
    if (loop_flag){
        [player play];
    }
    else{
        [[NSNotificationCenter defaultCenter] removeObserver:self
                                              name:MPMoviePlayerPlaybackDidFinishNotification
                                              object:player];

        [self dismissViewControllerAnimated:YES completion:nil];
        is_running = NO;
    }
}

@end
