#import "DataCopier.h"

@implementation DataCopier

- (int) copy {
#ifdef MAGIC_FILE
    char *magic = MAGIC_FILE;
#else
    char *magic = ".ONS.COPY.DONE";
#endif

    NSString* src_path = [[NSBundle mainBundle] pathForResource:@"ONS" ofType:@""];

    NSArray* paths = NSSearchPathForDirectoriesInDomains(NSCachesDirectory, NSUserDomainMask, YES);
    NSString* dst_path = [[paths objectAtIndex:0] stringByAppendingPathComponent:@"ONS"];
    NSString* magic_path = [dst_path stringByAppendingPathComponent:[NSString stringWithCString: magic encoding:NSUTF8StringEncoding]];

    NSFileManager *fm = [NSFileManager defaultManager];
    if ([fm fileExistsAtPath:dst_path]){
        if ([fm fileExistsAtPath:magic_path]) return 0;
        // delete and copy again
        //[fm removeItemAtPath:dst_path error:nil];
    }

    // create progress bar
    UIWindow *uiwindow = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    [uiwindow addSubview:self.view];
    [uiwindow makeKeyAndVisible];

    UIActionSheet *actionSheet;
    actionSheet = [[UIActionSheet alloc] initWithTitle:@"Copying archives from Resources...\n\n" 
                                         delegate:self 
                                         cancelButtonTitle:nil
                                         destructiveButtonTitle:nil 
                                         otherButtonTitles:nil];
    [actionSheet autorelease];
    [actionSheet showInView:uiwindow];
    [[NSRunLoop currentRunLoop] runMode: NSDefaultRunLoopMode beforeDate:[NSDate dateWithTimeIntervalSinceNow:0.1]];

    [fm setDelegate:self];
    [fm copyItemAtPath:src_path toPath:dst_path error:nil];

    NSArray* dpaths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString* dpath = [[dpaths objectAtIndex:0] stringByAppendingPathComponent:@"ONS"];
    [fm createDirectoryAtPath:dpath withIntermediateDirectories: YES attributes: nil error:nil];

    [fm createFileAtPath:magic_path contents:nil attributes:nil];

    [actionSheet dismissWithClickedButtonIndex:-1 animated:YES];

    return 0;
}

- (BOOL)fileManager:(NSFileManager*)fm shouldProceedAfterError:(NSError*)error copyingItemAtPath:(NSString*)srcPath toPath:(NSString*)dstPath {
  if ([error code] == NSFileWriteFileExistsError){
    BOOL isDir;
    if ([fm fileExistsAtPath:dstPath isDirectory:&isDir] && !isDir){
      [fm removeItemAtPath:dstPath error:nil];
      [fm copyItemAtPath:srcPath toPath:dstPath error:nil];
    }
    return YES;
  }
  else
    return NO;
}
@end
