/* DO NOT EDIT!  This file is generated by sdlgenaudiocvt.pl */
/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997-2010 Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Sam Lantinga
    slouken@libsdl.org
*/

#include "SDL_config.h"
#include "SDL_audio.h"
#include "SDL_audio_c.h"

#ifndef DEBUG_CONVERT
#define DEBUG_CONVERT 0
#endif


/* If you can guarantee your data and need space, you can eliminate code... */

/* Just build the arbitrary resamplers if you're saving code space. */
#ifndef LESS_RESAMPLERS
#define LESS_RESAMPLERS 0
#endif

/* Don't build any resamplers if you're REALLY saving code space. */
#ifndef NO_RESAMPLERS
#define NO_RESAMPLERS 0
#endif

/* Don't build any type converters if you're saving code space. */
#ifndef NO_CONVERTERS
#define NO_CONVERTERS 0
#endif


/* *INDENT-OFF* */

#define DIVBY127 0.0078740157480315f
#define DIVBY32767 3.05185094759972e-05f
#define DIVBY2147483647 4.6566128752458e-10f

#if !NO_CONVERTERS

static void SDLCALL
SDL_Convert_U8_to_S8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Sint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U8 to AUDIO_S8.\n");
#endif

    src = (const Uint8 *) cvt->buf;
    dst = (Sint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, ++src, ++dst) {
        const Sint8 val = ((*src) ^ 0x80);
        *dst = ((Sint8) val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S8);
    }
}

static void SDLCALL
SDL_Convert_U8_to_U16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U8 to AUDIO_U16LSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Uint16 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Uint16 val = (((Uint16) *src) << 8);
        *dst = SDL_SwapLE16(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16LSB);
    }
}

static void SDLCALL
SDL_Convert_U8_to_S16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U8 to AUDIO_S16LSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint16 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Sint16 val = (((Sint16) ((*src) ^ 0x80)) << 8);
        *dst = ((Sint16) SDL_SwapLE16(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16LSB);
    }
}

static void SDLCALL
SDL_Convert_U8_to_U16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U8 to AUDIO_U16MSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Uint16 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Uint16 val = (((Uint16) *src) << 8);
        *dst = SDL_SwapBE16(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16MSB);
    }
}

static void SDLCALL
SDL_Convert_U8_to_S16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U8 to AUDIO_S16MSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint16 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Sint16 val = (((Sint16) ((*src) ^ 0x80)) << 8);
        *dst = ((Sint16) SDL_SwapBE16(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16MSB);
    }
}

static void SDLCALL
SDL_Convert_U8_to_S32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U8 to AUDIO_S32LSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 4)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((*src) ^ 0x80)) << 24);
        *dst = ((Sint32) SDL_SwapLE32(val));
    }

    cvt->len_cvt *= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32LSB);
    }
}

static void SDLCALL
SDL_Convert_U8_to_S32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U8 to AUDIO_S32MSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 4)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((*src) ^ 0x80)) << 24);
        *dst = ((Sint32) SDL_SwapBE32(val));
    }

    cvt->len_cvt *= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32MSB);
    }
}

static void SDLCALL
SDL_Convert_U8_to_F32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U8 to AUDIO_F32LSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 4)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const float val = ((((float) *src) * DIVBY127) - 1.0f);
        *dst = SDL_SwapFloatLE(val);
    }

    cvt->len_cvt *= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32LSB);
    }
}

static void SDLCALL
SDL_Convert_U8_to_F32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U8 to AUDIO_F32MSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 4)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const float val = ((((float) *src) * DIVBY127) - 1.0f);
        *dst = SDL_SwapFloatBE(val);
    }

    cvt->len_cvt *= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32MSB);
    }
}

static void SDLCALL
SDL_Convert_S8_to_U8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Uint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S8 to AUDIO_U8.\n");
#endif

    src = (const Uint8 *) cvt->buf;
    dst = (Uint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, ++src, ++dst) {
        const Uint8 val = ((((Sint8) *src)) ^ 0x80);
        *dst = val;
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U8);
    }
}

static void SDLCALL
SDL_Convert_S8_to_U16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S8 to AUDIO_U16LSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Uint16 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Uint16 val = (((Uint16) ((((Sint8) *src)) ^ 0x80)) << 8);
        *dst = SDL_SwapLE16(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16LSB);
    }
}

static void SDLCALL
SDL_Convert_S8_to_S16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S8 to AUDIO_S16LSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint16 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Sint16 val = (((Sint16) ((Sint8) *src)) << 8);
        *dst = ((Sint16) SDL_SwapLE16(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16LSB);
    }
}

static void SDLCALL
SDL_Convert_S8_to_U16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S8 to AUDIO_U16MSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Uint16 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Uint16 val = (((Uint16) ((((Sint8) *src)) ^ 0x80)) << 8);
        *dst = SDL_SwapBE16(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16MSB);
    }
}

static void SDLCALL
SDL_Convert_S8_to_S16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S8 to AUDIO_S16MSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint16 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Sint16 val = (((Sint16) ((Sint8) *src)) << 8);
        *dst = ((Sint16) SDL_SwapBE16(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16MSB);
    }
}

static void SDLCALL
SDL_Convert_S8_to_S32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S8 to AUDIO_S32LSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 4)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((Sint8) *src)) << 24);
        *dst = ((Sint32) SDL_SwapLE32(val));
    }

    cvt->len_cvt *= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32LSB);
    }
}

static void SDLCALL
SDL_Convert_S8_to_S32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S8 to AUDIO_S32MSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 4)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((Sint8) *src)) << 24);
        *dst = ((Sint32) SDL_SwapBE32(val));
    }

    cvt->len_cvt *= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32MSB);
    }
}

static void SDLCALL
SDL_Convert_S8_to_F32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S8 to AUDIO_F32LSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 4)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const float val = (((float) ((Sint8) *src)) * DIVBY127);
        *dst = SDL_SwapFloatLE(val);
    }

    cvt->len_cvt *= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32LSB);
    }
}

static void SDLCALL
SDL_Convert_S8_to_F32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint8 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S8 to AUDIO_F32MSB.\n");
#endif

    src = ((const Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 4)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint8); i; --i, --src, --dst) {
        const float val = (((float) ((Sint8) *src)) * DIVBY127);
        *dst = SDL_SwapFloatBE(val);
    }

    cvt->len_cvt *= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32MSB);
    }
}

static void SDLCALL
SDL_Convert_U16LSB_to_U8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16LSB to AUDIO_U8.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint8 val = ((Uint8) (SDL_SwapLE16(*src) >> 8));
        *dst = val;
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U8);
    }
}

static void SDLCALL
SDL_Convert_U16LSB_to_S8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16LSB to AUDIO_S8.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint8 val = ((Sint8) (((SDL_SwapLE16(*src)) ^ 0x8000) >> 8));
        *dst = ((Sint8) val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S8);
    }
}

static void SDLCALL
SDL_Convert_U16LSB_to_S16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16LSB to AUDIO_S16LSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint16 val = ((SDL_SwapLE16(*src)) ^ 0x8000);
        *dst = ((Sint16) SDL_SwapLE16(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16LSB);
    }
}

static void SDLCALL
SDL_Convert_U16LSB_to_U16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16LSB to AUDIO_U16MSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint16 val = SDL_SwapLE16(*src);
        *dst = SDL_SwapBE16(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16MSB);
    }
}

static void SDLCALL
SDL_Convert_U16LSB_to_S16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16LSB to AUDIO_S16MSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint16 val = ((SDL_SwapLE16(*src)) ^ 0x8000);
        *dst = ((Sint16) SDL_SwapBE16(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16MSB);
    }
}

static void SDLCALL
SDL_Convert_U16LSB_to_S32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16LSB to AUDIO_S32LSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((SDL_SwapLE16(*src)) ^ 0x8000)) << 16);
        *dst = ((Sint32) SDL_SwapLE32(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32LSB);
    }
}

static void SDLCALL
SDL_Convert_U16LSB_to_S32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16LSB to AUDIO_S32MSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((SDL_SwapLE16(*src)) ^ 0x8000)) << 16);
        *dst = ((Sint32) SDL_SwapBE32(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32MSB);
    }
}

static void SDLCALL
SDL_Convert_U16LSB_to_F32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16LSB to AUDIO_F32LSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const float val = ((((float) SDL_SwapLE16(*src)) * DIVBY32767) - 1.0f);
        *dst = SDL_SwapFloatLE(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32LSB);
    }
}

static void SDLCALL
SDL_Convert_U16LSB_to_F32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16LSB to AUDIO_F32MSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const float val = ((((float) SDL_SwapLE16(*src)) * DIVBY32767) - 1.0f);
        *dst = SDL_SwapFloatBE(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32MSB);
    }
}

static void SDLCALL
SDL_Convert_S16LSB_to_U8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16LSB to AUDIO_U8.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint8 val = ((Uint8) (((((Sint16) SDL_SwapLE16(*src))) ^ 0x8000) >> 8));
        *dst = val;
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U8);
    }
}

static void SDLCALL
SDL_Convert_S16LSB_to_S8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16LSB to AUDIO_S8.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint8 val = ((Sint8) (((Sint16) SDL_SwapLE16(*src)) >> 8));
        *dst = ((Sint8) val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S8);
    }
}

static void SDLCALL
SDL_Convert_S16LSB_to_U16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16LSB to AUDIO_U16LSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint16 val = ((((Sint16) SDL_SwapLE16(*src))) ^ 0x8000);
        *dst = SDL_SwapLE16(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16LSB);
    }
}

static void SDLCALL
SDL_Convert_S16LSB_to_U16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16LSB to AUDIO_U16MSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint16 val = ((((Sint16) SDL_SwapLE16(*src))) ^ 0x8000);
        *dst = SDL_SwapBE16(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16MSB);
    }
}

static void SDLCALL
SDL_Convert_S16LSB_to_S16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16LSB to AUDIO_S16MSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) SDL_SwapLE16(*src));
        *dst = ((Sint16) SDL_SwapBE16(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16MSB);
    }
}

static void SDLCALL
SDL_Convert_S16LSB_to_S32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16LSB to AUDIO_S32LSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((Sint16) SDL_SwapLE16(*src))) << 16);
        *dst = ((Sint32) SDL_SwapLE32(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32LSB);
    }
}

static void SDLCALL
SDL_Convert_S16LSB_to_S32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16LSB to AUDIO_S32MSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((Sint16) SDL_SwapLE16(*src))) << 16);
        *dst = ((Sint32) SDL_SwapBE32(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32MSB);
    }
}

static void SDLCALL
SDL_Convert_S16LSB_to_F32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16LSB to AUDIO_F32LSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const float val = (((float) ((Sint16) SDL_SwapLE16(*src))) * DIVBY32767);
        *dst = SDL_SwapFloatLE(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32LSB);
    }
}

static void SDLCALL
SDL_Convert_S16LSB_to_F32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16LSB to AUDIO_F32MSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const float val = (((float) ((Sint16) SDL_SwapLE16(*src))) * DIVBY32767);
        *dst = SDL_SwapFloatBE(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32MSB);
    }
}

static void SDLCALL
SDL_Convert_U16MSB_to_U8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16MSB to AUDIO_U8.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint8 val = ((Uint8) (SDL_SwapBE16(*src) >> 8));
        *dst = val;
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U8);
    }
}

static void SDLCALL
SDL_Convert_U16MSB_to_S8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16MSB to AUDIO_S8.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint8 val = ((Sint8) (((SDL_SwapBE16(*src)) ^ 0x8000) >> 8));
        *dst = ((Sint8) val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S8);
    }
}

static void SDLCALL
SDL_Convert_U16MSB_to_U16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16MSB to AUDIO_U16LSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint16 val = SDL_SwapBE16(*src);
        *dst = SDL_SwapLE16(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16LSB);
    }
}

static void SDLCALL
SDL_Convert_U16MSB_to_S16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16MSB to AUDIO_S16LSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint16 val = ((SDL_SwapBE16(*src)) ^ 0x8000);
        *dst = ((Sint16) SDL_SwapLE16(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16LSB);
    }
}

static void SDLCALL
SDL_Convert_U16MSB_to_S16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16MSB to AUDIO_S16MSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint16 val = ((SDL_SwapBE16(*src)) ^ 0x8000);
        *dst = ((Sint16) SDL_SwapBE16(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16MSB);
    }
}

static void SDLCALL
SDL_Convert_U16MSB_to_S32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16MSB to AUDIO_S32LSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((SDL_SwapBE16(*src)) ^ 0x8000)) << 16);
        *dst = ((Sint32) SDL_SwapLE32(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32LSB);
    }
}

static void SDLCALL
SDL_Convert_U16MSB_to_S32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16MSB to AUDIO_S32MSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((SDL_SwapBE16(*src)) ^ 0x8000)) << 16);
        *dst = ((Sint32) SDL_SwapBE32(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32MSB);
    }
}

static void SDLCALL
SDL_Convert_U16MSB_to_F32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16MSB to AUDIO_F32LSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const float val = ((((float) SDL_SwapBE16(*src)) * DIVBY32767) - 1.0f);
        *dst = SDL_SwapFloatLE(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32LSB);
    }
}

static void SDLCALL
SDL_Convert_U16MSB_to_F32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_U16MSB to AUDIO_F32MSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const float val = ((((float) SDL_SwapBE16(*src)) * DIVBY32767) - 1.0f);
        *dst = SDL_SwapFloatBE(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32MSB);
    }
}

static void SDLCALL
SDL_Convert_S16MSB_to_U8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16MSB to AUDIO_U8.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint8 val = ((Uint8) (((((Sint16) SDL_SwapBE16(*src))) ^ 0x8000) >> 8));
        *dst = val;
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U8);
    }
}

static void SDLCALL
SDL_Convert_S16MSB_to_S8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16MSB to AUDIO_S8.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint8 val = ((Sint8) (((Sint16) SDL_SwapBE16(*src)) >> 8));
        *dst = ((Sint8) val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S8);
    }
}

static void SDLCALL
SDL_Convert_S16MSB_to_U16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16MSB to AUDIO_U16LSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint16 val = ((((Sint16) SDL_SwapBE16(*src))) ^ 0x8000);
        *dst = SDL_SwapLE16(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16LSB);
    }
}

static void SDLCALL
SDL_Convert_S16MSB_to_S16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16MSB to AUDIO_S16LSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) SDL_SwapBE16(*src));
        *dst = ((Sint16) SDL_SwapLE16(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16LSB);
    }
}

static void SDLCALL
SDL_Convert_S16MSB_to_U16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16MSB to AUDIO_U16MSB.\n");
#endif

    src = (const Uint16 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, ++src, ++dst) {
        const Uint16 val = ((((Sint16) SDL_SwapBE16(*src))) ^ 0x8000);
        *dst = SDL_SwapBE16(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16MSB);
    }
}

static void SDLCALL
SDL_Convert_S16MSB_to_S32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16MSB to AUDIO_S32LSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((Sint16) SDL_SwapBE16(*src))) << 16);
        *dst = ((Sint32) SDL_SwapLE32(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32LSB);
    }
}

static void SDLCALL
SDL_Convert_S16MSB_to_S32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16MSB to AUDIO_S32MSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((Sint32 *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const Sint32 val = (((Sint32) ((Sint16) SDL_SwapBE16(*src))) << 16);
        *dst = ((Sint32) SDL_SwapBE32(val));
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32MSB);
    }
}

static void SDLCALL
SDL_Convert_S16MSB_to_F32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16MSB to AUDIO_F32LSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const float val = (((float) ((Sint16) SDL_SwapBE16(*src))) * DIVBY32767);
        *dst = SDL_SwapFloatLE(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32LSB);
    }
}

static void SDLCALL
SDL_Convert_S16MSB_to_F32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint16 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S16MSB to AUDIO_F32MSB.\n");
#endif

    src = ((const Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    dst = ((float *) (cvt->buf + cvt->len_cvt * 2)) - 1;
    for (i = cvt->len_cvt / sizeof (Uint16); i; --i, --src, --dst) {
        const float val = (((float) ((Sint16) SDL_SwapBE16(*src))) * DIVBY32767);
        *dst = SDL_SwapFloatBE(val);
    }

    cvt->len_cvt *= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32MSB);
    }
}

static void SDLCALL
SDL_Convert_S32LSB_to_U8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Uint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32LSB to AUDIO_U8.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Uint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Uint8 val = ((Uint8) (((((Sint32) SDL_SwapLE32(*src))) ^ 0x80000000) >> 24));
        *dst = val;
    }

    cvt->len_cvt /= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U8);
    }
}

static void SDLCALL
SDL_Convert_S32LSB_to_S8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Sint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32LSB to AUDIO_S8.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Sint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Sint8 val = ((Sint8) (((Sint32) SDL_SwapLE32(*src)) >> 24));
        *dst = ((Sint8) val);
    }

    cvt->len_cvt /= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S8);
    }
}

static void SDLCALL
SDL_Convert_S32LSB_to_U16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32LSB to AUDIO_U16LSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Uint16 val = ((Uint16) (((((Sint32) SDL_SwapLE32(*src))) ^ 0x80000000) >> 16));
        *dst = SDL_SwapLE16(val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16LSB);
    }
}

static void SDLCALL
SDL_Convert_S32LSB_to_S16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32LSB to AUDIO_S16LSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) (((Sint32) SDL_SwapLE32(*src)) >> 16));
        *dst = ((Sint16) SDL_SwapLE16(val));
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16LSB);
    }
}

static void SDLCALL
SDL_Convert_S32LSB_to_U16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32LSB to AUDIO_U16MSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Uint16 val = ((Uint16) (((((Sint32) SDL_SwapLE32(*src))) ^ 0x80000000) >> 16));
        *dst = SDL_SwapBE16(val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16MSB);
    }
}

static void SDLCALL
SDL_Convert_S32LSB_to_S16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32LSB to AUDIO_S16MSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) (((Sint32) SDL_SwapLE32(*src)) >> 16));
        *dst = ((Sint16) SDL_SwapBE16(val));
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16MSB);
    }
}

static void SDLCALL
SDL_Convert_S32LSB_to_S32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32LSB to AUDIO_S32MSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Sint32 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Sint32 val = ((Sint32) SDL_SwapLE32(*src));
        *dst = ((Sint32) SDL_SwapBE32(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32MSB);
    }
}

static void SDLCALL
SDL_Convert_S32LSB_to_F32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32LSB to AUDIO_F32LSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (float *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const float val = (((float) ((Sint32) SDL_SwapLE32(*src))) * DIVBY2147483647);
        *dst = SDL_SwapFloatLE(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32LSB);
    }
}

static void SDLCALL
SDL_Convert_S32LSB_to_F32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32LSB to AUDIO_F32MSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (float *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const float val = (((float) ((Sint32) SDL_SwapLE32(*src))) * DIVBY2147483647);
        *dst = SDL_SwapFloatBE(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32MSB);
    }
}

static void SDLCALL
SDL_Convert_S32MSB_to_U8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Uint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32MSB to AUDIO_U8.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Uint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Uint8 val = ((Uint8) (((((Sint32) SDL_SwapBE32(*src))) ^ 0x80000000) >> 24));
        *dst = val;
    }

    cvt->len_cvt /= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U8);
    }
}

static void SDLCALL
SDL_Convert_S32MSB_to_S8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Sint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32MSB to AUDIO_S8.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Sint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Sint8 val = ((Sint8) (((Sint32) SDL_SwapBE32(*src)) >> 24));
        *dst = ((Sint8) val);
    }

    cvt->len_cvt /= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S8);
    }
}

static void SDLCALL
SDL_Convert_S32MSB_to_U16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32MSB to AUDIO_U16LSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Uint16 val = ((Uint16) (((((Sint32) SDL_SwapBE32(*src))) ^ 0x80000000) >> 16));
        *dst = SDL_SwapLE16(val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16LSB);
    }
}

static void SDLCALL
SDL_Convert_S32MSB_to_S16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32MSB to AUDIO_S16LSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) (((Sint32) SDL_SwapBE32(*src)) >> 16));
        *dst = ((Sint16) SDL_SwapLE16(val));
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16LSB);
    }
}

static void SDLCALL
SDL_Convert_S32MSB_to_U16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32MSB to AUDIO_U16MSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Uint16 val = ((Uint16) (((((Sint32) SDL_SwapBE32(*src))) ^ 0x80000000) >> 16));
        *dst = SDL_SwapBE16(val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16MSB);
    }
}

static void SDLCALL
SDL_Convert_S32MSB_to_S16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32MSB to AUDIO_S16MSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) (((Sint32) SDL_SwapBE32(*src)) >> 16));
        *dst = ((Sint16) SDL_SwapBE16(val));
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16MSB);
    }
}

static void SDLCALL
SDL_Convert_S32MSB_to_S32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32MSB to AUDIO_S32LSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (Sint32 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const Sint32 val = ((Sint32) SDL_SwapBE32(*src));
        *dst = ((Sint32) SDL_SwapLE32(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32LSB);
    }
}

static void SDLCALL
SDL_Convert_S32MSB_to_F32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32MSB to AUDIO_F32LSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (float *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const float val = (((float) ((Sint32) SDL_SwapBE32(*src))) * DIVBY2147483647);
        *dst = SDL_SwapFloatLE(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32LSB);
    }
}

static void SDLCALL
SDL_Convert_S32MSB_to_F32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const Uint32 *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_S32MSB to AUDIO_F32MSB.\n");
#endif

    src = (const Uint32 *) cvt->buf;
    dst = (float *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (Uint32); i; --i, ++src, ++dst) {
        const float val = (((float) ((Sint32) SDL_SwapBE32(*src))) * DIVBY2147483647);
        *dst = SDL_SwapFloatBE(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32MSB);
    }
}

static void SDLCALL
SDL_Convert_F32LSB_to_U8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Uint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32LSB to AUDIO_U8.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Uint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Uint8 val = ((Uint8) ((SDL_SwapFloatLE(*src) + 1.0f) * 127.0f));
        *dst = val;
    }

    cvt->len_cvt /= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U8);
    }
}

static void SDLCALL
SDL_Convert_F32LSB_to_S8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32LSB to AUDIO_S8.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint8 val = ((Sint8) (SDL_SwapFloatLE(*src) * 127.0f));
        *dst = ((Sint8) val);
    }

    cvt->len_cvt /= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S8);
    }
}

static void SDLCALL
SDL_Convert_F32LSB_to_U16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32LSB to AUDIO_U16LSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Uint16 val = ((Uint16) ((SDL_SwapFloatLE(*src) + 1.0f) * 32767.0f));
        *dst = SDL_SwapLE16(val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16LSB);
    }
}

static void SDLCALL
SDL_Convert_F32LSB_to_S16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32LSB to AUDIO_S16LSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) (SDL_SwapFloatLE(*src) * 32767.0f));
        *dst = ((Sint16) SDL_SwapLE16(val));
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16LSB);
    }
}

static void SDLCALL
SDL_Convert_F32LSB_to_U16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32LSB to AUDIO_U16MSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Uint16 val = ((Uint16) ((SDL_SwapFloatLE(*src) + 1.0f) * 32767.0f));
        *dst = SDL_SwapBE16(val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16MSB);
    }
}

static void SDLCALL
SDL_Convert_F32LSB_to_S16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32LSB to AUDIO_S16MSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) (SDL_SwapFloatLE(*src) * 32767.0f));
        *dst = ((Sint16) SDL_SwapBE16(val));
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16MSB);
    }
}

static void SDLCALL
SDL_Convert_F32LSB_to_S32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32LSB to AUDIO_S32LSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint32 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint32 val = ((Sint32) (SDL_SwapFloatLE(*src) * 2147483647.0));
        *dst = ((Sint32) SDL_SwapLE32(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32LSB);
    }
}

static void SDLCALL
SDL_Convert_F32LSB_to_S32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32LSB to AUDIO_S32MSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint32 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint32 val = ((Sint32) (SDL_SwapFloatLE(*src) * 2147483647.0));
        *dst = ((Sint32) SDL_SwapBE32(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32MSB);
    }
}

static void SDLCALL
SDL_Convert_F32LSB_to_F32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32LSB to AUDIO_F32MSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (float *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const float val = SDL_SwapFloatLE(*src);
        *dst = SDL_SwapFloatBE(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32MSB);
    }
}

static void SDLCALL
SDL_Convert_F32MSB_to_U8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Uint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32MSB to AUDIO_U8.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Uint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Uint8 val = ((Uint8) ((SDL_SwapFloatBE(*src) + 1.0f) * 127.0f));
        *dst = val;
    }

    cvt->len_cvt /= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U8);
    }
}

static void SDLCALL
SDL_Convert_F32MSB_to_S8(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint8 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32MSB to AUDIO_S8.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint8 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint8 val = ((Sint8) (SDL_SwapFloatBE(*src) * 127.0f));
        *dst = ((Sint8) val);
    }

    cvt->len_cvt /= 4;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S8);
    }
}

static void SDLCALL
SDL_Convert_F32MSB_to_U16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32MSB to AUDIO_U16LSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Uint16 val = ((Uint16) ((SDL_SwapFloatBE(*src) + 1.0f) * 32767.0f));
        *dst = SDL_SwapLE16(val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16LSB);
    }
}

static void SDLCALL
SDL_Convert_F32MSB_to_S16LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32MSB to AUDIO_S16LSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) (SDL_SwapFloatBE(*src) * 32767.0f));
        *dst = ((Sint16) SDL_SwapLE16(val));
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16LSB);
    }
}

static void SDLCALL
SDL_Convert_F32MSB_to_U16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Uint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32MSB to AUDIO_U16MSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Uint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Uint16 val = ((Uint16) ((SDL_SwapFloatBE(*src) + 1.0f) * 32767.0f));
        *dst = SDL_SwapBE16(val);
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_U16MSB);
    }
}

static void SDLCALL
SDL_Convert_F32MSB_to_S16MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint16 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32MSB to AUDIO_S16MSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint16 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint16 val = ((Sint16) (SDL_SwapFloatBE(*src) * 32767.0f));
        *dst = ((Sint16) SDL_SwapBE16(val));
    }

    cvt->len_cvt /= 2;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S16MSB);
    }
}

static void SDLCALL
SDL_Convert_F32MSB_to_S32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32MSB to AUDIO_S32LSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint32 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint32 val = ((Sint32) (SDL_SwapFloatBE(*src) * 2147483647.0));
        *dst = ((Sint32) SDL_SwapLE32(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32LSB);
    }
}

static void SDLCALL
SDL_Convert_F32MSB_to_S32MSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    Sint32 *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32MSB to AUDIO_S32MSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (Sint32 *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const Sint32 val = ((Sint32) (SDL_SwapFloatBE(*src) * 2147483647.0));
        *dst = ((Sint32) SDL_SwapBE32(val));
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_S32MSB);
    }
}

static void SDLCALL
SDL_Convert_F32MSB_to_F32LSB(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
    int i;
    const float *src;
    float *dst;

#if DEBUG_CONVERT
    fprintf(stderr, "Converting AUDIO_F32MSB to AUDIO_F32LSB.\n");
#endif

    src = (const float *) cvt->buf;
    dst = (float *) cvt->buf;
    for (i = cvt->len_cvt / sizeof (float); i; --i, ++src, ++dst) {
        const float val = SDL_SwapFloatBE(*src);
        *dst = SDL_SwapFloatLE(val);
    }

    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, AUDIO_F32LSB);
    }
}

#endif  /* !NO_CONVERTERS */


const SDL_AudioTypeFilters sdl_audio_type_filters[] =
{
#if !NO_CONVERTERS
    { AUDIO_U8, AUDIO_S8, SDL_Convert_U8_to_S8 },
    { AUDIO_U8, AUDIO_U16LSB, SDL_Convert_U8_to_U16LSB },
    { AUDIO_U8, AUDIO_S16LSB, SDL_Convert_U8_to_S16LSB },
    { AUDIO_U8, AUDIO_U16MSB, SDL_Convert_U8_to_U16MSB },
    { AUDIO_U8, AUDIO_S16MSB, SDL_Convert_U8_to_S16MSB },
    { AUDIO_U8, AUDIO_S32LSB, SDL_Convert_U8_to_S32LSB },
    { AUDIO_U8, AUDIO_S32MSB, SDL_Convert_U8_to_S32MSB },
    { AUDIO_U8, AUDIO_F32LSB, SDL_Convert_U8_to_F32LSB },
    { AUDIO_U8, AUDIO_F32MSB, SDL_Convert_U8_to_F32MSB },
    { AUDIO_S8, AUDIO_U8, SDL_Convert_S8_to_U8 },
    { AUDIO_S8, AUDIO_U16LSB, SDL_Convert_S8_to_U16LSB },
    { AUDIO_S8, AUDIO_S16LSB, SDL_Convert_S8_to_S16LSB },
    { AUDIO_S8, AUDIO_U16MSB, SDL_Convert_S8_to_U16MSB },
    { AUDIO_S8, AUDIO_S16MSB, SDL_Convert_S8_to_S16MSB },
    { AUDIO_S8, AUDIO_S32LSB, SDL_Convert_S8_to_S32LSB },
    { AUDIO_S8, AUDIO_S32MSB, SDL_Convert_S8_to_S32MSB },
    { AUDIO_S8, AUDIO_F32LSB, SDL_Convert_S8_to_F32LSB },
    { AUDIO_S8, AUDIO_F32MSB, SDL_Convert_S8_to_F32MSB },
    { AUDIO_U16LSB, AUDIO_U8, SDL_Convert_U16LSB_to_U8 },
    { AUDIO_U16LSB, AUDIO_S8, SDL_Convert_U16LSB_to_S8 },
    { AUDIO_U16LSB, AUDIO_S16LSB, SDL_Convert_U16LSB_to_S16LSB },
    { AUDIO_U16LSB, AUDIO_U16MSB, SDL_Convert_U16LSB_to_U16MSB },
    { AUDIO_U16LSB, AUDIO_S16MSB, SDL_Convert_U16LSB_to_S16MSB },
    { AUDIO_U16LSB, AUDIO_S32LSB, SDL_Convert_U16LSB_to_S32LSB },
    { AUDIO_U16LSB, AUDIO_S32MSB, SDL_Convert_U16LSB_to_S32MSB },
    { AUDIO_U16LSB, AUDIO_F32LSB, SDL_Convert_U16LSB_to_F32LSB },
    { AUDIO_U16LSB, AUDIO_F32MSB, SDL_Convert_U16LSB_to_F32MSB },
    { AUDIO_S16LSB, AUDIO_U8, SDL_Convert_S16LSB_to_U8 },
    { AUDIO_S16LSB, AUDIO_S8, SDL_Convert_S16LSB_to_S8 },
    { AUDIO_S16LSB, AUDIO_U16LSB, SDL_Convert_S16LSB_to_U16LSB },
    { AUDIO_S16LSB, AUDIO_U16MSB, SDL_Convert_S16LSB_to_U16MSB },
    { AUDIO_S16LSB, AUDIO_S16MSB, SDL_Convert_S16LSB_to_S16MSB },
    { AUDIO_S16LSB, AUDIO_S32LSB, SDL_Convert_S16LSB_to_S32LSB },
    { AUDIO_S16LSB, AUDIO_S32MSB, SDL_Convert_S16LSB_to_S32MSB },
    { AUDIO_S16LSB, AUDIO_F32LSB, SDL_Convert_S16LSB_to_F32LSB },
    { AUDIO_S16LSB, AUDIO_F32MSB, SDL_Convert_S16LSB_to_F32MSB },
    { AUDIO_U16MSB, AUDIO_U8, SDL_Convert_U16MSB_to_U8 },
    { AUDIO_U16MSB, AUDIO_S8, SDL_Convert_U16MSB_to_S8 },
    { AUDIO_U16MSB, AUDIO_U16LSB, SDL_Convert_U16MSB_to_U16LSB },
    { AUDIO_U16MSB, AUDIO_S16LSB, SDL_Convert_U16MSB_to_S16LSB },
    { AUDIO_U16MSB, AUDIO_S16MSB, SDL_Convert_U16MSB_to_S16MSB },
    { AUDIO_U16MSB, AUDIO_S32LSB, SDL_Convert_U16MSB_to_S32LSB },
    { AUDIO_U16MSB, AUDIO_S32MSB, SDL_Convert_U16MSB_to_S32MSB },
    { AUDIO_U16MSB, AUDIO_F32LSB, SDL_Convert_U16MSB_to_F32LSB },
    { AUDIO_U16MSB, AUDIO_F32MSB, SDL_Convert_U16MSB_to_F32MSB },
    { AUDIO_S16MSB, AUDIO_U8, SDL_Convert_S16MSB_to_U8 },
    { AUDIO_S16MSB, AUDIO_S8, SDL_Convert_S16MSB_to_S8 },
    { AUDIO_S16MSB, AUDIO_U16LSB, SDL_Convert_S16MSB_to_U16LSB },
    { AUDIO_S16MSB, AUDIO_S16LSB, SDL_Convert_S16MSB_to_S16LSB },
    { AUDIO_S16MSB, AUDIO_U16MSB, SDL_Convert_S16MSB_to_U16MSB },
    { AUDIO_S16MSB, AUDIO_S32LSB, SDL_Convert_S16MSB_to_S32LSB },
    { AUDIO_S16MSB, AUDIO_S32MSB, SDL_Convert_S16MSB_to_S32MSB },
    { AUDIO_S16MSB, AUDIO_F32LSB, SDL_Convert_S16MSB_to_F32LSB },
    { AUDIO_S16MSB, AUDIO_F32MSB, SDL_Convert_S16MSB_to_F32MSB },
    { AUDIO_S32LSB, AUDIO_U8, SDL_Convert_S32LSB_to_U8 },
    { AUDIO_S32LSB, AUDIO_S8, SDL_Convert_S32LSB_to_S8 },
    { AUDIO_S32LSB, AUDIO_U16LSB, SDL_Convert_S32LSB_to_U16LSB },
    { AUDIO_S32LSB, AUDIO_S16LSB, SDL_Convert_S32LSB_to_S16LSB },
    { AUDIO_S32LSB, AUDIO_U16MSB, SDL_Convert_S32LSB_to_U16MSB },
    { AUDIO_S32LSB, AUDIO_S16MSB, SDL_Convert_S32LSB_to_S16MSB },
    { AUDIO_S32LSB, AUDIO_S32MSB, SDL_Convert_S32LSB_to_S32MSB },
    { AUDIO_S32LSB, AUDIO_F32LSB, SDL_Convert_S32LSB_to_F32LSB },
    { AUDIO_S32LSB, AUDIO_F32MSB, SDL_Convert_S32LSB_to_F32MSB },
    { AUDIO_S32MSB, AUDIO_U8, SDL_Convert_S32MSB_to_U8 },
    { AUDIO_S32MSB, AUDIO_S8, SDL_Convert_S32MSB_to_S8 },
    { AUDIO_S32MSB, AUDIO_U16LSB, SDL_Convert_S32MSB_to_U16LSB },
    { AUDIO_S32MSB, AUDIO_S16LSB, SDL_Convert_S32MSB_to_S16LSB },
    { AUDIO_S32MSB, AUDIO_U16MSB, SDL_Convert_S32MSB_to_U16MSB },
    { AUDIO_S32MSB, AUDIO_S16MSB, SDL_Convert_S32MSB_to_S16MSB },
    { AUDIO_S32MSB, AUDIO_S32LSB, SDL_Convert_S32MSB_to_S32LSB },
    { AUDIO_S32MSB, AUDIO_F32LSB, SDL_Convert_S32MSB_to_F32LSB },
    { AUDIO_S32MSB, AUDIO_F32MSB, SDL_Convert_S32MSB_to_F32MSB },
    { AUDIO_F32LSB, AUDIO_U8, SDL_Convert_F32LSB_to_U8 },
    { AUDIO_F32LSB, AUDIO_S8, SDL_Convert_F32LSB_to_S8 },
    { AUDIO_F32LSB, AUDIO_U16LSB, SDL_Convert_F32LSB_to_U16LSB },
    { AUDIO_F32LSB, AUDIO_S16LSB, SDL_Convert_F32LSB_to_S16LSB },
    { AUDIO_F32LSB, AUDIO_U16MSB, SDL_Convert_F32LSB_to_U16MSB },
    { AUDIO_F32LSB, AUDIO_S16MSB, SDL_Convert_F32LSB_to_S16MSB },
    { AUDIO_F32LSB, AUDIO_S32LSB, SDL_Convert_F32LSB_to_S32LSB },
    { AUDIO_F32LSB, AUDIO_S32MSB, SDL_Convert_F32LSB_to_S32MSB },
    { AUDIO_F32LSB, AUDIO_F32MSB, SDL_Convert_F32LSB_to_F32MSB },
    { AUDIO_F32MSB, AUDIO_U8, SDL_Convert_F32MSB_to_U8 },
    { AUDIO_F32MSB, AUDIO_S8, SDL_Convert_F32MSB_to_S8 },
    { AUDIO_F32MSB, AUDIO_U16LSB, SDL_Convert_F32MSB_to_U16LSB },
    { AUDIO_F32MSB, AUDIO_S16LSB, SDL_Convert_F32MSB_to_S16LSB },
    { AUDIO_F32MSB, AUDIO_U16MSB, SDL_Convert_F32MSB_to_U16MSB },
    { AUDIO_F32MSB, AUDIO_S16MSB, SDL_Convert_F32MSB_to_S16MSB },
    { AUDIO_F32MSB, AUDIO_S32LSB, SDL_Convert_F32MSB_to_S32LSB },
    { AUDIO_F32MSB, AUDIO_S32MSB, SDL_Convert_F32MSB_to_S32MSB },
    { AUDIO_F32MSB, AUDIO_F32LSB, SDL_Convert_F32MSB_to_F32LSB },
#endif  /* !NO_CONVERTERS */
    { 0, 0, NULL }
};


#if !NO_RESAMPLERS

static void SDLCALL
SDL_Upsample_U8_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U8, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 16;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 1;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 1;
    Uint8 sample0 = src[0];
    Uint8 last_sample0 = sample0;
    while (dst != target) {
        dst[0] = sample0;
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U8, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 16;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Uint8 sample0 = src[0];
    Uint8 last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = sample0;
            dst++;
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U8, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 2;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 2;
    Uint8 sample1 = src[1];
    Uint8 sample0 = src[0];
    Uint8 last_sample1 = sample1;
    Uint8 last_sample0 = sample0;
    while (dst != target) {
        dst[1] = sample1;
        dst[0] = sample0;
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (Uint8) ((((Sint16) src[1]) + ((Sint16) last_sample1)) >> 1);
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U8, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Uint8 sample0 = src[0];
    Uint8 sample1 = src[1];
    Uint8 last_sample0 = sample0;
    Uint8 last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = sample0;
            dst[1] = sample1;
            dst += 2;
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            sample1 = (Uint8) ((((Sint16) src[1]) + ((Sint16) last_sample1)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U8, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 4;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 4;
    Uint8 sample3 = src[3];
    Uint8 sample2 = src[2];
    Uint8 sample1 = src[1];
    Uint8 sample0 = src[0];
    Uint8 last_sample3 = sample3;
    Uint8 last_sample2 = sample2;
    Uint8 last_sample1 = sample1;
    Uint8 last_sample0 = sample0;
    while (dst != target) {
        dst[3] = sample3;
        dst[2] = sample2;
        dst[1] = sample1;
        dst[0] = sample0;
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (Uint8) ((((Sint16) src[3]) + ((Sint16) last_sample3)) >> 1);
            sample2 = (Uint8) ((((Sint16) src[2]) + ((Sint16) last_sample2)) >> 1);
            sample1 = (Uint8) ((((Sint16) src[1]) + ((Sint16) last_sample1)) >> 1);
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U8, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Uint8 sample0 = src[0];
    Uint8 sample1 = src[1];
    Uint8 sample2 = src[2];
    Uint8 sample3 = src[3];
    Uint8 last_sample0 = sample0;
    Uint8 last_sample1 = sample1;
    Uint8 last_sample2 = sample2;
    Uint8 last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = sample0;
            dst[1] = sample1;
            dst[2] = sample2;
            dst[3] = sample3;
            dst += 4;
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            sample1 = (Uint8) ((((Sint16) src[1]) + ((Sint16) last_sample1)) >> 1);
            sample2 = (Uint8) ((((Sint16) src[2]) + ((Sint16) last_sample2)) >> 1);
            sample3 = (Uint8) ((((Sint16) src[3]) + ((Sint16) last_sample3)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U8, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 96;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 6;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 6;
    Uint8 sample5 = src[5];
    Uint8 sample4 = src[4];
    Uint8 sample3 = src[3];
    Uint8 sample2 = src[2];
    Uint8 sample1 = src[1];
    Uint8 sample0 = src[0];
    Uint8 last_sample5 = sample5;
    Uint8 last_sample4 = sample4;
    Uint8 last_sample3 = sample3;
    Uint8 last_sample2 = sample2;
    Uint8 last_sample1 = sample1;
    Uint8 last_sample0 = sample0;
    while (dst != target) {
        dst[5] = sample5;
        dst[4] = sample4;
        dst[3] = sample3;
        dst[2] = sample2;
        dst[1] = sample1;
        dst[0] = sample0;
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (Uint8) ((((Sint16) src[5]) + ((Sint16) last_sample5)) >> 1);
            sample4 = (Uint8) ((((Sint16) src[4]) + ((Sint16) last_sample4)) >> 1);
            sample3 = (Uint8) ((((Sint16) src[3]) + ((Sint16) last_sample3)) >> 1);
            sample2 = (Uint8) ((((Sint16) src[2]) + ((Sint16) last_sample2)) >> 1);
            sample1 = (Uint8) ((((Sint16) src[1]) + ((Sint16) last_sample1)) >> 1);
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U8, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 96;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Uint8 sample0 = src[0];
    Uint8 sample1 = src[1];
    Uint8 sample2 = src[2];
    Uint8 sample3 = src[3];
    Uint8 sample4 = src[4];
    Uint8 sample5 = src[5];
    Uint8 last_sample0 = sample0;
    Uint8 last_sample1 = sample1;
    Uint8 last_sample2 = sample2;
    Uint8 last_sample3 = sample3;
    Uint8 last_sample4 = sample4;
    Uint8 last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = sample0;
            dst[1] = sample1;
            dst[2] = sample2;
            dst[3] = sample3;
            dst[4] = sample4;
            dst[5] = sample5;
            dst += 6;
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            sample1 = (Uint8) ((((Sint16) src[1]) + ((Sint16) last_sample1)) >> 1);
            sample2 = (Uint8) ((((Sint16) src[2]) + ((Sint16) last_sample2)) >> 1);
            sample3 = (Uint8) ((((Sint16) src[3]) + ((Sint16) last_sample3)) >> 1);
            sample4 = (Uint8) ((((Sint16) src[4]) + ((Sint16) last_sample4)) >> 1);
            sample5 = (Uint8) ((((Sint16) src[5]) + ((Sint16) last_sample5)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U8, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 8;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 8;
    Uint8 sample7 = src[7];
    Uint8 sample6 = src[6];
    Uint8 sample5 = src[5];
    Uint8 sample4 = src[4];
    Uint8 sample3 = src[3];
    Uint8 sample2 = src[2];
    Uint8 sample1 = src[1];
    Uint8 sample0 = src[0];
    Uint8 last_sample7 = sample7;
    Uint8 last_sample6 = sample6;
    Uint8 last_sample5 = sample5;
    Uint8 last_sample4 = sample4;
    Uint8 last_sample3 = sample3;
    Uint8 last_sample2 = sample2;
    Uint8 last_sample1 = sample1;
    Uint8 last_sample0 = sample0;
    while (dst != target) {
        dst[7] = sample7;
        dst[6] = sample6;
        dst[5] = sample5;
        dst[4] = sample4;
        dst[3] = sample3;
        dst[2] = sample2;
        dst[1] = sample1;
        dst[0] = sample0;
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (Uint8) ((((Sint16) src[7]) + ((Sint16) last_sample7)) >> 1);
            sample6 = (Uint8) ((((Sint16) src[6]) + ((Sint16) last_sample6)) >> 1);
            sample5 = (Uint8) ((((Sint16) src[5]) + ((Sint16) last_sample5)) >> 1);
            sample4 = (Uint8) ((((Sint16) src[4]) + ((Sint16) last_sample4)) >> 1);
            sample3 = (Uint8) ((((Sint16) src[3]) + ((Sint16) last_sample3)) >> 1);
            sample2 = (Uint8) ((((Sint16) src[2]) + ((Sint16) last_sample2)) >> 1);
            sample1 = (Uint8) ((((Sint16) src[1]) + ((Sint16) last_sample1)) >> 1);
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U8, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Uint8 sample0 = src[0];
    Uint8 sample1 = src[1];
    Uint8 sample2 = src[2];
    Uint8 sample3 = src[3];
    Uint8 sample4 = src[4];
    Uint8 sample5 = src[5];
    Uint8 sample6 = src[6];
    Uint8 sample7 = src[7];
    Uint8 last_sample0 = sample0;
    Uint8 last_sample1 = sample1;
    Uint8 last_sample2 = sample2;
    Uint8 last_sample3 = sample3;
    Uint8 last_sample4 = sample4;
    Uint8 last_sample5 = sample5;
    Uint8 last_sample6 = sample6;
    Uint8 last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = sample0;
            dst[1] = sample1;
            dst[2] = sample2;
            dst[3] = sample3;
            dst[4] = sample4;
            dst[5] = sample5;
            dst[6] = sample6;
            dst[7] = sample7;
            dst += 8;
            sample0 = (Uint8) ((((Sint16) src[0]) + ((Sint16) last_sample0)) >> 1);
            sample1 = (Uint8) ((((Sint16) src[1]) + ((Sint16) last_sample1)) >> 1);
            sample2 = (Uint8) ((((Sint16) src[2]) + ((Sint16) last_sample2)) >> 1);
            sample3 = (Uint8) ((((Sint16) src[3]) + ((Sint16) last_sample3)) >> 1);
            sample4 = (Uint8) ((((Sint16) src[4]) + ((Sint16) last_sample4)) >> 1);
            sample5 = (Uint8) ((((Sint16) src[5]) + ((Sint16) last_sample5)) >> 1);
            sample6 = (Uint8) ((((Sint16) src[6]) + ((Sint16) last_sample6)) >> 1);
            sample7 = (Uint8) ((((Sint16) src[7]) + ((Sint16) last_sample7)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S8, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 16;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 1;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 1;
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 last_sample0 = sample0;
    while (dst != target) {
        dst[0] = ((Sint8) sample0);
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S8, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 16;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint8) sample0);
            dst++;
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S8, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 2;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 2;
    Sint8 sample1 = ((Sint8) src[1]);
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 last_sample1 = sample1;
    Sint8 last_sample0 = sample0;
    while (dst != target) {
        dst[1] = ((Sint8) sample1);
        dst[0] = ((Sint8) sample0);
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (Sint8) ((((Sint16) ((Sint8) src[1])) + ((Sint16) last_sample1)) >> 1);
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S8, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 sample1 = ((Sint8) src[1]);
    Sint8 last_sample0 = sample0;
    Sint8 last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint8) sample0);
            dst[1] = ((Sint8) sample1);
            dst += 2;
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            sample1 = (Sint8) ((((Sint16) ((Sint8) src[1])) + ((Sint16) last_sample1)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S8, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 4;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 4;
    Sint8 sample3 = ((Sint8) src[3]);
    Sint8 sample2 = ((Sint8) src[2]);
    Sint8 sample1 = ((Sint8) src[1]);
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 last_sample3 = sample3;
    Sint8 last_sample2 = sample2;
    Sint8 last_sample1 = sample1;
    Sint8 last_sample0 = sample0;
    while (dst != target) {
        dst[3] = ((Sint8) sample3);
        dst[2] = ((Sint8) sample2);
        dst[1] = ((Sint8) sample1);
        dst[0] = ((Sint8) sample0);
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (Sint8) ((((Sint16) ((Sint8) src[3])) + ((Sint16) last_sample3)) >> 1);
            sample2 = (Sint8) ((((Sint16) ((Sint8) src[2])) + ((Sint16) last_sample2)) >> 1);
            sample1 = (Sint8) ((((Sint16) ((Sint8) src[1])) + ((Sint16) last_sample1)) >> 1);
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S8, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 sample1 = ((Sint8) src[1]);
    Sint8 sample2 = ((Sint8) src[2]);
    Sint8 sample3 = ((Sint8) src[3]);
    Sint8 last_sample0 = sample0;
    Sint8 last_sample1 = sample1;
    Sint8 last_sample2 = sample2;
    Sint8 last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint8) sample0);
            dst[1] = ((Sint8) sample1);
            dst[2] = ((Sint8) sample2);
            dst[3] = ((Sint8) sample3);
            dst += 4;
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            sample1 = (Sint8) ((((Sint16) ((Sint8) src[1])) + ((Sint16) last_sample1)) >> 1);
            sample2 = (Sint8) ((((Sint16) ((Sint8) src[2])) + ((Sint16) last_sample2)) >> 1);
            sample3 = (Sint8) ((((Sint16) ((Sint8) src[3])) + ((Sint16) last_sample3)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S8, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 96;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 6;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 6;
    Sint8 sample5 = ((Sint8) src[5]);
    Sint8 sample4 = ((Sint8) src[4]);
    Sint8 sample3 = ((Sint8) src[3]);
    Sint8 sample2 = ((Sint8) src[2]);
    Sint8 sample1 = ((Sint8) src[1]);
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 last_sample5 = sample5;
    Sint8 last_sample4 = sample4;
    Sint8 last_sample3 = sample3;
    Sint8 last_sample2 = sample2;
    Sint8 last_sample1 = sample1;
    Sint8 last_sample0 = sample0;
    while (dst != target) {
        dst[5] = ((Sint8) sample5);
        dst[4] = ((Sint8) sample4);
        dst[3] = ((Sint8) sample3);
        dst[2] = ((Sint8) sample2);
        dst[1] = ((Sint8) sample1);
        dst[0] = ((Sint8) sample0);
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (Sint8) ((((Sint16) ((Sint8) src[5])) + ((Sint16) last_sample5)) >> 1);
            sample4 = (Sint8) ((((Sint16) ((Sint8) src[4])) + ((Sint16) last_sample4)) >> 1);
            sample3 = (Sint8) ((((Sint16) ((Sint8) src[3])) + ((Sint16) last_sample3)) >> 1);
            sample2 = (Sint8) ((((Sint16) ((Sint8) src[2])) + ((Sint16) last_sample2)) >> 1);
            sample1 = (Sint8) ((((Sint16) ((Sint8) src[1])) + ((Sint16) last_sample1)) >> 1);
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S8, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 96;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 sample1 = ((Sint8) src[1]);
    Sint8 sample2 = ((Sint8) src[2]);
    Sint8 sample3 = ((Sint8) src[3]);
    Sint8 sample4 = ((Sint8) src[4]);
    Sint8 sample5 = ((Sint8) src[5]);
    Sint8 last_sample0 = sample0;
    Sint8 last_sample1 = sample1;
    Sint8 last_sample2 = sample2;
    Sint8 last_sample3 = sample3;
    Sint8 last_sample4 = sample4;
    Sint8 last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint8) sample0);
            dst[1] = ((Sint8) sample1);
            dst[2] = ((Sint8) sample2);
            dst[3] = ((Sint8) sample3);
            dst[4] = ((Sint8) sample4);
            dst[5] = ((Sint8) sample5);
            dst += 6;
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            sample1 = (Sint8) ((((Sint16) ((Sint8) src[1])) + ((Sint16) last_sample1)) >> 1);
            sample2 = (Sint8) ((((Sint16) ((Sint8) src[2])) + ((Sint16) last_sample2)) >> 1);
            sample3 = (Sint8) ((((Sint16) ((Sint8) src[3])) + ((Sint16) last_sample3)) >> 1);
            sample4 = (Sint8) ((((Sint16) ((Sint8) src[4])) + ((Sint16) last_sample4)) >> 1);
            sample5 = (Sint8) ((((Sint16) ((Sint8) src[5])) + ((Sint16) last_sample5)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S8, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 8;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 8;
    Sint8 sample7 = ((Sint8) src[7]);
    Sint8 sample6 = ((Sint8) src[6]);
    Sint8 sample5 = ((Sint8) src[5]);
    Sint8 sample4 = ((Sint8) src[4]);
    Sint8 sample3 = ((Sint8) src[3]);
    Sint8 sample2 = ((Sint8) src[2]);
    Sint8 sample1 = ((Sint8) src[1]);
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 last_sample7 = sample7;
    Sint8 last_sample6 = sample6;
    Sint8 last_sample5 = sample5;
    Sint8 last_sample4 = sample4;
    Sint8 last_sample3 = sample3;
    Sint8 last_sample2 = sample2;
    Sint8 last_sample1 = sample1;
    Sint8 last_sample0 = sample0;
    while (dst != target) {
        dst[7] = ((Sint8) sample7);
        dst[6] = ((Sint8) sample6);
        dst[5] = ((Sint8) sample5);
        dst[4] = ((Sint8) sample4);
        dst[3] = ((Sint8) sample3);
        dst[2] = ((Sint8) sample2);
        dst[1] = ((Sint8) sample1);
        dst[0] = ((Sint8) sample0);
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (Sint8) ((((Sint16) ((Sint8) src[7])) + ((Sint16) last_sample7)) >> 1);
            sample6 = (Sint8) ((((Sint16) ((Sint8) src[6])) + ((Sint16) last_sample6)) >> 1);
            sample5 = (Sint8) ((((Sint16) ((Sint8) src[5])) + ((Sint16) last_sample5)) >> 1);
            sample4 = (Sint8) ((((Sint16) ((Sint8) src[4])) + ((Sint16) last_sample4)) >> 1);
            sample3 = (Sint8) ((((Sint16) ((Sint8) src[3])) + ((Sint16) last_sample3)) >> 1);
            sample2 = (Sint8) ((((Sint16) ((Sint8) src[2])) + ((Sint16) last_sample2)) >> 1);
            sample1 = (Sint8) ((((Sint16) ((Sint8) src[1])) + ((Sint16) last_sample1)) >> 1);
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S8, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint8 sample0 = ((Sint8) src[0]);
    Sint8 sample1 = ((Sint8) src[1]);
    Sint8 sample2 = ((Sint8) src[2]);
    Sint8 sample3 = ((Sint8) src[3]);
    Sint8 sample4 = ((Sint8) src[4]);
    Sint8 sample5 = ((Sint8) src[5]);
    Sint8 sample6 = ((Sint8) src[6]);
    Sint8 sample7 = ((Sint8) src[7]);
    Sint8 last_sample0 = sample0;
    Sint8 last_sample1 = sample1;
    Sint8 last_sample2 = sample2;
    Sint8 last_sample3 = sample3;
    Sint8 last_sample4 = sample4;
    Sint8 last_sample5 = sample5;
    Sint8 last_sample6 = sample6;
    Sint8 last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint8) sample0);
            dst[1] = ((Sint8) sample1);
            dst[2] = ((Sint8) sample2);
            dst[3] = ((Sint8) sample3);
            dst[4] = ((Sint8) sample4);
            dst[5] = ((Sint8) sample5);
            dst[6] = ((Sint8) sample6);
            dst[7] = ((Sint8) sample7);
            dst += 8;
            sample0 = (Sint8) ((((Sint16) ((Sint8) src[0])) + ((Sint16) last_sample0)) >> 1);
            sample1 = (Sint8) ((((Sint16) ((Sint8) src[1])) + ((Sint16) last_sample1)) >> 1);
            sample2 = (Sint8) ((((Sint16) ((Sint8) src[2])) + ((Sint16) last_sample2)) >> 1);
            sample3 = (Sint8) ((((Sint16) ((Sint8) src[3])) + ((Sint16) last_sample3)) >> 1);
            sample4 = (Sint8) ((((Sint16) ((Sint8) src[4])) + ((Sint16) last_sample4)) >> 1);
            sample5 = (Sint8) ((((Sint16) ((Sint8) src[5])) + ((Sint16) last_sample5)) >> 1);
            sample6 = (Sint8) ((((Sint16) ((Sint8) src[6])) + ((Sint16) last_sample6)) >> 1);
            sample7 = (Sint8) ((((Sint16) ((Sint8) src[7])) + ((Sint16) last_sample7)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16LSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 1;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 1;
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[0] = SDL_SwapLE16(sample0);
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16LSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapLE16(sample0);
            dst++;
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16LSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 2;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 2;
    Uint16 sample1 = SDL_SwapLE16(src[1]);
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 last_sample1 = sample1;
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[1] = SDL_SwapLE16(sample1);
        dst[0] = SDL_SwapLE16(sample0);
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (Uint16) ((((Sint32) SDL_SwapLE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16LSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 sample1 = SDL_SwapLE16(src[1]);
    Uint16 last_sample0 = sample0;
    Uint16 last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapLE16(sample0);
            dst[1] = SDL_SwapLE16(sample1);
            dst += 2;
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapLE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16LSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 4;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 4;
    Uint16 sample3 = SDL_SwapLE16(src[3]);
    Uint16 sample2 = SDL_SwapLE16(src[2]);
    Uint16 sample1 = SDL_SwapLE16(src[1]);
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 last_sample3 = sample3;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[3] = SDL_SwapLE16(sample3);
        dst[2] = SDL_SwapLE16(sample2);
        dst[1] = SDL_SwapLE16(sample1);
        dst[0] = SDL_SwapLE16(sample0);
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (Uint16) ((((Sint32) SDL_SwapLE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapLE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapLE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16LSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 sample1 = SDL_SwapLE16(src[1]);
    Uint16 sample2 = SDL_SwapLE16(src[2]);
    Uint16 sample3 = SDL_SwapLE16(src[3]);
    Uint16 last_sample0 = sample0;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapLE16(sample0);
            dst[1] = SDL_SwapLE16(sample1);
            dst[2] = SDL_SwapLE16(sample2);
            dst[3] = SDL_SwapLE16(sample3);
            dst += 4;
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapLE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapLE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapLE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16LSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 192;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 6;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 6;
    Uint16 sample5 = SDL_SwapLE16(src[5]);
    Uint16 sample4 = SDL_SwapLE16(src[4]);
    Uint16 sample3 = SDL_SwapLE16(src[3]);
    Uint16 sample2 = SDL_SwapLE16(src[2]);
    Uint16 sample1 = SDL_SwapLE16(src[1]);
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 last_sample5 = sample5;
    Uint16 last_sample4 = sample4;
    Uint16 last_sample3 = sample3;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[5] = SDL_SwapLE16(sample5);
        dst[4] = SDL_SwapLE16(sample4);
        dst[3] = SDL_SwapLE16(sample3);
        dst[2] = SDL_SwapLE16(sample2);
        dst[1] = SDL_SwapLE16(sample1);
        dst[0] = SDL_SwapLE16(sample0);
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (Uint16) ((((Sint32) SDL_SwapLE16(src[5])) + ((Sint32) last_sample5)) >> 1);
            sample4 = (Uint16) ((((Sint32) SDL_SwapLE16(src[4])) + ((Sint32) last_sample4)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapLE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapLE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapLE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16LSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 192;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 sample1 = SDL_SwapLE16(src[1]);
    Uint16 sample2 = SDL_SwapLE16(src[2]);
    Uint16 sample3 = SDL_SwapLE16(src[3]);
    Uint16 sample4 = SDL_SwapLE16(src[4]);
    Uint16 sample5 = SDL_SwapLE16(src[5]);
    Uint16 last_sample0 = sample0;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample3 = sample3;
    Uint16 last_sample4 = sample4;
    Uint16 last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapLE16(sample0);
            dst[1] = SDL_SwapLE16(sample1);
            dst[2] = SDL_SwapLE16(sample2);
            dst[3] = SDL_SwapLE16(sample3);
            dst[4] = SDL_SwapLE16(sample4);
            dst[5] = SDL_SwapLE16(sample5);
            dst += 6;
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapLE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapLE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapLE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample4 = (Uint16) ((((Sint32) SDL_SwapLE16(src[4])) + ((Sint32) last_sample4)) >> 1);
            sample5 = (Uint16) ((((Sint32) SDL_SwapLE16(src[5])) + ((Sint32) last_sample5)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16LSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 8;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 8;
    Uint16 sample7 = SDL_SwapLE16(src[7]);
    Uint16 sample6 = SDL_SwapLE16(src[6]);
    Uint16 sample5 = SDL_SwapLE16(src[5]);
    Uint16 sample4 = SDL_SwapLE16(src[4]);
    Uint16 sample3 = SDL_SwapLE16(src[3]);
    Uint16 sample2 = SDL_SwapLE16(src[2]);
    Uint16 sample1 = SDL_SwapLE16(src[1]);
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 last_sample7 = sample7;
    Uint16 last_sample6 = sample6;
    Uint16 last_sample5 = sample5;
    Uint16 last_sample4 = sample4;
    Uint16 last_sample3 = sample3;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[7] = SDL_SwapLE16(sample7);
        dst[6] = SDL_SwapLE16(sample6);
        dst[5] = SDL_SwapLE16(sample5);
        dst[4] = SDL_SwapLE16(sample4);
        dst[3] = SDL_SwapLE16(sample3);
        dst[2] = SDL_SwapLE16(sample2);
        dst[1] = SDL_SwapLE16(sample1);
        dst[0] = SDL_SwapLE16(sample0);
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (Uint16) ((((Sint32) SDL_SwapLE16(src[7])) + ((Sint32) last_sample7)) >> 1);
            sample6 = (Uint16) ((((Sint32) SDL_SwapLE16(src[6])) + ((Sint32) last_sample6)) >> 1);
            sample5 = (Uint16) ((((Sint32) SDL_SwapLE16(src[5])) + ((Sint32) last_sample5)) >> 1);
            sample4 = (Uint16) ((((Sint32) SDL_SwapLE16(src[4])) + ((Sint32) last_sample4)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapLE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapLE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapLE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16LSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapLE16(src[0]);
    Uint16 sample1 = SDL_SwapLE16(src[1]);
    Uint16 sample2 = SDL_SwapLE16(src[2]);
    Uint16 sample3 = SDL_SwapLE16(src[3]);
    Uint16 sample4 = SDL_SwapLE16(src[4]);
    Uint16 sample5 = SDL_SwapLE16(src[5]);
    Uint16 sample6 = SDL_SwapLE16(src[6]);
    Uint16 sample7 = SDL_SwapLE16(src[7]);
    Uint16 last_sample0 = sample0;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample3 = sample3;
    Uint16 last_sample4 = sample4;
    Uint16 last_sample5 = sample5;
    Uint16 last_sample6 = sample6;
    Uint16 last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapLE16(sample0);
            dst[1] = SDL_SwapLE16(sample1);
            dst[2] = SDL_SwapLE16(sample2);
            dst[3] = SDL_SwapLE16(sample3);
            dst[4] = SDL_SwapLE16(sample4);
            dst[5] = SDL_SwapLE16(sample5);
            dst[6] = SDL_SwapLE16(sample6);
            dst[7] = SDL_SwapLE16(sample7);
            dst += 8;
            sample0 = (Uint16) ((((Sint32) SDL_SwapLE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapLE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapLE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapLE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample4 = (Uint16) ((((Sint32) SDL_SwapLE16(src[4])) + ((Sint32) last_sample4)) >> 1);
            sample5 = (Uint16) ((((Sint32) SDL_SwapLE16(src[5])) + ((Sint32) last_sample5)) >> 1);
            sample6 = (Uint16) ((((Sint32) SDL_SwapLE16(src[6])) + ((Sint32) last_sample6)) >> 1);
            sample7 = (Uint16) ((((Sint32) SDL_SwapLE16(src[7])) + ((Sint32) last_sample7)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16LSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 1;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 1;
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[0] = ((Sint16) SDL_SwapLE16(sample0));
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16LSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapLE16(sample0));
            dst++;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16LSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 2;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 2;
    Sint16 sample1 = ((Sint16) SDL_SwapLE16(src[1]));
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 last_sample1 = sample1;
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[1] = ((Sint16) SDL_SwapLE16(sample1));
        dst[0] = ((Sint16) SDL_SwapLE16(sample0));
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16LSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 sample1 = ((Sint16) SDL_SwapLE16(src[1]));
    Sint16 last_sample0 = sample0;
    Sint16 last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapLE16(sample0));
            dst[1] = ((Sint16) SDL_SwapLE16(sample1));
            dst += 2;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16LSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 4;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 4;
    Sint16 sample3 = ((Sint16) SDL_SwapLE16(src[3]));
    Sint16 sample2 = ((Sint16) SDL_SwapLE16(src[2]));
    Sint16 sample1 = ((Sint16) SDL_SwapLE16(src[1]));
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 last_sample3 = sample3;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[3] = ((Sint16) SDL_SwapLE16(sample3));
        dst[2] = ((Sint16) SDL_SwapLE16(sample2));
        dst[1] = ((Sint16) SDL_SwapLE16(sample1));
        dst[0] = ((Sint16) SDL_SwapLE16(sample0));
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16LSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 sample1 = ((Sint16) SDL_SwapLE16(src[1]));
    Sint16 sample2 = ((Sint16) SDL_SwapLE16(src[2]));
    Sint16 sample3 = ((Sint16) SDL_SwapLE16(src[3]));
    Sint16 last_sample0 = sample0;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapLE16(sample0));
            dst[1] = ((Sint16) SDL_SwapLE16(sample1));
            dst[2] = ((Sint16) SDL_SwapLE16(sample2));
            dst[3] = ((Sint16) SDL_SwapLE16(sample3));
            dst += 4;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16LSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 192;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 6;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 6;
    Sint16 sample5 = ((Sint16) SDL_SwapLE16(src[5]));
    Sint16 sample4 = ((Sint16) SDL_SwapLE16(src[4]));
    Sint16 sample3 = ((Sint16) SDL_SwapLE16(src[3]));
    Sint16 sample2 = ((Sint16) SDL_SwapLE16(src[2]));
    Sint16 sample1 = ((Sint16) SDL_SwapLE16(src[1]));
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 last_sample5 = sample5;
    Sint16 last_sample4 = sample4;
    Sint16 last_sample3 = sample3;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[5] = ((Sint16) SDL_SwapLE16(sample5));
        dst[4] = ((Sint16) SDL_SwapLE16(sample4));
        dst[3] = ((Sint16) SDL_SwapLE16(sample3));
        dst[2] = ((Sint16) SDL_SwapLE16(sample2));
        dst[1] = ((Sint16) SDL_SwapLE16(sample1));
        dst[0] = ((Sint16) SDL_SwapLE16(sample0));
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[5]))) + ((Sint32) last_sample5)) >> 1);
            sample4 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[4]))) + ((Sint32) last_sample4)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16LSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 192;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 sample1 = ((Sint16) SDL_SwapLE16(src[1]));
    Sint16 sample2 = ((Sint16) SDL_SwapLE16(src[2]));
    Sint16 sample3 = ((Sint16) SDL_SwapLE16(src[3]));
    Sint16 sample4 = ((Sint16) SDL_SwapLE16(src[4]));
    Sint16 sample5 = ((Sint16) SDL_SwapLE16(src[5]));
    Sint16 last_sample0 = sample0;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample3 = sample3;
    Sint16 last_sample4 = sample4;
    Sint16 last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapLE16(sample0));
            dst[1] = ((Sint16) SDL_SwapLE16(sample1));
            dst[2] = ((Sint16) SDL_SwapLE16(sample2));
            dst[3] = ((Sint16) SDL_SwapLE16(sample3));
            dst[4] = ((Sint16) SDL_SwapLE16(sample4));
            dst[5] = ((Sint16) SDL_SwapLE16(sample5));
            dst += 6;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample4 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[4]))) + ((Sint32) last_sample4)) >> 1);
            sample5 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[5]))) + ((Sint32) last_sample5)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16LSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 8;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 8;
    Sint16 sample7 = ((Sint16) SDL_SwapLE16(src[7]));
    Sint16 sample6 = ((Sint16) SDL_SwapLE16(src[6]));
    Sint16 sample5 = ((Sint16) SDL_SwapLE16(src[5]));
    Sint16 sample4 = ((Sint16) SDL_SwapLE16(src[4]));
    Sint16 sample3 = ((Sint16) SDL_SwapLE16(src[3]));
    Sint16 sample2 = ((Sint16) SDL_SwapLE16(src[2]));
    Sint16 sample1 = ((Sint16) SDL_SwapLE16(src[1]));
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 last_sample7 = sample7;
    Sint16 last_sample6 = sample6;
    Sint16 last_sample5 = sample5;
    Sint16 last_sample4 = sample4;
    Sint16 last_sample3 = sample3;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[7] = ((Sint16) SDL_SwapLE16(sample7));
        dst[6] = ((Sint16) SDL_SwapLE16(sample6));
        dst[5] = ((Sint16) SDL_SwapLE16(sample5));
        dst[4] = ((Sint16) SDL_SwapLE16(sample4));
        dst[3] = ((Sint16) SDL_SwapLE16(sample3));
        dst[2] = ((Sint16) SDL_SwapLE16(sample2));
        dst[1] = ((Sint16) SDL_SwapLE16(sample1));
        dst[0] = ((Sint16) SDL_SwapLE16(sample0));
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[7]))) + ((Sint32) last_sample7)) >> 1);
            sample6 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[6]))) + ((Sint32) last_sample6)) >> 1);
            sample5 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[5]))) + ((Sint32) last_sample5)) >> 1);
            sample4 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[4]))) + ((Sint32) last_sample4)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16LSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapLE16(src[0]));
    Sint16 sample1 = ((Sint16) SDL_SwapLE16(src[1]));
    Sint16 sample2 = ((Sint16) SDL_SwapLE16(src[2]));
    Sint16 sample3 = ((Sint16) SDL_SwapLE16(src[3]));
    Sint16 sample4 = ((Sint16) SDL_SwapLE16(src[4]));
    Sint16 sample5 = ((Sint16) SDL_SwapLE16(src[5]));
    Sint16 sample6 = ((Sint16) SDL_SwapLE16(src[6]));
    Sint16 sample7 = ((Sint16) SDL_SwapLE16(src[7]));
    Sint16 last_sample0 = sample0;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample3 = sample3;
    Sint16 last_sample4 = sample4;
    Sint16 last_sample5 = sample5;
    Sint16 last_sample6 = sample6;
    Sint16 last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapLE16(sample0));
            dst[1] = ((Sint16) SDL_SwapLE16(sample1));
            dst[2] = ((Sint16) SDL_SwapLE16(sample2));
            dst[3] = ((Sint16) SDL_SwapLE16(sample3));
            dst[4] = ((Sint16) SDL_SwapLE16(sample4));
            dst[5] = ((Sint16) SDL_SwapLE16(sample5));
            dst[6] = ((Sint16) SDL_SwapLE16(sample6));
            dst[7] = ((Sint16) SDL_SwapLE16(sample7));
            dst += 8;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample4 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[4]))) + ((Sint32) last_sample4)) >> 1);
            sample5 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[5]))) + ((Sint32) last_sample5)) >> 1);
            sample6 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[6]))) + ((Sint32) last_sample6)) >> 1);
            sample7 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapLE16(src[7]))) + ((Sint32) last_sample7)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16MSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 1;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 1;
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[0] = SDL_SwapBE16(sample0);
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16MSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapBE16(sample0);
            dst++;
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16MSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 2;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 2;
    Uint16 sample1 = SDL_SwapBE16(src[1]);
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 last_sample1 = sample1;
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[1] = SDL_SwapBE16(sample1);
        dst[0] = SDL_SwapBE16(sample0);
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (Uint16) ((((Sint32) SDL_SwapBE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16MSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 sample1 = SDL_SwapBE16(src[1]);
    Uint16 last_sample0 = sample0;
    Uint16 last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapBE16(sample0);
            dst[1] = SDL_SwapBE16(sample1);
            dst += 2;
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapBE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16MSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 4;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 4;
    Uint16 sample3 = SDL_SwapBE16(src[3]);
    Uint16 sample2 = SDL_SwapBE16(src[2]);
    Uint16 sample1 = SDL_SwapBE16(src[1]);
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 last_sample3 = sample3;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[3] = SDL_SwapBE16(sample3);
        dst[2] = SDL_SwapBE16(sample2);
        dst[1] = SDL_SwapBE16(sample1);
        dst[0] = SDL_SwapBE16(sample0);
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (Uint16) ((((Sint32) SDL_SwapBE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapBE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapBE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16MSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 sample1 = SDL_SwapBE16(src[1]);
    Uint16 sample2 = SDL_SwapBE16(src[2]);
    Uint16 sample3 = SDL_SwapBE16(src[3]);
    Uint16 last_sample0 = sample0;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapBE16(sample0);
            dst[1] = SDL_SwapBE16(sample1);
            dst[2] = SDL_SwapBE16(sample2);
            dst[3] = SDL_SwapBE16(sample3);
            dst += 4;
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapBE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapBE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapBE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16MSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 192;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 6;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 6;
    Uint16 sample5 = SDL_SwapBE16(src[5]);
    Uint16 sample4 = SDL_SwapBE16(src[4]);
    Uint16 sample3 = SDL_SwapBE16(src[3]);
    Uint16 sample2 = SDL_SwapBE16(src[2]);
    Uint16 sample1 = SDL_SwapBE16(src[1]);
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 last_sample5 = sample5;
    Uint16 last_sample4 = sample4;
    Uint16 last_sample3 = sample3;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[5] = SDL_SwapBE16(sample5);
        dst[4] = SDL_SwapBE16(sample4);
        dst[3] = SDL_SwapBE16(sample3);
        dst[2] = SDL_SwapBE16(sample2);
        dst[1] = SDL_SwapBE16(sample1);
        dst[0] = SDL_SwapBE16(sample0);
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (Uint16) ((((Sint32) SDL_SwapBE16(src[5])) + ((Sint32) last_sample5)) >> 1);
            sample4 = (Uint16) ((((Sint32) SDL_SwapBE16(src[4])) + ((Sint32) last_sample4)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapBE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapBE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapBE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16MSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 192;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 sample1 = SDL_SwapBE16(src[1]);
    Uint16 sample2 = SDL_SwapBE16(src[2]);
    Uint16 sample3 = SDL_SwapBE16(src[3]);
    Uint16 sample4 = SDL_SwapBE16(src[4]);
    Uint16 sample5 = SDL_SwapBE16(src[5]);
    Uint16 last_sample0 = sample0;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample3 = sample3;
    Uint16 last_sample4 = sample4;
    Uint16 last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapBE16(sample0);
            dst[1] = SDL_SwapBE16(sample1);
            dst[2] = SDL_SwapBE16(sample2);
            dst[3] = SDL_SwapBE16(sample3);
            dst[4] = SDL_SwapBE16(sample4);
            dst[5] = SDL_SwapBE16(sample5);
            dst += 6;
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapBE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapBE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapBE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample4 = (Uint16) ((((Sint32) SDL_SwapBE16(src[4])) + ((Sint32) last_sample4)) >> 1);
            sample5 = (Uint16) ((((Sint32) SDL_SwapBE16(src[5])) + ((Sint32) last_sample5)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_U16MSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 8;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 8;
    Uint16 sample7 = SDL_SwapBE16(src[7]);
    Uint16 sample6 = SDL_SwapBE16(src[6]);
    Uint16 sample5 = SDL_SwapBE16(src[5]);
    Uint16 sample4 = SDL_SwapBE16(src[4]);
    Uint16 sample3 = SDL_SwapBE16(src[3]);
    Uint16 sample2 = SDL_SwapBE16(src[2]);
    Uint16 sample1 = SDL_SwapBE16(src[1]);
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 last_sample7 = sample7;
    Uint16 last_sample6 = sample6;
    Uint16 last_sample5 = sample5;
    Uint16 last_sample4 = sample4;
    Uint16 last_sample3 = sample3;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample0 = sample0;
    while (dst != target) {
        dst[7] = SDL_SwapBE16(sample7);
        dst[6] = SDL_SwapBE16(sample6);
        dst[5] = SDL_SwapBE16(sample5);
        dst[4] = SDL_SwapBE16(sample4);
        dst[3] = SDL_SwapBE16(sample3);
        dst[2] = SDL_SwapBE16(sample2);
        dst[1] = SDL_SwapBE16(sample1);
        dst[0] = SDL_SwapBE16(sample0);
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (Uint16) ((((Sint32) SDL_SwapBE16(src[7])) + ((Sint32) last_sample7)) >> 1);
            sample6 = (Uint16) ((((Sint32) SDL_SwapBE16(src[6])) + ((Sint32) last_sample6)) >> 1);
            sample5 = (Uint16) ((((Sint32) SDL_SwapBE16(src[5])) + ((Sint32) last_sample5)) >> 1);
            sample4 = (Uint16) ((((Sint32) SDL_SwapBE16(src[4])) + ((Sint32) last_sample4)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapBE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapBE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapBE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_U16MSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Uint16 sample0 = SDL_SwapBE16(src[0]);
    Uint16 sample1 = SDL_SwapBE16(src[1]);
    Uint16 sample2 = SDL_SwapBE16(src[2]);
    Uint16 sample3 = SDL_SwapBE16(src[3]);
    Uint16 sample4 = SDL_SwapBE16(src[4]);
    Uint16 sample5 = SDL_SwapBE16(src[5]);
    Uint16 sample6 = SDL_SwapBE16(src[6]);
    Uint16 sample7 = SDL_SwapBE16(src[7]);
    Uint16 last_sample0 = sample0;
    Uint16 last_sample1 = sample1;
    Uint16 last_sample2 = sample2;
    Uint16 last_sample3 = sample3;
    Uint16 last_sample4 = sample4;
    Uint16 last_sample5 = sample5;
    Uint16 last_sample6 = sample6;
    Uint16 last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapBE16(sample0);
            dst[1] = SDL_SwapBE16(sample1);
            dst[2] = SDL_SwapBE16(sample2);
            dst[3] = SDL_SwapBE16(sample3);
            dst[4] = SDL_SwapBE16(sample4);
            dst[5] = SDL_SwapBE16(sample5);
            dst[6] = SDL_SwapBE16(sample6);
            dst[7] = SDL_SwapBE16(sample7);
            dst += 8;
            sample0 = (Uint16) ((((Sint32) SDL_SwapBE16(src[0])) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Uint16) ((((Sint32) SDL_SwapBE16(src[1])) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Uint16) ((((Sint32) SDL_SwapBE16(src[2])) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Uint16) ((((Sint32) SDL_SwapBE16(src[3])) + ((Sint32) last_sample3)) >> 1);
            sample4 = (Uint16) ((((Sint32) SDL_SwapBE16(src[4])) + ((Sint32) last_sample4)) >> 1);
            sample5 = (Uint16) ((((Sint32) SDL_SwapBE16(src[5])) + ((Sint32) last_sample5)) >> 1);
            sample6 = (Uint16) ((((Sint32) SDL_SwapBE16(src[6])) + ((Sint32) last_sample6)) >> 1);
            sample7 = (Uint16) ((((Sint32) SDL_SwapBE16(src[7])) + ((Sint32) last_sample7)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16MSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 1;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 1;
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[0] = ((Sint16) SDL_SwapBE16(sample0));
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16MSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 32;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapBE16(sample0));
            dst++;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16MSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 2;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 2;
    Sint16 sample1 = ((Sint16) SDL_SwapBE16(src[1]));
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 last_sample1 = sample1;
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[1] = ((Sint16) SDL_SwapBE16(sample1));
        dst[0] = ((Sint16) SDL_SwapBE16(sample0));
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16MSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 sample1 = ((Sint16) SDL_SwapBE16(src[1]));
    Sint16 last_sample0 = sample0;
    Sint16 last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapBE16(sample0));
            dst[1] = ((Sint16) SDL_SwapBE16(sample1));
            dst += 2;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16MSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 4;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 4;
    Sint16 sample3 = ((Sint16) SDL_SwapBE16(src[3]));
    Sint16 sample2 = ((Sint16) SDL_SwapBE16(src[2]));
    Sint16 sample1 = ((Sint16) SDL_SwapBE16(src[1]));
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 last_sample3 = sample3;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[3] = ((Sint16) SDL_SwapBE16(sample3));
        dst[2] = ((Sint16) SDL_SwapBE16(sample2));
        dst[1] = ((Sint16) SDL_SwapBE16(sample1));
        dst[0] = ((Sint16) SDL_SwapBE16(sample0));
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16MSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 sample1 = ((Sint16) SDL_SwapBE16(src[1]));
    Sint16 sample2 = ((Sint16) SDL_SwapBE16(src[2]));
    Sint16 sample3 = ((Sint16) SDL_SwapBE16(src[3]));
    Sint16 last_sample0 = sample0;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapBE16(sample0));
            dst[1] = ((Sint16) SDL_SwapBE16(sample1));
            dst[2] = ((Sint16) SDL_SwapBE16(sample2));
            dst[3] = ((Sint16) SDL_SwapBE16(sample3));
            dst += 4;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16MSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 192;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 6;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 6;
    Sint16 sample5 = ((Sint16) SDL_SwapBE16(src[5]));
    Sint16 sample4 = ((Sint16) SDL_SwapBE16(src[4]));
    Sint16 sample3 = ((Sint16) SDL_SwapBE16(src[3]));
    Sint16 sample2 = ((Sint16) SDL_SwapBE16(src[2]));
    Sint16 sample1 = ((Sint16) SDL_SwapBE16(src[1]));
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 last_sample5 = sample5;
    Sint16 last_sample4 = sample4;
    Sint16 last_sample3 = sample3;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[5] = ((Sint16) SDL_SwapBE16(sample5));
        dst[4] = ((Sint16) SDL_SwapBE16(sample4));
        dst[3] = ((Sint16) SDL_SwapBE16(sample3));
        dst[2] = ((Sint16) SDL_SwapBE16(sample2));
        dst[1] = ((Sint16) SDL_SwapBE16(sample1));
        dst[0] = ((Sint16) SDL_SwapBE16(sample0));
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[5]))) + ((Sint32) last_sample5)) >> 1);
            sample4 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[4]))) + ((Sint32) last_sample4)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16MSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 192;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 sample1 = ((Sint16) SDL_SwapBE16(src[1]));
    Sint16 sample2 = ((Sint16) SDL_SwapBE16(src[2]));
    Sint16 sample3 = ((Sint16) SDL_SwapBE16(src[3]));
    Sint16 sample4 = ((Sint16) SDL_SwapBE16(src[4]));
    Sint16 sample5 = ((Sint16) SDL_SwapBE16(src[5]));
    Sint16 last_sample0 = sample0;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample3 = sample3;
    Sint16 last_sample4 = sample4;
    Sint16 last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapBE16(sample0));
            dst[1] = ((Sint16) SDL_SwapBE16(sample1));
            dst[2] = ((Sint16) SDL_SwapBE16(sample2));
            dst[3] = ((Sint16) SDL_SwapBE16(sample3));
            dst[4] = ((Sint16) SDL_SwapBE16(sample4));
            dst[5] = ((Sint16) SDL_SwapBE16(sample5));
            dst += 6;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample4 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[4]))) + ((Sint32) last_sample4)) >> 1);
            sample5 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[5]))) + ((Sint32) last_sample5)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S16MSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 8;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 8;
    Sint16 sample7 = ((Sint16) SDL_SwapBE16(src[7]));
    Sint16 sample6 = ((Sint16) SDL_SwapBE16(src[6]));
    Sint16 sample5 = ((Sint16) SDL_SwapBE16(src[5]));
    Sint16 sample4 = ((Sint16) SDL_SwapBE16(src[4]));
    Sint16 sample3 = ((Sint16) SDL_SwapBE16(src[3]));
    Sint16 sample2 = ((Sint16) SDL_SwapBE16(src[2]));
    Sint16 sample1 = ((Sint16) SDL_SwapBE16(src[1]));
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 last_sample7 = sample7;
    Sint16 last_sample6 = sample6;
    Sint16 last_sample5 = sample5;
    Sint16 last_sample4 = sample4;
    Sint16 last_sample3 = sample3;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample0 = sample0;
    while (dst != target) {
        dst[7] = ((Sint16) SDL_SwapBE16(sample7));
        dst[6] = ((Sint16) SDL_SwapBE16(sample6));
        dst[5] = ((Sint16) SDL_SwapBE16(sample5));
        dst[4] = ((Sint16) SDL_SwapBE16(sample4));
        dst[3] = ((Sint16) SDL_SwapBE16(sample3));
        dst[2] = ((Sint16) SDL_SwapBE16(sample2));
        dst[1] = ((Sint16) SDL_SwapBE16(sample1));
        dst[0] = ((Sint16) SDL_SwapBE16(sample0));
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[7]))) + ((Sint32) last_sample7)) >> 1);
            sample6 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[6]))) + ((Sint32) last_sample6)) >> 1);
            sample5 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[5]))) + ((Sint32) last_sample5)) >> 1);
            sample4 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[4]))) + ((Sint32) last_sample4)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S16MSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint16 sample0 = ((Sint16) SDL_SwapBE16(src[0]));
    Sint16 sample1 = ((Sint16) SDL_SwapBE16(src[1]));
    Sint16 sample2 = ((Sint16) SDL_SwapBE16(src[2]));
    Sint16 sample3 = ((Sint16) SDL_SwapBE16(src[3]));
    Sint16 sample4 = ((Sint16) SDL_SwapBE16(src[4]));
    Sint16 sample5 = ((Sint16) SDL_SwapBE16(src[5]));
    Sint16 sample6 = ((Sint16) SDL_SwapBE16(src[6]));
    Sint16 sample7 = ((Sint16) SDL_SwapBE16(src[7]));
    Sint16 last_sample0 = sample0;
    Sint16 last_sample1 = sample1;
    Sint16 last_sample2 = sample2;
    Sint16 last_sample3 = sample3;
    Sint16 last_sample4 = sample4;
    Sint16 last_sample5 = sample5;
    Sint16 last_sample6 = sample6;
    Sint16 last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint16) SDL_SwapBE16(sample0));
            dst[1] = ((Sint16) SDL_SwapBE16(sample1));
            dst[2] = ((Sint16) SDL_SwapBE16(sample2));
            dst[3] = ((Sint16) SDL_SwapBE16(sample3));
            dst[4] = ((Sint16) SDL_SwapBE16(sample4));
            dst[5] = ((Sint16) SDL_SwapBE16(sample5));
            dst[6] = ((Sint16) SDL_SwapBE16(sample6));
            dst[7] = ((Sint16) SDL_SwapBE16(sample7));
            dst += 8;
            sample0 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[0]))) + ((Sint32) last_sample0)) >> 1);
            sample1 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[1]))) + ((Sint32) last_sample1)) >> 1);
            sample2 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[2]))) + ((Sint32) last_sample2)) >> 1);
            sample3 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[3]))) + ((Sint32) last_sample3)) >> 1);
            sample4 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[4]))) + ((Sint32) last_sample4)) >> 1);
            sample5 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[5]))) + ((Sint32) last_sample5)) >> 1);
            sample6 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[6]))) + ((Sint32) last_sample6)) >> 1);
            sample7 = (Sint16) ((((Sint32) ((Sint16) SDL_SwapBE16(src[7]))) + ((Sint32) last_sample7)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32LSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 1;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 1;
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[0] = ((Sint32) SDL_SwapLE32(sample0));
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32LSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapLE32(sample0));
            dst++;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32LSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 2;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 2;
    Sint32 sample1 = ((Sint32) SDL_SwapLE32(src[1]));
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 last_sample1 = sample1;
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[1] = ((Sint32) SDL_SwapLE32(sample1));
        dst[0] = ((Sint32) SDL_SwapLE32(sample0));
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32LSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 sample1 = ((Sint32) SDL_SwapLE32(src[1]));
    Sint32 last_sample0 = sample0;
    Sint32 last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapLE32(sample0));
            dst[1] = ((Sint32) SDL_SwapLE32(sample1));
            dst += 2;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32LSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 4;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 4;
    Sint32 sample3 = ((Sint32) SDL_SwapLE32(src[3]));
    Sint32 sample2 = ((Sint32) SDL_SwapLE32(src[2]));
    Sint32 sample1 = ((Sint32) SDL_SwapLE32(src[1]));
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 last_sample3 = sample3;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[3] = ((Sint32) SDL_SwapLE32(sample3));
        dst[2] = ((Sint32) SDL_SwapLE32(sample2));
        dst[1] = ((Sint32) SDL_SwapLE32(sample1));
        dst[0] = ((Sint32) SDL_SwapLE32(sample0));
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32LSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 sample1 = ((Sint32) SDL_SwapLE32(src[1]));
    Sint32 sample2 = ((Sint32) SDL_SwapLE32(src[2]));
    Sint32 sample3 = ((Sint32) SDL_SwapLE32(src[3]));
    Sint32 last_sample0 = sample0;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapLE32(sample0));
            dst[1] = ((Sint32) SDL_SwapLE32(sample1));
            dst[2] = ((Sint32) SDL_SwapLE32(sample2));
            dst[3] = ((Sint32) SDL_SwapLE32(sample3));
            dst += 4;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32LSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 384;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 6;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 6;
    Sint32 sample5 = ((Sint32) SDL_SwapLE32(src[5]));
    Sint32 sample4 = ((Sint32) SDL_SwapLE32(src[4]));
    Sint32 sample3 = ((Sint32) SDL_SwapLE32(src[3]));
    Sint32 sample2 = ((Sint32) SDL_SwapLE32(src[2]));
    Sint32 sample1 = ((Sint32) SDL_SwapLE32(src[1]));
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 last_sample5 = sample5;
    Sint32 last_sample4 = sample4;
    Sint32 last_sample3 = sample3;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[5] = ((Sint32) SDL_SwapLE32(sample5));
        dst[4] = ((Sint32) SDL_SwapLE32(sample4));
        dst[3] = ((Sint32) SDL_SwapLE32(sample3));
        dst[2] = ((Sint32) SDL_SwapLE32(sample2));
        dst[1] = ((Sint32) SDL_SwapLE32(sample1));
        dst[0] = ((Sint32) SDL_SwapLE32(sample0));
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[5]))) + ((Sint64) last_sample5)) >> 1);
            sample4 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[4]))) + ((Sint64) last_sample4)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32LSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 384;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 sample1 = ((Sint32) SDL_SwapLE32(src[1]));
    Sint32 sample2 = ((Sint32) SDL_SwapLE32(src[2]));
    Sint32 sample3 = ((Sint32) SDL_SwapLE32(src[3]));
    Sint32 sample4 = ((Sint32) SDL_SwapLE32(src[4]));
    Sint32 sample5 = ((Sint32) SDL_SwapLE32(src[5]));
    Sint32 last_sample0 = sample0;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample3 = sample3;
    Sint32 last_sample4 = sample4;
    Sint32 last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapLE32(sample0));
            dst[1] = ((Sint32) SDL_SwapLE32(sample1));
            dst[2] = ((Sint32) SDL_SwapLE32(sample2));
            dst[3] = ((Sint32) SDL_SwapLE32(sample3));
            dst[4] = ((Sint32) SDL_SwapLE32(sample4));
            dst[5] = ((Sint32) SDL_SwapLE32(sample5));
            dst += 6;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample4 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[4]))) + ((Sint64) last_sample4)) >> 1);
            sample5 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[5]))) + ((Sint64) last_sample5)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32LSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 512;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 8;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 8;
    Sint32 sample7 = ((Sint32) SDL_SwapLE32(src[7]));
    Sint32 sample6 = ((Sint32) SDL_SwapLE32(src[6]));
    Sint32 sample5 = ((Sint32) SDL_SwapLE32(src[5]));
    Sint32 sample4 = ((Sint32) SDL_SwapLE32(src[4]));
    Sint32 sample3 = ((Sint32) SDL_SwapLE32(src[3]));
    Sint32 sample2 = ((Sint32) SDL_SwapLE32(src[2]));
    Sint32 sample1 = ((Sint32) SDL_SwapLE32(src[1]));
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 last_sample7 = sample7;
    Sint32 last_sample6 = sample6;
    Sint32 last_sample5 = sample5;
    Sint32 last_sample4 = sample4;
    Sint32 last_sample3 = sample3;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[7] = ((Sint32) SDL_SwapLE32(sample7));
        dst[6] = ((Sint32) SDL_SwapLE32(sample6));
        dst[5] = ((Sint32) SDL_SwapLE32(sample5));
        dst[4] = ((Sint32) SDL_SwapLE32(sample4));
        dst[3] = ((Sint32) SDL_SwapLE32(sample3));
        dst[2] = ((Sint32) SDL_SwapLE32(sample2));
        dst[1] = ((Sint32) SDL_SwapLE32(sample1));
        dst[0] = ((Sint32) SDL_SwapLE32(sample0));
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[7]))) + ((Sint64) last_sample7)) >> 1);
            sample6 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[6]))) + ((Sint64) last_sample6)) >> 1);
            sample5 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[5]))) + ((Sint64) last_sample5)) >> 1);
            sample4 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[4]))) + ((Sint64) last_sample4)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32LSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 512;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapLE32(src[0]));
    Sint32 sample1 = ((Sint32) SDL_SwapLE32(src[1]));
    Sint32 sample2 = ((Sint32) SDL_SwapLE32(src[2]));
    Sint32 sample3 = ((Sint32) SDL_SwapLE32(src[3]));
    Sint32 sample4 = ((Sint32) SDL_SwapLE32(src[4]));
    Sint32 sample5 = ((Sint32) SDL_SwapLE32(src[5]));
    Sint32 sample6 = ((Sint32) SDL_SwapLE32(src[6]));
    Sint32 sample7 = ((Sint32) SDL_SwapLE32(src[7]));
    Sint32 last_sample0 = sample0;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample3 = sample3;
    Sint32 last_sample4 = sample4;
    Sint32 last_sample5 = sample5;
    Sint32 last_sample6 = sample6;
    Sint32 last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapLE32(sample0));
            dst[1] = ((Sint32) SDL_SwapLE32(sample1));
            dst[2] = ((Sint32) SDL_SwapLE32(sample2));
            dst[3] = ((Sint32) SDL_SwapLE32(sample3));
            dst[4] = ((Sint32) SDL_SwapLE32(sample4));
            dst[5] = ((Sint32) SDL_SwapLE32(sample5));
            dst[6] = ((Sint32) SDL_SwapLE32(sample6));
            dst[7] = ((Sint32) SDL_SwapLE32(sample7));
            dst += 8;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample4 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[4]))) + ((Sint64) last_sample4)) >> 1);
            sample5 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[5]))) + ((Sint64) last_sample5)) >> 1);
            sample6 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[6]))) + ((Sint64) last_sample6)) >> 1);
            sample7 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapLE32(src[7]))) + ((Sint64) last_sample7)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32MSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 1;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 1;
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[0] = ((Sint32) SDL_SwapBE32(sample0));
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32MSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapBE32(sample0));
            dst++;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32MSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 2;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 2;
    Sint32 sample1 = ((Sint32) SDL_SwapBE32(src[1]));
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 last_sample1 = sample1;
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[1] = ((Sint32) SDL_SwapBE32(sample1));
        dst[0] = ((Sint32) SDL_SwapBE32(sample0));
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32MSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 sample1 = ((Sint32) SDL_SwapBE32(src[1]));
    Sint32 last_sample0 = sample0;
    Sint32 last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapBE32(sample0));
            dst[1] = ((Sint32) SDL_SwapBE32(sample1));
            dst += 2;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32MSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 4;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 4;
    Sint32 sample3 = ((Sint32) SDL_SwapBE32(src[3]));
    Sint32 sample2 = ((Sint32) SDL_SwapBE32(src[2]));
    Sint32 sample1 = ((Sint32) SDL_SwapBE32(src[1]));
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 last_sample3 = sample3;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[3] = ((Sint32) SDL_SwapBE32(sample3));
        dst[2] = ((Sint32) SDL_SwapBE32(sample2));
        dst[1] = ((Sint32) SDL_SwapBE32(sample1));
        dst[0] = ((Sint32) SDL_SwapBE32(sample0));
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32MSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 sample1 = ((Sint32) SDL_SwapBE32(src[1]));
    Sint32 sample2 = ((Sint32) SDL_SwapBE32(src[2]));
    Sint32 sample3 = ((Sint32) SDL_SwapBE32(src[3]));
    Sint32 last_sample0 = sample0;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapBE32(sample0));
            dst[1] = ((Sint32) SDL_SwapBE32(sample1));
            dst[2] = ((Sint32) SDL_SwapBE32(sample2));
            dst[3] = ((Sint32) SDL_SwapBE32(sample3));
            dst += 4;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32MSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 384;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 6;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 6;
    Sint32 sample5 = ((Sint32) SDL_SwapBE32(src[5]));
    Sint32 sample4 = ((Sint32) SDL_SwapBE32(src[4]));
    Sint32 sample3 = ((Sint32) SDL_SwapBE32(src[3]));
    Sint32 sample2 = ((Sint32) SDL_SwapBE32(src[2]));
    Sint32 sample1 = ((Sint32) SDL_SwapBE32(src[1]));
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 last_sample5 = sample5;
    Sint32 last_sample4 = sample4;
    Sint32 last_sample3 = sample3;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[5] = ((Sint32) SDL_SwapBE32(sample5));
        dst[4] = ((Sint32) SDL_SwapBE32(sample4));
        dst[3] = ((Sint32) SDL_SwapBE32(sample3));
        dst[2] = ((Sint32) SDL_SwapBE32(sample2));
        dst[1] = ((Sint32) SDL_SwapBE32(sample1));
        dst[0] = ((Sint32) SDL_SwapBE32(sample0));
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[5]))) + ((Sint64) last_sample5)) >> 1);
            sample4 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[4]))) + ((Sint64) last_sample4)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32MSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 384;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 sample1 = ((Sint32) SDL_SwapBE32(src[1]));
    Sint32 sample2 = ((Sint32) SDL_SwapBE32(src[2]));
    Sint32 sample3 = ((Sint32) SDL_SwapBE32(src[3]));
    Sint32 sample4 = ((Sint32) SDL_SwapBE32(src[4]));
    Sint32 sample5 = ((Sint32) SDL_SwapBE32(src[5]));
    Sint32 last_sample0 = sample0;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample3 = sample3;
    Sint32 last_sample4 = sample4;
    Sint32 last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapBE32(sample0));
            dst[1] = ((Sint32) SDL_SwapBE32(sample1));
            dst[2] = ((Sint32) SDL_SwapBE32(sample2));
            dst[3] = ((Sint32) SDL_SwapBE32(sample3));
            dst[4] = ((Sint32) SDL_SwapBE32(sample4));
            dst[5] = ((Sint32) SDL_SwapBE32(sample5));
            dst += 6;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample4 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[4]))) + ((Sint64) last_sample4)) >> 1);
            sample5 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[5]))) + ((Sint64) last_sample5)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_S32MSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 512;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 8;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 8;
    Sint32 sample7 = ((Sint32) SDL_SwapBE32(src[7]));
    Sint32 sample6 = ((Sint32) SDL_SwapBE32(src[6]));
    Sint32 sample5 = ((Sint32) SDL_SwapBE32(src[5]));
    Sint32 sample4 = ((Sint32) SDL_SwapBE32(src[4]));
    Sint32 sample3 = ((Sint32) SDL_SwapBE32(src[3]));
    Sint32 sample2 = ((Sint32) SDL_SwapBE32(src[2]));
    Sint32 sample1 = ((Sint32) SDL_SwapBE32(src[1]));
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 last_sample7 = sample7;
    Sint32 last_sample6 = sample6;
    Sint32 last_sample5 = sample5;
    Sint32 last_sample4 = sample4;
    Sint32 last_sample3 = sample3;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample0 = sample0;
    while (dst != target) {
        dst[7] = ((Sint32) SDL_SwapBE32(sample7));
        dst[6] = ((Sint32) SDL_SwapBE32(sample6));
        dst[5] = ((Sint32) SDL_SwapBE32(sample5));
        dst[4] = ((Sint32) SDL_SwapBE32(sample4));
        dst[3] = ((Sint32) SDL_SwapBE32(sample3));
        dst[2] = ((Sint32) SDL_SwapBE32(sample2));
        dst[1] = ((Sint32) SDL_SwapBE32(sample1));
        dst[0] = ((Sint32) SDL_SwapBE32(sample0));
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[7]))) + ((Sint64) last_sample7)) >> 1);
            sample6 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[6]))) + ((Sint64) last_sample6)) >> 1);
            sample5 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[5]))) + ((Sint64) last_sample5)) >> 1);
            sample4 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[4]))) + ((Sint64) last_sample4)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_S32MSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 512;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint32 sample0 = ((Sint32) SDL_SwapBE32(src[0]));
    Sint32 sample1 = ((Sint32) SDL_SwapBE32(src[1]));
    Sint32 sample2 = ((Sint32) SDL_SwapBE32(src[2]));
    Sint32 sample3 = ((Sint32) SDL_SwapBE32(src[3]));
    Sint32 sample4 = ((Sint32) SDL_SwapBE32(src[4]));
    Sint32 sample5 = ((Sint32) SDL_SwapBE32(src[5]));
    Sint32 sample6 = ((Sint32) SDL_SwapBE32(src[6]));
    Sint32 sample7 = ((Sint32) SDL_SwapBE32(src[7]));
    Sint32 last_sample0 = sample0;
    Sint32 last_sample1 = sample1;
    Sint32 last_sample2 = sample2;
    Sint32 last_sample3 = sample3;
    Sint32 last_sample4 = sample4;
    Sint32 last_sample5 = sample5;
    Sint32 last_sample6 = sample6;
    Sint32 last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = ((Sint32) SDL_SwapBE32(sample0));
            dst[1] = ((Sint32) SDL_SwapBE32(sample1));
            dst[2] = ((Sint32) SDL_SwapBE32(sample2));
            dst[3] = ((Sint32) SDL_SwapBE32(sample3));
            dst[4] = ((Sint32) SDL_SwapBE32(sample4));
            dst[5] = ((Sint32) SDL_SwapBE32(sample5));
            dst[6] = ((Sint32) SDL_SwapBE32(sample6));
            dst[7] = ((Sint32) SDL_SwapBE32(sample7));
            dst += 8;
            sample0 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[0]))) + ((Sint64) last_sample0)) >> 1);
            sample1 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[1]))) + ((Sint64) last_sample1)) >> 1);
            sample2 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[2]))) + ((Sint64) last_sample2)) >> 1);
            sample3 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[3]))) + ((Sint64) last_sample3)) >> 1);
            sample4 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[4]))) + ((Sint64) last_sample4)) >> 1);
            sample5 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[5]))) + ((Sint64) last_sample5)) >> 1);
            sample6 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[6]))) + ((Sint64) last_sample6)) >> 1);
            sample7 = (Sint32) ((((Sint64) ((Sint32) SDL_SwapBE32(src[7]))) + ((Sint64) last_sample7)) >> 1);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32LSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 1;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 1;
    const float *target = ((const float *) cvt->buf) - 1;
    float sample0 = SDL_SwapFloatLE(src[0]);
    float last_sample0 = sample0;
    while (dst != target) {
        dst[0] = SDL_SwapFloatLE(sample0);
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32LSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatLE(src[0]);
    float last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatLE(sample0);
            dst++;
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32LSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 2;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 2;
    const float *target = ((const float *) cvt->buf) - 2;
    float sample1 = SDL_SwapFloatLE(src[1]);
    float sample0 = SDL_SwapFloatLE(src[0]);
    float last_sample1 = sample1;
    float last_sample0 = sample0;
    while (dst != target) {
        dst[1] = SDL_SwapFloatLE(sample1);
        dst[0] = SDL_SwapFloatLE(sample0);
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (float) ((((double) SDL_SwapFloatLE(src[1])) + ((double) last_sample1)) * 0.5);
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32LSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatLE(src[0]);
    float sample1 = SDL_SwapFloatLE(src[1]);
    float last_sample0 = sample0;
    float last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatLE(sample0);
            dst[1] = SDL_SwapFloatLE(sample1);
            dst += 2;
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatLE(src[1])) + ((double) last_sample1)) * 0.5);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32LSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 4;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 4;
    const float *target = ((const float *) cvt->buf) - 4;
    float sample3 = SDL_SwapFloatLE(src[3]);
    float sample2 = SDL_SwapFloatLE(src[2]);
    float sample1 = SDL_SwapFloatLE(src[1]);
    float sample0 = SDL_SwapFloatLE(src[0]);
    float last_sample3 = sample3;
    float last_sample2 = sample2;
    float last_sample1 = sample1;
    float last_sample0 = sample0;
    while (dst != target) {
        dst[3] = SDL_SwapFloatLE(sample3);
        dst[2] = SDL_SwapFloatLE(sample2);
        dst[1] = SDL_SwapFloatLE(sample1);
        dst[0] = SDL_SwapFloatLE(sample0);
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (float) ((((double) SDL_SwapFloatLE(src[3])) + ((double) last_sample3)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatLE(src[2])) + ((double) last_sample2)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatLE(src[1])) + ((double) last_sample1)) * 0.5);
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32LSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatLE(src[0]);
    float sample1 = SDL_SwapFloatLE(src[1]);
    float sample2 = SDL_SwapFloatLE(src[2]);
    float sample3 = SDL_SwapFloatLE(src[3]);
    float last_sample0 = sample0;
    float last_sample1 = sample1;
    float last_sample2 = sample2;
    float last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatLE(sample0);
            dst[1] = SDL_SwapFloatLE(sample1);
            dst[2] = SDL_SwapFloatLE(sample2);
            dst[3] = SDL_SwapFloatLE(sample3);
            dst += 4;
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatLE(src[1])) + ((double) last_sample1)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatLE(src[2])) + ((double) last_sample2)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatLE(src[3])) + ((double) last_sample3)) * 0.5);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32LSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 384;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 6;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 6;
    const float *target = ((const float *) cvt->buf) - 6;
    float sample5 = SDL_SwapFloatLE(src[5]);
    float sample4 = SDL_SwapFloatLE(src[4]);
    float sample3 = SDL_SwapFloatLE(src[3]);
    float sample2 = SDL_SwapFloatLE(src[2]);
    float sample1 = SDL_SwapFloatLE(src[1]);
    float sample0 = SDL_SwapFloatLE(src[0]);
    float last_sample5 = sample5;
    float last_sample4 = sample4;
    float last_sample3 = sample3;
    float last_sample2 = sample2;
    float last_sample1 = sample1;
    float last_sample0 = sample0;
    while (dst != target) {
        dst[5] = SDL_SwapFloatLE(sample5);
        dst[4] = SDL_SwapFloatLE(sample4);
        dst[3] = SDL_SwapFloatLE(sample3);
        dst[2] = SDL_SwapFloatLE(sample2);
        dst[1] = SDL_SwapFloatLE(sample1);
        dst[0] = SDL_SwapFloatLE(sample0);
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (float) ((((double) SDL_SwapFloatLE(src[5])) + ((double) last_sample5)) * 0.5);
            sample4 = (float) ((((double) SDL_SwapFloatLE(src[4])) + ((double) last_sample4)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatLE(src[3])) + ((double) last_sample3)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatLE(src[2])) + ((double) last_sample2)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatLE(src[1])) + ((double) last_sample1)) * 0.5);
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32LSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 384;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatLE(src[0]);
    float sample1 = SDL_SwapFloatLE(src[1]);
    float sample2 = SDL_SwapFloatLE(src[2]);
    float sample3 = SDL_SwapFloatLE(src[3]);
    float sample4 = SDL_SwapFloatLE(src[4]);
    float sample5 = SDL_SwapFloatLE(src[5]);
    float last_sample0 = sample0;
    float last_sample1 = sample1;
    float last_sample2 = sample2;
    float last_sample3 = sample3;
    float last_sample4 = sample4;
    float last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatLE(sample0);
            dst[1] = SDL_SwapFloatLE(sample1);
            dst[2] = SDL_SwapFloatLE(sample2);
            dst[3] = SDL_SwapFloatLE(sample3);
            dst[4] = SDL_SwapFloatLE(sample4);
            dst[5] = SDL_SwapFloatLE(sample5);
            dst += 6;
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatLE(src[1])) + ((double) last_sample1)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatLE(src[2])) + ((double) last_sample2)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatLE(src[3])) + ((double) last_sample3)) * 0.5);
            sample4 = (float) ((((double) SDL_SwapFloatLE(src[4])) + ((double) last_sample4)) * 0.5);
            sample5 = (float) ((((double) SDL_SwapFloatLE(src[5])) + ((double) last_sample5)) * 0.5);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32LSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 512;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 8;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 8;
    const float *target = ((const float *) cvt->buf) - 8;
    float sample7 = SDL_SwapFloatLE(src[7]);
    float sample6 = SDL_SwapFloatLE(src[6]);
    float sample5 = SDL_SwapFloatLE(src[5]);
    float sample4 = SDL_SwapFloatLE(src[4]);
    float sample3 = SDL_SwapFloatLE(src[3]);
    float sample2 = SDL_SwapFloatLE(src[2]);
    float sample1 = SDL_SwapFloatLE(src[1]);
    float sample0 = SDL_SwapFloatLE(src[0]);
    float last_sample7 = sample7;
    float last_sample6 = sample6;
    float last_sample5 = sample5;
    float last_sample4 = sample4;
    float last_sample3 = sample3;
    float last_sample2 = sample2;
    float last_sample1 = sample1;
    float last_sample0 = sample0;
    while (dst != target) {
        dst[7] = SDL_SwapFloatLE(sample7);
        dst[6] = SDL_SwapFloatLE(sample6);
        dst[5] = SDL_SwapFloatLE(sample5);
        dst[4] = SDL_SwapFloatLE(sample4);
        dst[3] = SDL_SwapFloatLE(sample3);
        dst[2] = SDL_SwapFloatLE(sample2);
        dst[1] = SDL_SwapFloatLE(sample1);
        dst[0] = SDL_SwapFloatLE(sample0);
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (float) ((((double) SDL_SwapFloatLE(src[7])) + ((double) last_sample7)) * 0.5);
            sample6 = (float) ((((double) SDL_SwapFloatLE(src[6])) + ((double) last_sample6)) * 0.5);
            sample5 = (float) ((((double) SDL_SwapFloatLE(src[5])) + ((double) last_sample5)) * 0.5);
            sample4 = (float) ((((double) SDL_SwapFloatLE(src[4])) + ((double) last_sample4)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatLE(src[3])) + ((double) last_sample3)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatLE(src[2])) + ((double) last_sample2)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatLE(src[1])) + ((double) last_sample1)) * 0.5);
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32LSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 512;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatLE(src[0]);
    float sample1 = SDL_SwapFloatLE(src[1]);
    float sample2 = SDL_SwapFloatLE(src[2]);
    float sample3 = SDL_SwapFloatLE(src[3]);
    float sample4 = SDL_SwapFloatLE(src[4]);
    float sample5 = SDL_SwapFloatLE(src[5]);
    float sample6 = SDL_SwapFloatLE(src[6]);
    float sample7 = SDL_SwapFloatLE(src[7]);
    float last_sample0 = sample0;
    float last_sample1 = sample1;
    float last_sample2 = sample2;
    float last_sample3 = sample3;
    float last_sample4 = sample4;
    float last_sample5 = sample5;
    float last_sample6 = sample6;
    float last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatLE(sample0);
            dst[1] = SDL_SwapFloatLE(sample1);
            dst[2] = SDL_SwapFloatLE(sample2);
            dst[3] = SDL_SwapFloatLE(sample3);
            dst[4] = SDL_SwapFloatLE(sample4);
            dst[5] = SDL_SwapFloatLE(sample5);
            dst[6] = SDL_SwapFloatLE(sample6);
            dst[7] = SDL_SwapFloatLE(sample7);
            dst += 8;
            sample0 = (float) ((((double) SDL_SwapFloatLE(src[0])) + ((double) last_sample0)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatLE(src[1])) + ((double) last_sample1)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatLE(src[2])) + ((double) last_sample2)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatLE(src[3])) + ((double) last_sample3)) * 0.5);
            sample4 = (float) ((((double) SDL_SwapFloatLE(src[4])) + ((double) last_sample4)) * 0.5);
            sample5 = (float) ((((double) SDL_SwapFloatLE(src[5])) + ((double) last_sample5)) * 0.5);
            sample6 = (float) ((((double) SDL_SwapFloatLE(src[6])) + ((double) last_sample6)) * 0.5);
            sample7 = (float) ((((double) SDL_SwapFloatLE(src[7])) + ((double) last_sample7)) * 0.5);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32MSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 1;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 1;
    const float *target = ((const float *) cvt->buf) - 1;
    float sample0 = SDL_SwapFloatBE(src[0]);
    float last_sample0 = sample0;
    while (dst != target) {
        dst[0] = SDL_SwapFloatBE(sample0);
        dst--;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src--;
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_1c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32MSB, 1 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 64;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatBE(src[0]);
    float last_sample0 = sample0;
    while (dst != target) {
        src++;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatBE(sample0);
            dst++;
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample0 = sample0;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32MSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 2;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 2;
    const float *target = ((const float *) cvt->buf) - 2;
    float sample1 = SDL_SwapFloatBE(src[1]);
    float sample0 = SDL_SwapFloatBE(src[0]);
    float last_sample1 = sample1;
    float last_sample0 = sample0;
    while (dst != target) {
        dst[1] = SDL_SwapFloatBE(sample1);
        dst[0] = SDL_SwapFloatBE(sample0);
        dst -= 2;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 2;
            sample1 = (float) ((((double) SDL_SwapFloatBE(src[1])) + ((double) last_sample1)) * 0.5);
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_2c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32MSB, 2 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 128;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatBE(src[0]);
    float sample1 = SDL_SwapFloatBE(src[1]);
    float last_sample0 = sample0;
    float last_sample1 = sample1;
    while (dst != target) {
        src += 2;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatBE(sample0);
            dst[1] = SDL_SwapFloatBE(sample1);
            dst += 2;
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatBE(src[1])) + ((double) last_sample1)) * 0.5);
            last_sample0 = sample0;
            last_sample1 = sample1;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32MSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 4;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 4;
    const float *target = ((const float *) cvt->buf) - 4;
    float sample3 = SDL_SwapFloatBE(src[3]);
    float sample2 = SDL_SwapFloatBE(src[2]);
    float sample1 = SDL_SwapFloatBE(src[1]);
    float sample0 = SDL_SwapFloatBE(src[0]);
    float last_sample3 = sample3;
    float last_sample2 = sample2;
    float last_sample1 = sample1;
    float last_sample0 = sample0;
    while (dst != target) {
        dst[3] = SDL_SwapFloatBE(sample3);
        dst[2] = SDL_SwapFloatBE(sample2);
        dst[1] = SDL_SwapFloatBE(sample1);
        dst[0] = SDL_SwapFloatBE(sample0);
        dst -= 4;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 4;
            sample3 = (float) ((((double) SDL_SwapFloatBE(src[3])) + ((double) last_sample3)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatBE(src[2])) + ((double) last_sample2)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatBE(src[1])) + ((double) last_sample1)) * 0.5);
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_4c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32MSB, 4 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 256;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatBE(src[0]);
    float sample1 = SDL_SwapFloatBE(src[1]);
    float sample2 = SDL_SwapFloatBE(src[2]);
    float sample3 = SDL_SwapFloatBE(src[3]);
    float last_sample0 = sample0;
    float last_sample1 = sample1;
    float last_sample2 = sample2;
    float last_sample3 = sample3;
    while (dst != target) {
        src += 4;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatBE(sample0);
            dst[1] = SDL_SwapFloatBE(sample1);
            dst[2] = SDL_SwapFloatBE(sample2);
            dst[3] = SDL_SwapFloatBE(sample3);
            dst += 4;
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatBE(src[1])) + ((double) last_sample1)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatBE(src[2])) + ((double) last_sample2)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatBE(src[3])) + ((double) last_sample3)) * 0.5);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32MSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 384;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 6;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 6;
    const float *target = ((const float *) cvt->buf) - 6;
    float sample5 = SDL_SwapFloatBE(src[5]);
    float sample4 = SDL_SwapFloatBE(src[4]);
    float sample3 = SDL_SwapFloatBE(src[3]);
    float sample2 = SDL_SwapFloatBE(src[2]);
    float sample1 = SDL_SwapFloatBE(src[1]);
    float sample0 = SDL_SwapFloatBE(src[0]);
    float last_sample5 = sample5;
    float last_sample4 = sample4;
    float last_sample3 = sample3;
    float last_sample2 = sample2;
    float last_sample1 = sample1;
    float last_sample0 = sample0;
    while (dst != target) {
        dst[5] = SDL_SwapFloatBE(sample5);
        dst[4] = SDL_SwapFloatBE(sample4);
        dst[3] = SDL_SwapFloatBE(sample3);
        dst[2] = SDL_SwapFloatBE(sample2);
        dst[1] = SDL_SwapFloatBE(sample1);
        dst[0] = SDL_SwapFloatBE(sample0);
        dst -= 6;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 6;
            sample5 = (float) ((((double) SDL_SwapFloatBE(src[5])) + ((double) last_sample5)) * 0.5);
            sample4 = (float) ((((double) SDL_SwapFloatBE(src[4])) + ((double) last_sample4)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatBE(src[3])) + ((double) last_sample3)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatBE(src[2])) + ((double) last_sample2)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatBE(src[1])) + ((double) last_sample1)) * 0.5);
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_6c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32MSB, 6 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 384;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatBE(src[0]);
    float sample1 = SDL_SwapFloatBE(src[1]);
    float sample2 = SDL_SwapFloatBE(src[2]);
    float sample3 = SDL_SwapFloatBE(src[3]);
    float sample4 = SDL_SwapFloatBE(src[4]);
    float sample5 = SDL_SwapFloatBE(src[5]);
    float last_sample0 = sample0;
    float last_sample1 = sample1;
    float last_sample2 = sample2;
    float last_sample3 = sample3;
    float last_sample4 = sample4;
    float last_sample5 = sample5;
    while (dst != target) {
        src += 6;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatBE(sample0);
            dst[1] = SDL_SwapFloatBE(sample1);
            dst[2] = SDL_SwapFloatBE(sample2);
            dst[3] = SDL_SwapFloatBE(sample3);
            dst[4] = SDL_SwapFloatBE(sample4);
            dst[5] = SDL_SwapFloatBE(sample5);
            dst += 6;
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatBE(src[1])) + ((double) last_sample1)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatBE(src[2])) + ((double) last_sample2)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatBE(src[3])) + ((double) last_sample3)) * 0.5);
            sample4 = (float) ((((double) SDL_SwapFloatBE(src[4])) + ((double) last_sample4)) * 0.5);
            sample5 = (float) ((((double) SDL_SwapFloatBE(src[5])) + ((double) last_sample5)) * 0.5);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample arbitrary (x%f) AUDIO_F32MSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 512;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = ((float *) (cvt->buf + dstsize)) - 8;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 8;
    const float *target = ((const float *) cvt->buf) - 8;
    float sample7 = SDL_SwapFloatBE(src[7]);
    float sample6 = SDL_SwapFloatBE(src[6]);
    float sample5 = SDL_SwapFloatBE(src[5]);
    float sample4 = SDL_SwapFloatBE(src[4]);
    float sample3 = SDL_SwapFloatBE(src[3]);
    float sample2 = SDL_SwapFloatBE(src[2]);
    float sample1 = SDL_SwapFloatBE(src[1]);
    float sample0 = SDL_SwapFloatBE(src[0]);
    float last_sample7 = sample7;
    float last_sample6 = sample6;
    float last_sample5 = sample5;
    float last_sample4 = sample4;
    float last_sample3 = sample3;
    float last_sample2 = sample2;
    float last_sample1 = sample1;
    float last_sample0 = sample0;
    while (dst != target) {
        dst[7] = SDL_SwapFloatBE(sample7);
        dst[6] = SDL_SwapFloatBE(sample6);
        dst[5] = SDL_SwapFloatBE(sample5);
        dst[4] = SDL_SwapFloatBE(sample4);
        dst[3] = SDL_SwapFloatBE(sample3);
        dst[2] = SDL_SwapFloatBE(sample2);
        dst[1] = SDL_SwapFloatBE(sample1);
        dst[0] = SDL_SwapFloatBE(sample0);
        dst -= 8;
        eps += srcsize;
        if ((eps << 1) >= dstsize) {
            src -= 8;
            sample7 = (float) ((((double) SDL_SwapFloatBE(src[7])) + ((double) last_sample7)) * 0.5);
            sample6 = (float) ((((double) SDL_SwapFloatBE(src[6])) + ((double) last_sample6)) * 0.5);
            sample5 = (float) ((((double) SDL_SwapFloatBE(src[5])) + ((double) last_sample5)) * 0.5);
            sample4 = (float) ((((double) SDL_SwapFloatBE(src[4])) + ((double) last_sample4)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatBE(src[3])) + ((double) last_sample3)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatBE(src[2])) + ((double) last_sample2)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatBE(src[1])) + ((double) last_sample1)) * 0.5);
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            last_sample7 = sample7;
            last_sample6 = sample6;
            last_sample5 = sample5;
            last_sample4 = sample4;
            last_sample3 = sample3;
            last_sample2 = sample2;
            last_sample1 = sample1;
            last_sample0 = sample0;
            eps -= dstsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_8c(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample arbitrary (x%f) AUDIO_F32MSB, 8 channels.\n", cvt->rate_incr);
#endif

    const int srcsize = cvt->len_cvt - 512;
    const int dstsize = (int) (((double)cvt->len_cvt) * cvt->rate_incr);
    register int eps = 0;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    float sample0 = SDL_SwapFloatBE(src[0]);
    float sample1 = SDL_SwapFloatBE(src[1]);
    float sample2 = SDL_SwapFloatBE(src[2]);
    float sample3 = SDL_SwapFloatBE(src[3]);
    float sample4 = SDL_SwapFloatBE(src[4]);
    float sample5 = SDL_SwapFloatBE(src[5]);
    float sample6 = SDL_SwapFloatBE(src[6]);
    float sample7 = SDL_SwapFloatBE(src[7]);
    float last_sample0 = sample0;
    float last_sample1 = sample1;
    float last_sample2 = sample2;
    float last_sample3 = sample3;
    float last_sample4 = sample4;
    float last_sample5 = sample5;
    float last_sample6 = sample6;
    float last_sample7 = sample7;
    while (dst != target) {
        src += 8;
        eps += dstsize;
        if ((eps << 1) >= srcsize) {
            dst[0] = SDL_SwapFloatBE(sample0);
            dst[1] = SDL_SwapFloatBE(sample1);
            dst[2] = SDL_SwapFloatBE(sample2);
            dst[3] = SDL_SwapFloatBE(sample3);
            dst[4] = SDL_SwapFloatBE(sample4);
            dst[5] = SDL_SwapFloatBE(sample5);
            dst[6] = SDL_SwapFloatBE(sample6);
            dst[7] = SDL_SwapFloatBE(sample7);
            dst += 8;
            sample0 = (float) ((((double) SDL_SwapFloatBE(src[0])) + ((double) last_sample0)) * 0.5);
            sample1 = (float) ((((double) SDL_SwapFloatBE(src[1])) + ((double) last_sample1)) * 0.5);
            sample2 = (float) ((((double) SDL_SwapFloatBE(src[2])) + ((double) last_sample2)) * 0.5);
            sample3 = (float) ((((double) SDL_SwapFloatBE(src[3])) + ((double) last_sample3)) * 0.5);
            sample4 = (float) ((((double) SDL_SwapFloatBE(src[4])) + ((double) last_sample4)) * 0.5);
            sample5 = (float) ((((double) SDL_SwapFloatBE(src[5])) + ((double) last_sample5)) * 0.5);
            sample6 = (float) ((((double) SDL_SwapFloatBE(src[6])) + ((double) last_sample6)) * 0.5);
            sample7 = (float) ((((double) SDL_SwapFloatBE(src[7])) + ((double) last_sample7)) * 0.5);
            last_sample0 = sample0;
            last_sample1 = sample1;
            last_sample2 = sample2;
            last_sample3 = sample3;
            last_sample4 = sample4;
            last_sample5 = sample5;
            last_sample6 = sample6;
            last_sample7 = sample7;
            eps -= srcsize;
        }
    }
    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}


#if !LESS_RESAMPLERS

static void SDLCALL
SDL_Upsample_U8_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U8, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 1;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 1;
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample0 = (Sint16) src[0];
        src--;
        dst[1] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[0] = (Uint8) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U8, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        src += 2;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U8, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 1;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 1;
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample0 = (Sint16) src[0];
        src--;
        dst[3] = (Uint8) sample0;
        dst[2] = (Uint8) (((3 * sample0) + last_sample0) >> 2);
        dst[1] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[0] = (Uint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U8, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        src += 4;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U8, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 2;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 2;
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample0 = (Sint16) src[0];
        src -= 2;
        dst[3] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) sample1;
        dst[0] = (Uint8) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U8, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    Sint16 last_sample1 = (Sint16) src[1];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        const Sint16 sample1 = (Sint16) src[1];
        src += 4;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U8, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 2;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 2;
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample0 = (Sint16) src[0];
        src -= 2;
        dst[7] = (Uint8) sample1;
        dst[6] = (Uint8) sample0;
        dst[5] = (Uint8) (((3 * sample1) + last_sample1) >> 2);
        dst[4] = (Uint8) (((3 * sample0) + last_sample0) >> 2);
        dst[3] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U8, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    Sint16 last_sample1 = (Sint16) src[1];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        const Sint16 sample1 = (Sint16) src[1];
        src += 8;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U8, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 4;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 4;
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample0 = (Sint16) src[0];
        src -= 4;
        dst[7] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[6] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[5] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[4] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[3] = (Uint8) sample3;
        dst[2] = (Uint8) sample2;
        dst[1] = (Uint8) sample1;
        dst[0] = (Uint8) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U8, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample3 = (Sint16) src[3];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample3 = (Sint16) src[3];
        src += 8;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint8) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U8, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 4;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 4;
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample0 = (Sint16) src[0];
        src -= 4;
        dst[15] = (Uint8) sample3;
        dst[14] = (Uint8) sample2;
        dst[13] = (Uint8) sample1;
        dst[12] = (Uint8) sample0;
        dst[11] = (Uint8) (((3 * sample3) + last_sample3) >> 2);
        dst[10] = (Uint8) (((3 * sample2) + last_sample2) >> 2);
        dst[9] = (Uint8) (((3 * sample1) + last_sample1) >> 2);
        dst[8] = (Uint8) (((3 * sample0) + last_sample0) >> 2);
        dst[7] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[6] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[5] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[4] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[3] = (Uint8) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Uint8) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Uint8) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U8, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample3 = (Sint16) src[3];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample3 = (Sint16) src[3];
        src += 16;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint8) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U8, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 6;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 6;
    Sint16 last_sample5 = (Sint16) src[5];
    Sint16 last_sample4 = (Sint16) src[4];
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample5 = (Sint16) src[5];
        const Sint16 sample4 = (Sint16) src[4];
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample0 = (Sint16) src[0];
        src -= 6;
        dst[11] = (Uint8) ((sample5 + last_sample5) >> 1);
        dst[10] = (Uint8) ((sample4 + last_sample4) >> 1);
        dst[9] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[8] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[7] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[6] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[5] = (Uint8) sample5;
        dst[4] = (Uint8) sample4;
        dst[3] = (Uint8) sample3;
        dst[2] = (Uint8) sample2;
        dst[1] = (Uint8) sample1;
        dst[0] = (Uint8) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U8, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample4 = (Sint16) src[4];
    Sint16 last_sample5 = (Sint16) src[5];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample4 = (Sint16) src[4];
        const Sint16 sample5 = (Sint16) src[5];
        src += 12;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint8) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint8) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U8, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 6;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 6;
    Sint16 last_sample5 = (Sint16) src[5];
    Sint16 last_sample4 = (Sint16) src[4];
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample5 = (Sint16) src[5];
        const Sint16 sample4 = (Sint16) src[4];
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample0 = (Sint16) src[0];
        src -= 6;
        dst[23] = (Uint8) sample5;
        dst[22] = (Uint8) sample4;
        dst[21] = (Uint8) sample3;
        dst[20] = (Uint8) sample2;
        dst[19] = (Uint8) sample1;
        dst[18] = (Uint8) sample0;
        dst[17] = (Uint8) (((3 * sample5) + last_sample5) >> 2);
        dst[16] = (Uint8) (((3 * sample4) + last_sample4) >> 2);
        dst[15] = (Uint8) (((3 * sample3) + last_sample3) >> 2);
        dst[14] = (Uint8) (((3 * sample2) + last_sample2) >> 2);
        dst[13] = (Uint8) (((3 * sample1) + last_sample1) >> 2);
        dst[12] = (Uint8) (((3 * sample0) + last_sample0) >> 2);
        dst[11] = (Uint8) ((sample5 + last_sample5) >> 1);
        dst[10] = (Uint8) ((sample4 + last_sample4) >> 1);
        dst[9] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[8] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[7] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[6] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[5] = (Uint8) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Uint8) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Uint8) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Uint8) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Uint8) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U8, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample4 = (Sint16) src[4];
    Sint16 last_sample5 = (Sint16) src[5];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample4 = (Sint16) src[4];
        const Sint16 sample5 = (Sint16) src[5];
        src += 24;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint8) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint8) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U8, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 8;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 8;
    Sint16 last_sample7 = (Sint16) src[7];
    Sint16 last_sample6 = (Sint16) src[6];
    Sint16 last_sample5 = (Sint16) src[5];
    Sint16 last_sample4 = (Sint16) src[4];
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample7 = (Sint16) src[7];
        const Sint16 sample6 = (Sint16) src[6];
        const Sint16 sample5 = (Sint16) src[5];
        const Sint16 sample4 = (Sint16) src[4];
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample0 = (Sint16) src[0];
        src -= 8;
        dst[15] = (Uint8) ((sample7 + last_sample7) >> 1);
        dst[14] = (Uint8) ((sample6 + last_sample6) >> 1);
        dst[13] = (Uint8) ((sample5 + last_sample5) >> 1);
        dst[12] = (Uint8) ((sample4 + last_sample4) >> 1);
        dst[11] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[10] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[9] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[8] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[7] = (Uint8) sample7;
        dst[6] = (Uint8) sample6;
        dst[5] = (Uint8) sample5;
        dst[4] = (Uint8) sample4;
        dst[3] = (Uint8) sample3;
        dst[2] = (Uint8) sample2;
        dst[1] = (Uint8) sample1;
        dst[0] = (Uint8) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U8, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample4 = (Sint16) src[4];
    Sint16 last_sample5 = (Sint16) src[5];
    Sint16 last_sample6 = (Sint16) src[6];
    Sint16 last_sample7 = (Sint16) src[7];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample4 = (Sint16) src[4];
        const Sint16 sample5 = (Sint16) src[5];
        const Sint16 sample6 = (Sint16) src[6];
        const Sint16 sample7 = (Sint16) src[7];
        src += 16;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint8) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint8) ((sample5 + last_sample5) >> 1);
        dst[6] = (Uint8) ((sample6 + last_sample6) >> 1);
        dst[7] = (Uint8) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U8_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U8, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint8 *dst = ((Uint8 *) (cvt->buf + dstsize)) - 8;
    const Uint8 *src = ((Uint8 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Uint8 *target = ((const Uint8 *) cvt->buf) - 8;
    Sint16 last_sample7 = (Sint16) src[7];
    Sint16 last_sample6 = (Sint16) src[6];
    Sint16 last_sample5 = (Sint16) src[5];
    Sint16 last_sample4 = (Sint16) src[4];
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample0 = (Sint16) src[0];
    while (dst > target) {
        const Sint16 sample7 = (Sint16) src[7];
        const Sint16 sample6 = (Sint16) src[6];
        const Sint16 sample5 = (Sint16) src[5];
        const Sint16 sample4 = (Sint16) src[4];
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample0 = (Sint16) src[0];
        src -= 8;
        dst[31] = (Uint8) sample7;
        dst[30] = (Uint8) sample6;
        dst[29] = (Uint8) sample5;
        dst[28] = (Uint8) sample4;
        dst[27] = (Uint8) sample3;
        dst[26] = (Uint8) sample2;
        dst[25] = (Uint8) sample1;
        dst[24] = (Uint8) sample0;
        dst[23] = (Uint8) (((3 * sample7) + last_sample7) >> 2);
        dst[22] = (Uint8) (((3 * sample6) + last_sample6) >> 2);
        dst[21] = (Uint8) (((3 * sample5) + last_sample5) >> 2);
        dst[20] = (Uint8) (((3 * sample4) + last_sample4) >> 2);
        dst[19] = (Uint8) (((3 * sample3) + last_sample3) >> 2);
        dst[18] = (Uint8) (((3 * sample2) + last_sample2) >> 2);
        dst[17] = (Uint8) (((3 * sample1) + last_sample1) >> 2);
        dst[16] = (Uint8) (((3 * sample0) + last_sample0) >> 2);
        dst[15] = (Uint8) ((sample7 + last_sample7) >> 1);
        dst[14] = (Uint8) ((sample6 + last_sample6) >> 1);
        dst[13] = (Uint8) ((sample5 + last_sample5) >> 1);
        dst[12] = (Uint8) ((sample4 + last_sample4) >> 1);
        dst[11] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[10] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[9] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[8] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[7] = (Uint8) ((sample7 + (3 * last_sample7)) >> 2);
        dst[6] = (Uint8) ((sample6 + (3 * last_sample6)) >> 2);
        dst[5] = (Uint8) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Uint8) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Uint8) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Uint8) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Uint8) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U8_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U8, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint8 *dst = (Uint8 *) cvt->buf;
    const Uint8 *src = (Uint8 *) cvt->buf;
    const Uint8 *target = (const Uint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) src[0];
    Sint16 last_sample1 = (Sint16) src[1];
    Sint16 last_sample2 = (Sint16) src[2];
    Sint16 last_sample3 = (Sint16) src[3];
    Sint16 last_sample4 = (Sint16) src[4];
    Sint16 last_sample5 = (Sint16) src[5];
    Sint16 last_sample6 = (Sint16) src[6];
    Sint16 last_sample7 = (Sint16) src[7];
    while (dst < target) {
        const Sint16 sample0 = (Sint16) src[0];
        const Sint16 sample1 = (Sint16) src[1];
        const Sint16 sample2 = (Sint16) src[2];
        const Sint16 sample3 = (Sint16) src[3];
        const Sint16 sample4 = (Sint16) src[4];
        const Sint16 sample5 = (Sint16) src[5];
        const Sint16 sample6 = (Sint16) src[6];
        const Sint16 sample7 = (Sint16) src[7];
        src += 32;
        dst[0] = (Uint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint8) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint8) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint8) ((sample5 + last_sample5) >> 1);
        dst[6] = (Uint8) ((sample6 + last_sample6) >> 1);
        dst[7] = (Uint8) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S8, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 1;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 1;
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src--;
        dst[1] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint8) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S8, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src += 2;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S8, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 1;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 1;
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src--;
        dst[3] = (Sint8) sample0;
        dst[2] = (Sint8) (((3 * sample0) + last_sample0) >> 2);
        dst[1] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S8, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src += 4;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S8, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 2;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 2;
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src -= 2;
        dst[3] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) sample1;
        dst[0] = (Sint8) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S8, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        src += 4;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S8, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 2;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 2;
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src -= 2;
        dst[7] = (Sint8) sample1;
        dst[6] = (Sint8) sample0;
        dst[5] = (Sint8) (((3 * sample1) + last_sample1) >> 2);
        dst[4] = (Sint8) (((3 * sample0) + last_sample0) >> 2);
        dst[3] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S8, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        src += 8;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S8, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 4;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 4;
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src -= 4;
        dst[7] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint8) sample3;
        dst[2] = (Sint8) sample2;
        dst[1] = (Sint8) sample1;
        dst[0] = (Sint8) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S8, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        src += 8;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint8) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S8, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 4;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 4;
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src -= 4;
        dst[15] = (Sint8) sample3;
        dst[14] = (Sint8) sample2;
        dst[13] = (Sint8) sample1;
        dst[12] = (Sint8) sample0;
        dst[11] = (Sint8) (((3 * sample3) + last_sample3) >> 2);
        dst[10] = (Sint8) (((3 * sample2) + last_sample2) >> 2);
        dst[9] = (Sint8) (((3 * sample1) + last_sample1) >> 2);
        dst[8] = (Sint8) (((3 * sample0) + last_sample0) >> 2);
        dst[7] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint8) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint8) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint8) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S8, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        src += 16;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint8) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S8, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 6;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 6;
    Sint16 last_sample5 = (Sint16) ((Sint8) src[5]);
    Sint16 last_sample4 = (Sint16) ((Sint8) src[4]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample5 = (Sint16) ((Sint8) src[5]);
        const Sint16 sample4 = (Sint16) ((Sint8) src[4]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src -= 6;
        dst[11] = (Sint8) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint8) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint8) sample5;
        dst[4] = (Sint8) sample4;
        dst[3] = (Sint8) sample3;
        dst[2] = (Sint8) sample2;
        dst[1] = (Sint8) sample1;
        dst[0] = (Sint8) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S8, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample4 = (Sint16) ((Sint8) src[4]);
    Sint16 last_sample5 = (Sint16) ((Sint8) src[5]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample4 = (Sint16) ((Sint8) src[4]);
        const Sint16 sample5 = (Sint16) ((Sint8) src[5]);
        src += 12;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint8) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint8) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S8, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 6;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 6;
    Sint16 last_sample5 = (Sint16) ((Sint8) src[5]);
    Sint16 last_sample4 = (Sint16) ((Sint8) src[4]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample5 = (Sint16) ((Sint8) src[5]);
        const Sint16 sample4 = (Sint16) ((Sint8) src[4]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src -= 6;
        dst[23] = (Sint8) sample5;
        dst[22] = (Sint8) sample4;
        dst[21] = (Sint8) sample3;
        dst[20] = (Sint8) sample2;
        dst[19] = (Sint8) sample1;
        dst[18] = (Sint8) sample0;
        dst[17] = (Sint8) (((3 * sample5) + last_sample5) >> 2);
        dst[16] = (Sint8) (((3 * sample4) + last_sample4) >> 2);
        dst[15] = (Sint8) (((3 * sample3) + last_sample3) >> 2);
        dst[14] = (Sint8) (((3 * sample2) + last_sample2) >> 2);
        dst[13] = (Sint8) (((3 * sample1) + last_sample1) >> 2);
        dst[12] = (Sint8) (((3 * sample0) + last_sample0) >> 2);
        dst[11] = (Sint8) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint8) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint8) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint8) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint8) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint8) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint8) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S8, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample4 = (Sint16) ((Sint8) src[4]);
    Sint16 last_sample5 = (Sint16) ((Sint8) src[5]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample4 = (Sint16) ((Sint8) src[4]);
        const Sint16 sample5 = (Sint16) ((Sint8) src[5]);
        src += 24;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint8) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint8) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S8, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 8;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 8;
    Sint16 last_sample7 = (Sint16) ((Sint8) src[7]);
    Sint16 last_sample6 = (Sint16) ((Sint8) src[6]);
    Sint16 last_sample5 = (Sint16) ((Sint8) src[5]);
    Sint16 last_sample4 = (Sint16) ((Sint8) src[4]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample7 = (Sint16) ((Sint8) src[7]);
        const Sint16 sample6 = (Sint16) ((Sint8) src[6]);
        const Sint16 sample5 = (Sint16) ((Sint8) src[5]);
        const Sint16 sample4 = (Sint16) ((Sint8) src[4]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src -= 8;
        dst[15] = (Sint8) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint8) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint8) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint8) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint8) sample7;
        dst[6] = (Sint8) sample6;
        dst[5] = (Sint8) sample5;
        dst[4] = (Sint8) sample4;
        dst[3] = (Sint8) sample3;
        dst[2] = (Sint8) sample2;
        dst[1] = (Sint8) sample1;
        dst[0] = (Sint8) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S8, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample4 = (Sint16) ((Sint8) src[4]);
    Sint16 last_sample5 = (Sint16) ((Sint8) src[5]);
    Sint16 last_sample6 = (Sint16) ((Sint8) src[6]);
    Sint16 last_sample7 = (Sint16) ((Sint8) src[7]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample4 = (Sint16) ((Sint8) src[4]);
        const Sint16 sample5 = (Sint16) ((Sint8) src[5]);
        const Sint16 sample6 = (Sint16) ((Sint8) src[6]);
        const Sint16 sample7 = (Sint16) ((Sint8) src[7]);
        src += 16;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint8) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint8) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint8) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint8) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S8_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S8, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint8 *dst = ((Sint8 *) (cvt->buf + dstsize)) - 8;
    const Sint8 *src = ((Sint8 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint8 *target = ((const Sint8 *) cvt->buf) - 8;
    Sint16 last_sample7 = (Sint16) ((Sint8) src[7]);
    Sint16 last_sample6 = (Sint16) ((Sint8) src[6]);
    Sint16 last_sample5 = (Sint16) ((Sint8) src[5]);
    Sint16 last_sample4 = (Sint16) ((Sint8) src[4]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    while (dst > target) {
        const Sint16 sample7 = (Sint16) ((Sint8) src[7]);
        const Sint16 sample6 = (Sint16) ((Sint8) src[6]);
        const Sint16 sample5 = (Sint16) ((Sint8) src[5]);
        const Sint16 sample4 = (Sint16) ((Sint8) src[4]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        src -= 8;
        dst[31] = (Sint8) sample7;
        dst[30] = (Sint8) sample6;
        dst[29] = (Sint8) sample5;
        dst[28] = (Sint8) sample4;
        dst[27] = (Sint8) sample3;
        dst[26] = (Sint8) sample2;
        dst[25] = (Sint8) sample1;
        dst[24] = (Sint8) sample0;
        dst[23] = (Sint8) (((3 * sample7) + last_sample7) >> 2);
        dst[22] = (Sint8) (((3 * sample6) + last_sample6) >> 2);
        dst[21] = (Sint8) (((3 * sample5) + last_sample5) >> 2);
        dst[20] = (Sint8) (((3 * sample4) + last_sample4) >> 2);
        dst[19] = (Sint8) (((3 * sample3) + last_sample3) >> 2);
        dst[18] = (Sint8) (((3 * sample2) + last_sample2) >> 2);
        dst[17] = (Sint8) (((3 * sample1) + last_sample1) >> 2);
        dst[16] = (Sint8) (((3 * sample0) + last_sample0) >> 2);
        dst[15] = (Sint8) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint8) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint8) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint8) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint8) ((sample7 + (3 * last_sample7)) >> 2);
        dst[6] = (Sint8) ((sample6 + (3 * last_sample6)) >> 2);
        dst[5] = (Sint8) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint8) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint8) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint8) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint8) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint8) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S8_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S8, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint8 *dst = (Sint8 *) cvt->buf;
    const Sint8 *src = (Sint8 *) cvt->buf;
    const Sint8 *target = (const Sint8 *) (cvt->buf + dstsize);
    Sint16 last_sample0 = (Sint16) ((Sint8) src[0]);
    Sint16 last_sample1 = (Sint16) ((Sint8) src[1]);
    Sint16 last_sample2 = (Sint16) ((Sint8) src[2]);
    Sint16 last_sample3 = (Sint16) ((Sint8) src[3]);
    Sint16 last_sample4 = (Sint16) ((Sint8) src[4]);
    Sint16 last_sample5 = (Sint16) ((Sint8) src[5]);
    Sint16 last_sample6 = (Sint16) ((Sint8) src[6]);
    Sint16 last_sample7 = (Sint16) ((Sint8) src[7]);
    while (dst < target) {
        const Sint16 sample0 = (Sint16) ((Sint8) src[0]);
        const Sint16 sample1 = (Sint16) ((Sint8) src[1]);
        const Sint16 sample2 = (Sint16) ((Sint8) src[2]);
        const Sint16 sample3 = (Sint16) ((Sint8) src[3]);
        const Sint16 sample4 = (Sint16) ((Sint8) src[4]);
        const Sint16 sample5 = (Sint16) ((Sint8) src[5]);
        const Sint16 sample6 = (Sint16) ((Sint8) src[6]);
        const Sint16 sample7 = (Sint16) ((Sint8) src[7]);
        src += 32;
        dst[0] = (Sint8) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint8) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint8) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint8) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint8) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint8) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint8) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint8) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 1;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 1;
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src--;
        dst[1] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[0] = (Uint16) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src += 2;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 1;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 1;
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src--;
        dst[3] = (Uint16) sample0;
        dst[2] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[1] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src += 4;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 2;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 2;
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src -= 2;
        dst[3] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) sample1;
        dst[0] = (Uint16) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        src += 4;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 2;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 2;
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src -= 2;
        dst[7] = (Uint16) sample1;
        dst[6] = (Uint16) sample0;
        dst[5] = (Uint16) (((3 * sample1) + last_sample1) >> 2);
        dst[4] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[3] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        src += 8;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 4;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 4;
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src -= 4;
        dst[7] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[6] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[5] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[4] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[3] = (Uint16) sample3;
        dst[2] = (Uint16) sample2;
        dst[1] = (Uint16) sample1;
        dst[0] = (Uint16) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        src += 8;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 4;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 4;
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src -= 4;
        dst[15] = (Uint16) sample3;
        dst[14] = (Uint16) sample2;
        dst[13] = (Uint16) sample1;
        dst[12] = (Uint16) sample0;
        dst[11] = (Uint16) (((3 * sample3) + last_sample3) >> 2);
        dst[10] = (Uint16) (((3 * sample2) + last_sample2) >> 2);
        dst[9] = (Uint16) (((3 * sample1) + last_sample1) >> 2);
        dst[8] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[7] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[6] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[5] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[4] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[3] = (Uint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Uint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Uint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        src += 16;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 6;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 6;
    Sint32 last_sample5 = (Sint32) SDL_SwapLE16(src[5]);
    Sint32 last_sample4 = (Sint32) SDL_SwapLE16(src[4]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample5 = (Sint32) SDL_SwapLE16(src[5]);
        const Sint32 sample4 = (Sint32) SDL_SwapLE16(src[4]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src -= 6;
        dst[11] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[10] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[9] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[8] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[7] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[6] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[5] = (Uint16) sample5;
        dst[4] = (Uint16) sample4;
        dst[3] = (Uint16) sample3;
        dst[2] = (Uint16) sample2;
        dst[1] = (Uint16) sample1;
        dst[0] = (Uint16) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample4 = (Sint32) SDL_SwapLE16(src[4]);
    Sint32 last_sample5 = (Sint32) SDL_SwapLE16(src[5]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample4 = (Sint32) SDL_SwapLE16(src[4]);
        const Sint32 sample5 = (Sint32) SDL_SwapLE16(src[5]);
        src += 12;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint16) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 6;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 6;
    Sint32 last_sample5 = (Sint32) SDL_SwapLE16(src[5]);
    Sint32 last_sample4 = (Sint32) SDL_SwapLE16(src[4]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample5 = (Sint32) SDL_SwapLE16(src[5]);
        const Sint32 sample4 = (Sint32) SDL_SwapLE16(src[4]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src -= 6;
        dst[23] = (Uint16) sample5;
        dst[22] = (Uint16) sample4;
        dst[21] = (Uint16) sample3;
        dst[20] = (Uint16) sample2;
        dst[19] = (Uint16) sample1;
        dst[18] = (Uint16) sample0;
        dst[17] = (Uint16) (((3 * sample5) + last_sample5) >> 2);
        dst[16] = (Uint16) (((3 * sample4) + last_sample4) >> 2);
        dst[15] = (Uint16) (((3 * sample3) + last_sample3) >> 2);
        dst[14] = (Uint16) (((3 * sample2) + last_sample2) >> 2);
        dst[13] = (Uint16) (((3 * sample1) + last_sample1) >> 2);
        dst[12] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[11] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[10] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[9] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[8] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[7] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[6] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[5] = (Uint16) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Uint16) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Uint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Uint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Uint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample4 = (Sint32) SDL_SwapLE16(src[4]);
    Sint32 last_sample5 = (Sint32) SDL_SwapLE16(src[5]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample4 = (Sint32) SDL_SwapLE16(src[4]);
        const Sint32 sample5 = (Sint32) SDL_SwapLE16(src[5]);
        src += 24;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint16) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 8;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 8;
    Sint32 last_sample7 = (Sint32) SDL_SwapLE16(src[7]);
    Sint32 last_sample6 = (Sint32) SDL_SwapLE16(src[6]);
    Sint32 last_sample5 = (Sint32) SDL_SwapLE16(src[5]);
    Sint32 last_sample4 = (Sint32) SDL_SwapLE16(src[4]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample7 = (Sint32) SDL_SwapLE16(src[7]);
        const Sint32 sample6 = (Sint32) SDL_SwapLE16(src[6]);
        const Sint32 sample5 = (Sint32) SDL_SwapLE16(src[5]);
        const Sint32 sample4 = (Sint32) SDL_SwapLE16(src[4]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src -= 8;
        dst[15] = (Uint16) ((sample7 + last_sample7) >> 1);
        dst[14] = (Uint16) ((sample6 + last_sample6) >> 1);
        dst[13] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[12] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[11] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[10] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[9] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[8] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[7] = (Uint16) sample7;
        dst[6] = (Uint16) sample6;
        dst[5] = (Uint16) sample5;
        dst[4] = (Uint16) sample4;
        dst[3] = (Uint16) sample3;
        dst[2] = (Uint16) sample2;
        dst[1] = (Uint16) sample1;
        dst[0] = (Uint16) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample4 = (Sint32) SDL_SwapLE16(src[4]);
    Sint32 last_sample5 = (Sint32) SDL_SwapLE16(src[5]);
    Sint32 last_sample6 = (Sint32) SDL_SwapLE16(src[6]);
    Sint32 last_sample7 = (Sint32) SDL_SwapLE16(src[7]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample4 = (Sint32) SDL_SwapLE16(src[4]);
        const Sint32 sample5 = (Sint32) SDL_SwapLE16(src[5]);
        const Sint32 sample6 = (Sint32) SDL_SwapLE16(src[6]);
        const Sint32 sample7 = (Sint32) SDL_SwapLE16(src[7]);
        src += 16;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[6] = (Uint16) ((sample6 + last_sample6) >> 1);
        dst[7] = (Uint16) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16LSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 8;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 8;
    Sint32 last_sample7 = (Sint32) SDL_SwapLE16(src[7]);
    Sint32 last_sample6 = (Sint32) SDL_SwapLE16(src[6]);
    Sint32 last_sample5 = (Sint32) SDL_SwapLE16(src[5]);
    Sint32 last_sample4 = (Sint32) SDL_SwapLE16(src[4]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    while (dst > target) {
        const Sint32 sample7 = (Sint32) SDL_SwapLE16(src[7]);
        const Sint32 sample6 = (Sint32) SDL_SwapLE16(src[6]);
        const Sint32 sample5 = (Sint32) SDL_SwapLE16(src[5]);
        const Sint32 sample4 = (Sint32) SDL_SwapLE16(src[4]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        src -= 8;
        dst[31] = (Uint16) sample7;
        dst[30] = (Uint16) sample6;
        dst[29] = (Uint16) sample5;
        dst[28] = (Uint16) sample4;
        dst[27] = (Uint16) sample3;
        dst[26] = (Uint16) sample2;
        dst[25] = (Uint16) sample1;
        dst[24] = (Uint16) sample0;
        dst[23] = (Uint16) (((3 * sample7) + last_sample7) >> 2);
        dst[22] = (Uint16) (((3 * sample6) + last_sample6) >> 2);
        dst[21] = (Uint16) (((3 * sample5) + last_sample5) >> 2);
        dst[20] = (Uint16) (((3 * sample4) + last_sample4) >> 2);
        dst[19] = (Uint16) (((3 * sample3) + last_sample3) >> 2);
        dst[18] = (Uint16) (((3 * sample2) + last_sample2) >> 2);
        dst[17] = (Uint16) (((3 * sample1) + last_sample1) >> 2);
        dst[16] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[15] = (Uint16) ((sample7 + last_sample7) >> 1);
        dst[14] = (Uint16) ((sample6 + last_sample6) >> 1);
        dst[13] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[12] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[11] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[10] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[9] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[8] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[7] = (Uint16) ((sample7 + (3 * last_sample7)) >> 2);
        dst[6] = (Uint16) ((sample6 + (3 * last_sample6)) >> 2);
        dst[5] = (Uint16) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Uint16) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Uint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Uint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Uint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16LSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapLE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapLE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapLE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapLE16(src[3]);
    Sint32 last_sample4 = (Sint32) SDL_SwapLE16(src[4]);
    Sint32 last_sample5 = (Sint32) SDL_SwapLE16(src[5]);
    Sint32 last_sample6 = (Sint32) SDL_SwapLE16(src[6]);
    Sint32 last_sample7 = (Sint32) SDL_SwapLE16(src[7]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapLE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapLE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapLE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapLE16(src[3]);
        const Sint32 sample4 = (Sint32) SDL_SwapLE16(src[4]);
        const Sint32 sample5 = (Sint32) SDL_SwapLE16(src[5]);
        const Sint32 sample6 = (Sint32) SDL_SwapLE16(src[6]);
        const Sint32 sample7 = (Sint32) SDL_SwapLE16(src[7]);
        src += 32;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[6] = (Uint16) ((sample6 + last_sample6) >> 1);
        dst[7] = (Uint16) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 1;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 1;
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src--;
        dst[1] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint16) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src += 2;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 1;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 1;
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src--;
        dst[3] = (Sint16) sample0;
        dst[2] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[1] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src += 4;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 2;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 2;
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src -= 2;
        dst[3] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) sample1;
        dst[0] = (Sint16) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        src += 4;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 2;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 2;
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src -= 2;
        dst[7] = (Sint16) sample1;
        dst[6] = (Sint16) sample0;
        dst[5] = (Sint16) (((3 * sample1) + last_sample1) >> 2);
        dst[4] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[3] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        src += 8;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 4;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 4;
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src -= 4;
        dst[7] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint16) sample3;
        dst[2] = (Sint16) sample2;
        dst[1] = (Sint16) sample1;
        dst[0] = (Sint16) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        src += 8;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 4;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 4;
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src -= 4;
        dst[15] = (Sint16) sample3;
        dst[14] = (Sint16) sample2;
        dst[13] = (Sint16) sample1;
        dst[12] = (Sint16) sample0;
        dst[11] = (Sint16) (((3 * sample3) + last_sample3) >> 2);
        dst[10] = (Sint16) (((3 * sample2) + last_sample2) >> 2);
        dst[9] = (Sint16) (((3 * sample1) + last_sample1) >> 2);
        dst[8] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[7] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        src += 16;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 6;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 6;
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src -= 6;
        dst[11] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint16) sample5;
        dst[4] = (Sint16) sample4;
        dst[3] = (Sint16) sample3;
        dst[2] = (Sint16) sample2;
        dst[1] = (Sint16) sample1;
        dst[0] = (Sint16) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
        src += 12;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint16) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 6;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 6;
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src -= 6;
        dst[23] = (Sint16) sample5;
        dst[22] = (Sint16) sample4;
        dst[21] = (Sint16) sample3;
        dst[20] = (Sint16) sample2;
        dst[19] = (Sint16) sample1;
        dst[18] = (Sint16) sample0;
        dst[17] = (Sint16) (((3 * sample5) + last_sample5) >> 2);
        dst[16] = (Sint16) (((3 * sample4) + last_sample4) >> 2);
        dst[15] = (Sint16) (((3 * sample3) + last_sample3) >> 2);
        dst[14] = (Sint16) (((3 * sample2) + last_sample2) >> 2);
        dst[13] = (Sint16) (((3 * sample1) + last_sample1) >> 2);
        dst[12] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[11] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint16) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint16) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
        src += 24;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint16) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 8;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 8;
    Sint32 last_sample7 = (Sint32) ((Sint16) SDL_SwapLE16(src[7]));
    Sint32 last_sample6 = (Sint32) ((Sint16) SDL_SwapLE16(src[6]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample7 = (Sint32) ((Sint16) SDL_SwapLE16(src[7]));
        const Sint32 sample6 = (Sint32) ((Sint16) SDL_SwapLE16(src[6]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src -= 8;
        dst[15] = (Sint16) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint16) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint16) sample7;
        dst[6] = (Sint16) sample6;
        dst[5] = (Sint16) sample5;
        dst[4] = (Sint16) sample4;
        dst[3] = (Sint16) sample3;
        dst[2] = (Sint16) sample2;
        dst[1] = (Sint16) sample1;
        dst[0] = (Sint16) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
    Sint32 last_sample6 = (Sint32) ((Sint16) SDL_SwapLE16(src[6]));
    Sint32 last_sample7 = (Sint32) ((Sint16) SDL_SwapLE16(src[7]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
        const Sint32 sample6 = (Sint32) ((Sint16) SDL_SwapLE16(src[6]));
        const Sint32 sample7 = (Sint32) ((Sint16) SDL_SwapLE16(src[7]));
        src += 16;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint16) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint16) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16LSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 8;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 8;
    Sint32 last_sample7 = (Sint32) ((Sint16) SDL_SwapLE16(src[7]));
    Sint32 last_sample6 = (Sint32) ((Sint16) SDL_SwapLE16(src[6]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    while (dst > target) {
        const Sint32 sample7 = (Sint32) ((Sint16) SDL_SwapLE16(src[7]));
        const Sint32 sample6 = (Sint32) ((Sint16) SDL_SwapLE16(src[6]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        src -= 8;
        dst[31] = (Sint16) sample7;
        dst[30] = (Sint16) sample6;
        dst[29] = (Sint16) sample5;
        dst[28] = (Sint16) sample4;
        dst[27] = (Sint16) sample3;
        dst[26] = (Sint16) sample2;
        dst[25] = (Sint16) sample1;
        dst[24] = (Sint16) sample0;
        dst[23] = (Sint16) (((3 * sample7) + last_sample7) >> 2);
        dst[22] = (Sint16) (((3 * sample6) + last_sample6) >> 2);
        dst[21] = (Sint16) (((3 * sample5) + last_sample5) >> 2);
        dst[20] = (Sint16) (((3 * sample4) + last_sample4) >> 2);
        dst[19] = (Sint16) (((3 * sample3) + last_sample3) >> 2);
        dst[18] = (Sint16) (((3 * sample2) + last_sample2) >> 2);
        dst[17] = (Sint16) (((3 * sample1) + last_sample1) >> 2);
        dst[16] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[15] = (Sint16) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint16) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint16) ((sample7 + (3 * last_sample7)) >> 2);
        dst[6] = (Sint16) ((sample6 + (3 * last_sample6)) >> 2);
        dst[5] = (Sint16) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint16) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16LSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
    Sint32 last_sample6 = (Sint32) ((Sint16) SDL_SwapLE16(src[6]));
    Sint32 last_sample7 = (Sint32) ((Sint16) SDL_SwapLE16(src[7]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapLE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapLE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapLE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapLE16(src[3]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapLE16(src[4]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapLE16(src[5]));
        const Sint32 sample6 = (Sint32) ((Sint16) SDL_SwapLE16(src[6]));
        const Sint32 sample7 = (Sint32) ((Sint16) SDL_SwapLE16(src[7]));
        src += 32;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint16) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint16) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 1;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 1;
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src--;
        dst[1] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[0] = (Uint16) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src += 2;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 1;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 1;
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src--;
        dst[3] = (Uint16) sample0;
        dst[2] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[1] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src += 4;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 2;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 2;
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src -= 2;
        dst[3] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) sample1;
        dst[0] = (Uint16) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        src += 4;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 2;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 2;
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src -= 2;
        dst[7] = (Uint16) sample1;
        dst[6] = (Uint16) sample0;
        dst[5] = (Uint16) (((3 * sample1) + last_sample1) >> 2);
        dst[4] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[3] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        src += 8;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 4;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 4;
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src -= 4;
        dst[7] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[6] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[5] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[4] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[3] = (Uint16) sample3;
        dst[2] = (Uint16) sample2;
        dst[1] = (Uint16) sample1;
        dst[0] = (Uint16) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        src += 8;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 4;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 4;
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src -= 4;
        dst[15] = (Uint16) sample3;
        dst[14] = (Uint16) sample2;
        dst[13] = (Uint16) sample1;
        dst[12] = (Uint16) sample0;
        dst[11] = (Uint16) (((3 * sample3) + last_sample3) >> 2);
        dst[10] = (Uint16) (((3 * sample2) + last_sample2) >> 2);
        dst[9] = (Uint16) (((3 * sample1) + last_sample1) >> 2);
        dst[8] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[7] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[6] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[5] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[4] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[3] = (Uint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Uint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Uint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        src += 16;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 6;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 6;
    Sint32 last_sample5 = (Sint32) SDL_SwapBE16(src[5]);
    Sint32 last_sample4 = (Sint32) SDL_SwapBE16(src[4]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample5 = (Sint32) SDL_SwapBE16(src[5]);
        const Sint32 sample4 = (Sint32) SDL_SwapBE16(src[4]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src -= 6;
        dst[11] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[10] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[9] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[8] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[7] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[6] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[5] = (Uint16) sample5;
        dst[4] = (Uint16) sample4;
        dst[3] = (Uint16) sample3;
        dst[2] = (Uint16) sample2;
        dst[1] = (Uint16) sample1;
        dst[0] = (Uint16) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample4 = (Sint32) SDL_SwapBE16(src[4]);
    Sint32 last_sample5 = (Sint32) SDL_SwapBE16(src[5]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample4 = (Sint32) SDL_SwapBE16(src[4]);
        const Sint32 sample5 = (Sint32) SDL_SwapBE16(src[5]);
        src += 12;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint16) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 6;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 6;
    Sint32 last_sample5 = (Sint32) SDL_SwapBE16(src[5]);
    Sint32 last_sample4 = (Sint32) SDL_SwapBE16(src[4]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample5 = (Sint32) SDL_SwapBE16(src[5]);
        const Sint32 sample4 = (Sint32) SDL_SwapBE16(src[4]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src -= 6;
        dst[23] = (Uint16) sample5;
        dst[22] = (Uint16) sample4;
        dst[21] = (Uint16) sample3;
        dst[20] = (Uint16) sample2;
        dst[19] = (Uint16) sample1;
        dst[18] = (Uint16) sample0;
        dst[17] = (Uint16) (((3 * sample5) + last_sample5) >> 2);
        dst[16] = (Uint16) (((3 * sample4) + last_sample4) >> 2);
        dst[15] = (Uint16) (((3 * sample3) + last_sample3) >> 2);
        dst[14] = (Uint16) (((3 * sample2) + last_sample2) >> 2);
        dst[13] = (Uint16) (((3 * sample1) + last_sample1) >> 2);
        dst[12] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[11] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[10] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[9] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[8] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[7] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[6] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[5] = (Uint16) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Uint16) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Uint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Uint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Uint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample4 = (Sint32) SDL_SwapBE16(src[4]);
    Sint32 last_sample5 = (Sint32) SDL_SwapBE16(src[5]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample4 = (Sint32) SDL_SwapBE16(src[4]);
        const Sint32 sample5 = (Sint32) SDL_SwapBE16(src[5]);
        src += 24;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint16) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_U16MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 8;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 8;
    Sint32 last_sample7 = (Sint32) SDL_SwapBE16(src[7]);
    Sint32 last_sample6 = (Sint32) SDL_SwapBE16(src[6]);
    Sint32 last_sample5 = (Sint32) SDL_SwapBE16(src[5]);
    Sint32 last_sample4 = (Sint32) SDL_SwapBE16(src[4]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample7 = (Sint32) SDL_SwapBE16(src[7]);
        const Sint32 sample6 = (Sint32) SDL_SwapBE16(src[6]);
        const Sint32 sample5 = (Sint32) SDL_SwapBE16(src[5]);
        const Sint32 sample4 = (Sint32) SDL_SwapBE16(src[4]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src -= 8;
        dst[15] = (Uint16) ((sample7 + last_sample7) >> 1);
        dst[14] = (Uint16) ((sample6 + last_sample6) >> 1);
        dst[13] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[12] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[11] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[10] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[9] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[8] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[7] = (Uint16) sample7;
        dst[6] = (Uint16) sample6;
        dst[5] = (Uint16) sample5;
        dst[4] = (Uint16) sample4;
        dst[3] = (Uint16) sample3;
        dst[2] = (Uint16) sample2;
        dst[1] = (Uint16) sample1;
        dst[0] = (Uint16) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_U16MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample4 = (Sint32) SDL_SwapBE16(src[4]);
    Sint32 last_sample5 = (Sint32) SDL_SwapBE16(src[5]);
    Sint32 last_sample6 = (Sint32) SDL_SwapBE16(src[6]);
    Sint32 last_sample7 = (Sint32) SDL_SwapBE16(src[7]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample4 = (Sint32) SDL_SwapBE16(src[4]);
        const Sint32 sample5 = (Sint32) SDL_SwapBE16(src[5]);
        const Sint32 sample6 = (Sint32) SDL_SwapBE16(src[6]);
        const Sint32 sample7 = (Sint32) SDL_SwapBE16(src[7]);
        src += 16;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[6] = (Uint16) ((sample6 + last_sample6) >> 1);
        dst[7] = (Uint16) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_U16MSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_U16MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Uint16 *dst = ((Uint16 *) (cvt->buf + dstsize)) - 8;
    const Uint16 *src = ((Uint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Uint16 *target = ((const Uint16 *) cvt->buf) - 8;
    Sint32 last_sample7 = (Sint32) SDL_SwapBE16(src[7]);
    Sint32 last_sample6 = (Sint32) SDL_SwapBE16(src[6]);
    Sint32 last_sample5 = (Sint32) SDL_SwapBE16(src[5]);
    Sint32 last_sample4 = (Sint32) SDL_SwapBE16(src[4]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    while (dst > target) {
        const Sint32 sample7 = (Sint32) SDL_SwapBE16(src[7]);
        const Sint32 sample6 = (Sint32) SDL_SwapBE16(src[6]);
        const Sint32 sample5 = (Sint32) SDL_SwapBE16(src[5]);
        const Sint32 sample4 = (Sint32) SDL_SwapBE16(src[4]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        src -= 8;
        dst[31] = (Uint16) sample7;
        dst[30] = (Uint16) sample6;
        dst[29] = (Uint16) sample5;
        dst[28] = (Uint16) sample4;
        dst[27] = (Uint16) sample3;
        dst[26] = (Uint16) sample2;
        dst[25] = (Uint16) sample1;
        dst[24] = (Uint16) sample0;
        dst[23] = (Uint16) (((3 * sample7) + last_sample7) >> 2);
        dst[22] = (Uint16) (((3 * sample6) + last_sample6) >> 2);
        dst[21] = (Uint16) (((3 * sample5) + last_sample5) >> 2);
        dst[20] = (Uint16) (((3 * sample4) + last_sample4) >> 2);
        dst[19] = (Uint16) (((3 * sample3) + last_sample3) >> 2);
        dst[18] = (Uint16) (((3 * sample2) + last_sample2) >> 2);
        dst[17] = (Uint16) (((3 * sample1) + last_sample1) >> 2);
        dst[16] = (Uint16) (((3 * sample0) + last_sample0) >> 2);
        dst[15] = (Uint16) ((sample7 + last_sample7) >> 1);
        dst[14] = (Uint16) ((sample6 + last_sample6) >> 1);
        dst[13] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[12] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[11] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[10] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[9] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[8] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[7] = (Uint16) ((sample7 + (3 * last_sample7)) >> 2);
        dst[6] = (Uint16) ((sample6 + (3 * last_sample6)) >> 2);
        dst[5] = (Uint16) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Uint16) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Uint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Uint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Uint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Uint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_U16MSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_U16MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Uint16 *dst = (Uint16 *) cvt->buf;
    const Uint16 *src = (Uint16 *) cvt->buf;
    const Uint16 *target = (const Uint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) SDL_SwapBE16(src[0]);
    Sint32 last_sample1 = (Sint32) SDL_SwapBE16(src[1]);
    Sint32 last_sample2 = (Sint32) SDL_SwapBE16(src[2]);
    Sint32 last_sample3 = (Sint32) SDL_SwapBE16(src[3]);
    Sint32 last_sample4 = (Sint32) SDL_SwapBE16(src[4]);
    Sint32 last_sample5 = (Sint32) SDL_SwapBE16(src[5]);
    Sint32 last_sample6 = (Sint32) SDL_SwapBE16(src[6]);
    Sint32 last_sample7 = (Sint32) SDL_SwapBE16(src[7]);
    while (dst < target) {
        const Sint32 sample0 = (Sint32) SDL_SwapBE16(src[0]);
        const Sint32 sample1 = (Sint32) SDL_SwapBE16(src[1]);
        const Sint32 sample2 = (Sint32) SDL_SwapBE16(src[2]);
        const Sint32 sample3 = (Sint32) SDL_SwapBE16(src[3]);
        const Sint32 sample4 = (Sint32) SDL_SwapBE16(src[4]);
        const Sint32 sample5 = (Sint32) SDL_SwapBE16(src[5]);
        const Sint32 sample6 = (Sint32) SDL_SwapBE16(src[6]);
        const Sint32 sample7 = (Sint32) SDL_SwapBE16(src[7]);
        src += 32;
        dst[0] = (Uint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Uint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Uint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Uint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Uint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Uint16) ((sample5 + last_sample5) >> 1);
        dst[6] = (Uint16) ((sample6 + last_sample6) >> 1);
        dst[7] = (Uint16) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 1;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 1;
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src--;
        dst[1] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint16) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src += 2;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 1;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 1;
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src--;
        dst[3] = (Sint16) sample0;
        dst[2] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[1] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src += 4;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 2;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 2;
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src -= 2;
        dst[3] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) sample1;
        dst[0] = (Sint16) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        src += 4;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 2;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 2;
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src -= 2;
        dst[7] = (Sint16) sample1;
        dst[6] = (Sint16) sample0;
        dst[5] = (Sint16) (((3 * sample1) + last_sample1) >> 2);
        dst[4] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[3] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        src += 8;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 4;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 4;
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src -= 4;
        dst[7] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint16) sample3;
        dst[2] = (Sint16) sample2;
        dst[1] = (Sint16) sample1;
        dst[0] = (Sint16) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        src += 8;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 4;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 4;
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src -= 4;
        dst[15] = (Sint16) sample3;
        dst[14] = (Sint16) sample2;
        dst[13] = (Sint16) sample1;
        dst[12] = (Sint16) sample0;
        dst[11] = (Sint16) (((3 * sample3) + last_sample3) >> 2);
        dst[10] = (Sint16) (((3 * sample2) + last_sample2) >> 2);
        dst[9] = (Sint16) (((3 * sample1) + last_sample1) >> 2);
        dst[8] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[7] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        src += 16;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 6;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 6;
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src -= 6;
        dst[11] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint16) sample5;
        dst[4] = (Sint16) sample4;
        dst[3] = (Sint16) sample3;
        dst[2] = (Sint16) sample2;
        dst[1] = (Sint16) sample1;
        dst[0] = (Sint16) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
        src += 12;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint16) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 6;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 6;
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src -= 6;
        dst[23] = (Sint16) sample5;
        dst[22] = (Sint16) sample4;
        dst[21] = (Sint16) sample3;
        dst[20] = (Sint16) sample2;
        dst[19] = (Sint16) sample1;
        dst[18] = (Sint16) sample0;
        dst[17] = (Sint16) (((3 * sample5) + last_sample5) >> 2);
        dst[16] = (Sint16) (((3 * sample4) + last_sample4) >> 2);
        dst[15] = (Sint16) (((3 * sample3) + last_sample3) >> 2);
        dst[14] = (Sint16) (((3 * sample2) + last_sample2) >> 2);
        dst[13] = (Sint16) (((3 * sample1) + last_sample1) >> 2);
        dst[12] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[11] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint16) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint16) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
        src += 24;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint16) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S16MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 8;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 8;
    Sint32 last_sample7 = (Sint32) ((Sint16) SDL_SwapBE16(src[7]));
    Sint32 last_sample6 = (Sint32) ((Sint16) SDL_SwapBE16(src[6]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample7 = (Sint32) ((Sint16) SDL_SwapBE16(src[7]));
        const Sint32 sample6 = (Sint32) ((Sint16) SDL_SwapBE16(src[6]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src -= 8;
        dst[15] = (Sint16) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint16) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint16) sample7;
        dst[6] = (Sint16) sample6;
        dst[5] = (Sint16) sample5;
        dst[4] = (Sint16) sample4;
        dst[3] = (Sint16) sample3;
        dst[2] = (Sint16) sample2;
        dst[1] = (Sint16) sample1;
        dst[0] = (Sint16) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S16MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
    Sint32 last_sample6 = (Sint32) ((Sint16) SDL_SwapBE16(src[6]));
    Sint32 last_sample7 = (Sint32) ((Sint16) SDL_SwapBE16(src[7]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
        const Sint32 sample6 = (Sint32) ((Sint16) SDL_SwapBE16(src[6]));
        const Sint32 sample7 = (Sint32) ((Sint16) SDL_SwapBE16(src[7]));
        src += 16;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint16) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint16) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S16MSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S16MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint16 *dst = ((Sint16 *) (cvt->buf + dstsize)) - 8;
    const Sint16 *src = ((Sint16 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint16 *target = ((const Sint16 *) cvt->buf) - 8;
    Sint32 last_sample7 = (Sint32) ((Sint16) SDL_SwapBE16(src[7]));
    Sint32 last_sample6 = (Sint32) ((Sint16) SDL_SwapBE16(src[6]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    while (dst > target) {
        const Sint32 sample7 = (Sint32) ((Sint16) SDL_SwapBE16(src[7]));
        const Sint32 sample6 = (Sint32) ((Sint16) SDL_SwapBE16(src[6]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        src -= 8;
        dst[31] = (Sint16) sample7;
        dst[30] = (Sint16) sample6;
        dst[29] = (Sint16) sample5;
        dst[28] = (Sint16) sample4;
        dst[27] = (Sint16) sample3;
        dst[26] = (Sint16) sample2;
        dst[25] = (Sint16) sample1;
        dst[24] = (Sint16) sample0;
        dst[23] = (Sint16) (((3 * sample7) + last_sample7) >> 2);
        dst[22] = (Sint16) (((3 * sample6) + last_sample6) >> 2);
        dst[21] = (Sint16) (((3 * sample5) + last_sample5) >> 2);
        dst[20] = (Sint16) (((3 * sample4) + last_sample4) >> 2);
        dst[19] = (Sint16) (((3 * sample3) + last_sample3) >> 2);
        dst[18] = (Sint16) (((3 * sample2) + last_sample2) >> 2);
        dst[17] = (Sint16) (((3 * sample1) + last_sample1) >> 2);
        dst[16] = (Sint16) (((3 * sample0) + last_sample0) >> 2);
        dst[15] = (Sint16) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint16) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint16) ((sample7 + (3 * last_sample7)) >> 2);
        dst[6] = (Sint16) ((sample6 + (3 * last_sample6)) >> 2);
        dst[5] = (Sint16) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint16) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint16) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint16) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint16) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint16) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S16MSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S16MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint16 *dst = (Sint16 *) cvt->buf;
    const Sint16 *src = (Sint16 *) cvt->buf;
    const Sint16 *target = (const Sint16 *) (cvt->buf + dstsize);
    Sint32 last_sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
    Sint32 last_sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
    Sint32 last_sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
    Sint32 last_sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
    Sint32 last_sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
    Sint32 last_sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
    Sint32 last_sample6 = (Sint32) ((Sint16) SDL_SwapBE16(src[6]));
    Sint32 last_sample7 = (Sint32) ((Sint16) SDL_SwapBE16(src[7]));
    while (dst < target) {
        const Sint32 sample0 = (Sint32) ((Sint16) SDL_SwapBE16(src[0]));
        const Sint32 sample1 = (Sint32) ((Sint16) SDL_SwapBE16(src[1]));
        const Sint32 sample2 = (Sint32) ((Sint16) SDL_SwapBE16(src[2]));
        const Sint32 sample3 = (Sint32) ((Sint16) SDL_SwapBE16(src[3]));
        const Sint32 sample4 = (Sint32) ((Sint16) SDL_SwapBE16(src[4]));
        const Sint32 sample5 = (Sint32) ((Sint16) SDL_SwapBE16(src[5]));
        const Sint32 sample6 = (Sint32) ((Sint16) SDL_SwapBE16(src[6]));
        const Sint32 sample7 = (Sint32) ((Sint16) SDL_SwapBE16(src[7]));
        src += 32;
        dst[0] = (Sint16) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint16) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint16) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint16) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint16) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint16) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint16) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint16) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 1;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 1;
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src--;
        dst[1] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint32) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src += 2;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 1;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 1;
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src--;
        dst[3] = (Sint32) sample0;
        dst[2] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[1] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src += 4;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 2;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 2;
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src -= 2;
        dst[3] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) sample1;
        dst[0] = (Sint32) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        src += 4;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 2;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 2;
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src -= 2;
        dst[7] = (Sint32) sample1;
        dst[6] = (Sint32) sample0;
        dst[5] = (Sint32) (((3 * sample1) + last_sample1) >> 2);
        dst[4] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[3] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        src += 8;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 4;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 4;
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src -= 4;
        dst[7] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint32) sample3;
        dst[2] = (Sint32) sample2;
        dst[1] = (Sint32) sample1;
        dst[0] = (Sint32) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        src += 8;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 4;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 4;
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src -= 4;
        dst[15] = (Sint32) sample3;
        dst[14] = (Sint32) sample2;
        dst[13] = (Sint32) sample1;
        dst[12] = (Sint32) sample0;
        dst[11] = (Sint32) (((3 * sample3) + last_sample3) >> 2);
        dst[10] = (Sint32) (((3 * sample2) + last_sample2) >> 2);
        dst[9] = (Sint32) (((3 * sample1) + last_sample1) >> 2);
        dst[8] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[7] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint32) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint32) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint32) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        src += 16;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 6;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 6;
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src -= 6;
        dst[11] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint32) sample5;
        dst[4] = (Sint32) sample4;
        dst[3] = (Sint32) sample3;
        dst[2] = (Sint32) sample2;
        dst[1] = (Sint32) sample1;
        dst[0] = (Sint32) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
        src += 12;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint32) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 6;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 6;
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src -= 6;
        dst[23] = (Sint32) sample5;
        dst[22] = (Sint32) sample4;
        dst[21] = (Sint32) sample3;
        dst[20] = (Sint32) sample2;
        dst[19] = (Sint32) sample1;
        dst[18] = (Sint32) sample0;
        dst[17] = (Sint32) (((3 * sample5) + last_sample5) >> 2);
        dst[16] = (Sint32) (((3 * sample4) + last_sample4) >> 2);
        dst[15] = (Sint32) (((3 * sample3) + last_sample3) >> 2);
        dst[14] = (Sint32) (((3 * sample2) + last_sample2) >> 2);
        dst[13] = (Sint32) (((3 * sample1) + last_sample1) >> 2);
        dst[12] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[11] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint32) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint32) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint32) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint32) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint32) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
        src += 24;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint32) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 8;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 8;
    Sint64 last_sample7 = (Sint64) ((Sint32) SDL_SwapLE32(src[7]));
    Sint64 last_sample6 = (Sint64) ((Sint32) SDL_SwapLE32(src[6]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample7 = (Sint64) ((Sint32) SDL_SwapLE32(src[7]));
        const Sint64 sample6 = (Sint64) ((Sint32) SDL_SwapLE32(src[6]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src -= 8;
        dst[15] = (Sint32) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint32) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint32) sample7;
        dst[6] = (Sint32) sample6;
        dst[5] = (Sint32) sample5;
        dst[4] = (Sint32) sample4;
        dst[3] = (Sint32) sample3;
        dst[2] = (Sint32) sample2;
        dst[1] = (Sint32) sample1;
        dst[0] = (Sint32) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
    Sint64 last_sample6 = (Sint64) ((Sint32) SDL_SwapLE32(src[6]));
    Sint64 last_sample7 = (Sint64) ((Sint32) SDL_SwapLE32(src[7]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
        const Sint64 sample6 = (Sint64) ((Sint32) SDL_SwapLE32(src[6]));
        const Sint64 sample7 = (Sint64) ((Sint32) SDL_SwapLE32(src[7]));
        src += 16;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint32) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint32) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32LSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 8;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 8;
    Sint64 last_sample7 = (Sint64) ((Sint32) SDL_SwapLE32(src[7]));
    Sint64 last_sample6 = (Sint64) ((Sint32) SDL_SwapLE32(src[6]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    while (dst > target) {
        const Sint64 sample7 = (Sint64) ((Sint32) SDL_SwapLE32(src[7]));
        const Sint64 sample6 = (Sint64) ((Sint32) SDL_SwapLE32(src[6]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        src -= 8;
        dst[31] = (Sint32) sample7;
        dst[30] = (Sint32) sample6;
        dst[29] = (Sint32) sample5;
        dst[28] = (Sint32) sample4;
        dst[27] = (Sint32) sample3;
        dst[26] = (Sint32) sample2;
        dst[25] = (Sint32) sample1;
        dst[24] = (Sint32) sample0;
        dst[23] = (Sint32) (((3 * sample7) + last_sample7) >> 2);
        dst[22] = (Sint32) (((3 * sample6) + last_sample6) >> 2);
        dst[21] = (Sint32) (((3 * sample5) + last_sample5) >> 2);
        dst[20] = (Sint32) (((3 * sample4) + last_sample4) >> 2);
        dst[19] = (Sint32) (((3 * sample3) + last_sample3) >> 2);
        dst[18] = (Sint32) (((3 * sample2) + last_sample2) >> 2);
        dst[17] = (Sint32) (((3 * sample1) + last_sample1) >> 2);
        dst[16] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[15] = (Sint32) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint32) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint32) ((sample7 + (3 * last_sample7)) >> 2);
        dst[6] = (Sint32) ((sample6 + (3 * last_sample6)) >> 2);
        dst[5] = (Sint32) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint32) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint32) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint32) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint32) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32LSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
    Sint64 last_sample6 = (Sint64) ((Sint32) SDL_SwapLE32(src[6]));
    Sint64 last_sample7 = (Sint64) ((Sint32) SDL_SwapLE32(src[7]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapLE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapLE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapLE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapLE32(src[3]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapLE32(src[4]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapLE32(src[5]));
        const Sint64 sample6 = (Sint64) ((Sint32) SDL_SwapLE32(src[6]));
        const Sint64 sample7 = (Sint64) ((Sint32) SDL_SwapLE32(src[7]));
        src += 32;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint32) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint32) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 1;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 1;
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src--;
        dst[1] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint32) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src += 2;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 1;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 1;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 1;
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src--;
        dst[3] = (Sint32) sample0;
        dst[2] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[1] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src += 4;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 2;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 2;
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src -= 2;
        dst[3] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) sample1;
        dst[0] = (Sint32) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        src += 4;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 2;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 2;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 2;
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src -= 2;
        dst[7] = (Sint32) sample1;
        dst[6] = (Sint32) sample0;
        dst[5] = (Sint32) (((3 * sample1) + last_sample1) >> 2);
        dst[4] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[3] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        src += 8;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 4;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 4;
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src -= 4;
        dst[7] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint32) sample3;
        dst[2] = (Sint32) sample2;
        dst[1] = (Sint32) sample1;
        dst[0] = (Sint32) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        src += 8;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 4;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 4;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 4;
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src -= 4;
        dst[15] = (Sint32) sample3;
        dst[14] = (Sint32) sample2;
        dst[13] = (Sint32) sample1;
        dst[12] = (Sint32) sample0;
        dst[11] = (Sint32) (((3 * sample3) + last_sample3) >> 2);
        dst[10] = (Sint32) (((3 * sample2) + last_sample2) >> 2);
        dst[9] = (Sint32) (((3 * sample1) + last_sample1) >> 2);
        dst[8] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[7] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[6] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[5] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[4] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[3] = (Sint32) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint32) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint32) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        src += 16;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 6;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 6;
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src -= 6;
        dst[11] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint32) sample5;
        dst[4] = (Sint32) sample4;
        dst[3] = (Sint32) sample3;
        dst[2] = (Sint32) sample2;
        dst[1] = (Sint32) sample1;
        dst[0] = (Sint32) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
        src += 12;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint32) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 6;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 6;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 6;
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src -= 6;
        dst[23] = (Sint32) sample5;
        dst[22] = (Sint32) sample4;
        dst[21] = (Sint32) sample3;
        dst[20] = (Sint32) sample2;
        dst[19] = (Sint32) sample1;
        dst[18] = (Sint32) sample0;
        dst[17] = (Sint32) (((3 * sample5) + last_sample5) >> 2);
        dst[16] = (Sint32) (((3 * sample4) + last_sample4) >> 2);
        dst[15] = (Sint32) (((3 * sample3) + last_sample3) >> 2);
        dst[14] = (Sint32) (((3 * sample2) + last_sample2) >> 2);
        dst[13] = (Sint32) (((3 * sample1) + last_sample1) >> 2);
        dst[12] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[11] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[10] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[9] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[8] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[7] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[6] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[5] = (Sint32) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint32) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint32) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint32) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint32) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
        src += 24;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint32) ((sample5 + last_sample5) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_S32MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 8;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 8;
    Sint64 last_sample7 = (Sint64) ((Sint32) SDL_SwapBE32(src[7]));
    Sint64 last_sample6 = (Sint64) ((Sint32) SDL_SwapBE32(src[6]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample7 = (Sint64) ((Sint32) SDL_SwapBE32(src[7]));
        const Sint64 sample6 = (Sint64) ((Sint32) SDL_SwapBE32(src[6]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src -= 8;
        dst[15] = (Sint32) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint32) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint32) sample7;
        dst[6] = (Sint32) sample6;
        dst[5] = (Sint32) sample5;
        dst[4] = (Sint32) sample4;
        dst[3] = (Sint32) sample3;
        dst[2] = (Sint32) sample2;
        dst[1] = (Sint32) sample1;
        dst[0] = (Sint32) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_S32MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
    Sint64 last_sample6 = (Sint64) ((Sint32) SDL_SwapBE32(src[6]));
    Sint64 last_sample7 = (Sint64) ((Sint32) SDL_SwapBE32(src[7]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
        const Sint64 sample6 = (Sint64) ((Sint32) SDL_SwapBE32(src[6]));
        const Sint64 sample7 = (Sint64) ((Sint32) SDL_SwapBE32(src[7]));
        src += 16;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint32) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint32) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_S32MSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_S32MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    Sint32 *dst = ((Sint32 *) (cvt->buf + dstsize)) - 8;
    const Sint32 *src = ((Sint32 *) (cvt->buf + cvt->len_cvt)) - 8;
    const Sint32 *target = ((const Sint32 *) cvt->buf) - 8;
    Sint64 last_sample7 = (Sint64) ((Sint32) SDL_SwapBE32(src[7]));
    Sint64 last_sample6 = (Sint64) ((Sint32) SDL_SwapBE32(src[6]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    while (dst > target) {
        const Sint64 sample7 = (Sint64) ((Sint32) SDL_SwapBE32(src[7]));
        const Sint64 sample6 = (Sint64) ((Sint32) SDL_SwapBE32(src[6]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        src -= 8;
        dst[31] = (Sint32) sample7;
        dst[30] = (Sint32) sample6;
        dst[29] = (Sint32) sample5;
        dst[28] = (Sint32) sample4;
        dst[27] = (Sint32) sample3;
        dst[26] = (Sint32) sample2;
        dst[25] = (Sint32) sample1;
        dst[24] = (Sint32) sample0;
        dst[23] = (Sint32) (((3 * sample7) + last_sample7) >> 2);
        dst[22] = (Sint32) (((3 * sample6) + last_sample6) >> 2);
        dst[21] = (Sint32) (((3 * sample5) + last_sample5) >> 2);
        dst[20] = (Sint32) (((3 * sample4) + last_sample4) >> 2);
        dst[19] = (Sint32) (((3 * sample3) + last_sample3) >> 2);
        dst[18] = (Sint32) (((3 * sample2) + last_sample2) >> 2);
        dst[17] = (Sint32) (((3 * sample1) + last_sample1) >> 2);
        dst[16] = (Sint32) (((3 * sample0) + last_sample0) >> 2);
        dst[15] = (Sint32) ((sample7 + last_sample7) >> 1);
        dst[14] = (Sint32) ((sample6 + last_sample6) >> 1);
        dst[13] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[12] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[11] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[10] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[9] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[8] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[7] = (Sint32) ((sample7 + (3 * last_sample7)) >> 2);
        dst[6] = (Sint32) ((sample6 + (3 * last_sample6)) >> 2);
        dst[5] = (Sint32) ((sample5 + (3 * last_sample5)) >> 2);
        dst[4] = (Sint32) ((sample4 + (3 * last_sample4)) >> 2);
        dst[3] = (Sint32) ((sample3 + (3 * last_sample3)) >> 2);
        dst[2] = (Sint32) ((sample2 + (3 * last_sample2)) >> 2);
        dst[1] = (Sint32) ((sample1 + (3 * last_sample1)) >> 2);
        dst[0] = (Sint32) ((sample0 + (3 * last_sample0)) >> 2);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_S32MSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_S32MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    Sint32 *dst = (Sint32 *) cvt->buf;
    const Sint32 *src = (Sint32 *) cvt->buf;
    const Sint32 *target = (const Sint32 *) (cvt->buf + dstsize);
    Sint64 last_sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
    Sint64 last_sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
    Sint64 last_sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
    Sint64 last_sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
    Sint64 last_sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
    Sint64 last_sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
    Sint64 last_sample6 = (Sint64) ((Sint32) SDL_SwapBE32(src[6]));
    Sint64 last_sample7 = (Sint64) ((Sint32) SDL_SwapBE32(src[7]));
    while (dst < target) {
        const Sint64 sample0 = (Sint64) ((Sint32) SDL_SwapBE32(src[0]));
        const Sint64 sample1 = (Sint64) ((Sint32) SDL_SwapBE32(src[1]));
        const Sint64 sample2 = (Sint64) ((Sint32) SDL_SwapBE32(src[2]));
        const Sint64 sample3 = (Sint64) ((Sint32) SDL_SwapBE32(src[3]));
        const Sint64 sample4 = (Sint64) ((Sint32) SDL_SwapBE32(src[4]));
        const Sint64 sample5 = (Sint64) ((Sint32) SDL_SwapBE32(src[5]));
        const Sint64 sample6 = (Sint64) ((Sint32) SDL_SwapBE32(src[6]));
        const Sint64 sample7 = (Sint64) ((Sint32) SDL_SwapBE32(src[7]));
        src += 32;
        dst[0] = (Sint32) ((sample0 + last_sample0) >> 1);
        dst[1] = (Sint32) ((sample1 + last_sample1) >> 1);
        dst[2] = (Sint32) ((sample2 + last_sample2) >> 1);
        dst[3] = (Sint32) ((sample3 + last_sample3) >> 1);
        dst[4] = (Sint32) ((sample4 + last_sample4) >> 1);
        dst[5] = (Sint32) ((sample5 + last_sample5) >> 1);
        dst[6] = (Sint32) ((sample6 + last_sample6) >> 1);
        dst[7] = (Sint32) ((sample7 + last_sample7) >> 1);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 1;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 1;
    const float *target = ((const float *) cvt->buf) - 1;
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src--;
        dst[1] = (float) ((sample0 + last_sample0) * 0.5);
        dst[0] = (float) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src += 2;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 1;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 1;
    const float *target = ((const float *) cvt->buf) - 1;
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src--;
        dst[3] = (float) sample0;
        dst[2] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[1] = (float) ((sample0 + last_sample0) * 0.5);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32LSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src += 4;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 2;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 2;
    const float *target = ((const float *) cvt->buf) - 2;
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src -= 2;
        dst[3] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) sample1;
        dst[0] = (float) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        src += 4;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 2;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 2;
    const float *target = ((const float *) cvt->buf) - 2;
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src -= 2;
        dst[7] = (float) sample1;
        dst[6] = (float) sample0;
        dst[5] = (float) (((3.0 * sample1) + last_sample1) * 0.25);
        dst[4] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[3] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + (3.0 * last_sample1)) * 0.25);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32LSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        src += 8;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 4;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 4;
    const float *target = ((const float *) cvt->buf) - 4;
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src -= 4;
        dst[7] = (float) ((sample3 + last_sample3) * 0.5);
        dst[6] = (float) ((sample2 + last_sample2) * 0.5);
        dst[5] = (float) ((sample1 + last_sample1) * 0.5);
        dst[4] = (float) ((sample0 + last_sample0) * 0.5);
        dst[3] = (float) sample3;
        dst[2] = (float) sample2;
        dst[1] = (float) sample1;
        dst[0] = (float) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        src += 8;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 4;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 4;
    const float *target = ((const float *) cvt->buf) - 4;
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src -= 4;
        dst[15] = (float) sample3;
        dst[14] = (float) sample2;
        dst[13] = (float) sample1;
        dst[12] = (float) sample0;
        dst[11] = (float) (((3.0 * sample3) + last_sample3) * 0.25);
        dst[10] = (float) (((3.0 * sample2) + last_sample2) * 0.25);
        dst[9] = (float) (((3.0 * sample1) + last_sample1) * 0.25);
        dst[8] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[7] = (float) ((sample3 + last_sample3) * 0.5);
        dst[6] = (float) ((sample2 + last_sample2) * 0.5);
        dst[5] = (float) ((sample1 + last_sample1) * 0.5);
        dst[4] = (float) ((sample0 + last_sample0) * 0.5);
        dst[3] = (float) ((sample3 + (3.0 * last_sample3)) * 0.25);
        dst[2] = (float) ((sample2 + (3.0 * last_sample2)) * 0.25);
        dst[1] = (float) ((sample1 + (3.0 * last_sample1)) * 0.25);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32LSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        src += 16;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 6;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 6;
    const float *target = ((const float *) cvt->buf) - 6;
    double last_sample5 = (double) SDL_SwapFloatLE(src[5]);
    double last_sample4 = (double) SDL_SwapFloatLE(src[4]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample5 = (double) SDL_SwapFloatLE(src[5]);
        const double sample4 = (double) SDL_SwapFloatLE(src[4]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src -= 6;
        dst[11] = (float) ((sample5 + last_sample5) * 0.5);
        dst[10] = (float) ((sample4 + last_sample4) * 0.5);
        dst[9] = (float) ((sample3 + last_sample3) * 0.5);
        dst[8] = (float) ((sample2 + last_sample2) * 0.5);
        dst[7] = (float) ((sample1 + last_sample1) * 0.5);
        dst[6] = (float) ((sample0 + last_sample0) * 0.5);
        dst[5] = (float) sample5;
        dst[4] = (float) sample4;
        dst[3] = (float) sample3;
        dst[2] = (float) sample2;
        dst[1] = (float) sample1;
        dst[0] = (float) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample4 = (double) SDL_SwapFloatLE(src[4]);
    double last_sample5 = (double) SDL_SwapFloatLE(src[5]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample4 = (double) SDL_SwapFloatLE(src[4]);
        const double sample5 = (double) SDL_SwapFloatLE(src[5]);
        src += 12;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        dst[4] = (float) ((sample4 + last_sample4) * 0.5);
        dst[5] = (float) ((sample5 + last_sample5) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 6;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 6;
    const float *target = ((const float *) cvt->buf) - 6;
    double last_sample5 = (double) SDL_SwapFloatLE(src[5]);
    double last_sample4 = (double) SDL_SwapFloatLE(src[4]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample5 = (double) SDL_SwapFloatLE(src[5]);
        const double sample4 = (double) SDL_SwapFloatLE(src[4]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src -= 6;
        dst[23] = (float) sample5;
        dst[22] = (float) sample4;
        dst[21] = (float) sample3;
        dst[20] = (float) sample2;
        dst[19] = (float) sample1;
        dst[18] = (float) sample0;
        dst[17] = (float) (((3.0 * sample5) + last_sample5) * 0.25);
        dst[16] = (float) (((3.0 * sample4) + last_sample4) * 0.25);
        dst[15] = (float) (((3.0 * sample3) + last_sample3) * 0.25);
        dst[14] = (float) (((3.0 * sample2) + last_sample2) * 0.25);
        dst[13] = (float) (((3.0 * sample1) + last_sample1) * 0.25);
        dst[12] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[11] = (float) ((sample5 + last_sample5) * 0.5);
        dst[10] = (float) ((sample4 + last_sample4) * 0.5);
        dst[9] = (float) ((sample3 + last_sample3) * 0.5);
        dst[8] = (float) ((sample2 + last_sample2) * 0.5);
        dst[7] = (float) ((sample1 + last_sample1) * 0.5);
        dst[6] = (float) ((sample0 + last_sample0) * 0.5);
        dst[5] = (float) ((sample5 + (3.0 * last_sample5)) * 0.25);
        dst[4] = (float) ((sample4 + (3.0 * last_sample4)) * 0.25);
        dst[3] = (float) ((sample3 + (3.0 * last_sample3)) * 0.25);
        dst[2] = (float) ((sample2 + (3.0 * last_sample2)) * 0.25);
        dst[1] = (float) ((sample1 + (3.0 * last_sample1)) * 0.25);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32LSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample4 = (double) SDL_SwapFloatLE(src[4]);
    double last_sample5 = (double) SDL_SwapFloatLE(src[5]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample4 = (double) SDL_SwapFloatLE(src[4]);
        const double sample5 = (double) SDL_SwapFloatLE(src[5]);
        src += 24;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        dst[4] = (float) ((sample4 + last_sample4) * 0.5);
        dst[5] = (float) ((sample5 + last_sample5) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 8;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 8;
    const float *target = ((const float *) cvt->buf) - 8;
    double last_sample7 = (double) SDL_SwapFloatLE(src[7]);
    double last_sample6 = (double) SDL_SwapFloatLE(src[6]);
    double last_sample5 = (double) SDL_SwapFloatLE(src[5]);
    double last_sample4 = (double) SDL_SwapFloatLE(src[4]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample7 = (double) SDL_SwapFloatLE(src[7]);
        const double sample6 = (double) SDL_SwapFloatLE(src[6]);
        const double sample5 = (double) SDL_SwapFloatLE(src[5]);
        const double sample4 = (double) SDL_SwapFloatLE(src[4]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src -= 8;
        dst[15] = (float) ((sample7 + last_sample7) * 0.5);
        dst[14] = (float) ((sample6 + last_sample6) * 0.5);
        dst[13] = (float) ((sample5 + last_sample5) * 0.5);
        dst[12] = (float) ((sample4 + last_sample4) * 0.5);
        dst[11] = (float) ((sample3 + last_sample3) * 0.5);
        dst[10] = (float) ((sample2 + last_sample2) * 0.5);
        dst[9] = (float) ((sample1 + last_sample1) * 0.5);
        dst[8] = (float) ((sample0 + last_sample0) * 0.5);
        dst[7] = (float) sample7;
        dst[6] = (float) sample6;
        dst[5] = (float) sample5;
        dst[4] = (float) sample4;
        dst[3] = (float) sample3;
        dst[2] = (float) sample2;
        dst[1] = (float) sample1;
        dst[0] = (float) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample4 = (double) SDL_SwapFloatLE(src[4]);
    double last_sample5 = (double) SDL_SwapFloatLE(src[5]);
    double last_sample6 = (double) SDL_SwapFloatLE(src[6]);
    double last_sample7 = (double) SDL_SwapFloatLE(src[7]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample4 = (double) SDL_SwapFloatLE(src[4]);
        const double sample5 = (double) SDL_SwapFloatLE(src[5]);
        const double sample6 = (double) SDL_SwapFloatLE(src[6]);
        const double sample7 = (double) SDL_SwapFloatLE(src[7]);
        src += 16;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        dst[4] = (float) ((sample4 + last_sample4) * 0.5);
        dst[5] = (float) ((sample5 + last_sample5) * 0.5);
        dst[6] = (float) ((sample6 + last_sample6) * 0.5);
        dst[7] = (float) ((sample7 + last_sample7) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32LSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 8;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 8;
    const float *target = ((const float *) cvt->buf) - 8;
    double last_sample7 = (double) SDL_SwapFloatLE(src[7]);
    double last_sample6 = (double) SDL_SwapFloatLE(src[6]);
    double last_sample5 = (double) SDL_SwapFloatLE(src[5]);
    double last_sample4 = (double) SDL_SwapFloatLE(src[4]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    while (dst > target) {
        const double sample7 = (double) SDL_SwapFloatLE(src[7]);
        const double sample6 = (double) SDL_SwapFloatLE(src[6]);
        const double sample5 = (double) SDL_SwapFloatLE(src[5]);
        const double sample4 = (double) SDL_SwapFloatLE(src[4]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        src -= 8;
        dst[31] = (float) sample7;
        dst[30] = (float) sample6;
        dst[29] = (float) sample5;
        dst[28] = (float) sample4;
        dst[27] = (float) sample3;
        dst[26] = (float) sample2;
        dst[25] = (float) sample1;
        dst[24] = (float) sample0;
        dst[23] = (float) (((3.0 * sample7) + last_sample7) * 0.25);
        dst[22] = (float) (((3.0 * sample6) + last_sample6) * 0.25);
        dst[21] = (float) (((3.0 * sample5) + last_sample5) * 0.25);
        dst[20] = (float) (((3.0 * sample4) + last_sample4) * 0.25);
        dst[19] = (float) (((3.0 * sample3) + last_sample3) * 0.25);
        dst[18] = (float) (((3.0 * sample2) + last_sample2) * 0.25);
        dst[17] = (float) (((3.0 * sample1) + last_sample1) * 0.25);
        dst[16] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[15] = (float) ((sample7 + last_sample7) * 0.5);
        dst[14] = (float) ((sample6 + last_sample6) * 0.5);
        dst[13] = (float) ((sample5 + last_sample5) * 0.5);
        dst[12] = (float) ((sample4 + last_sample4) * 0.5);
        dst[11] = (float) ((sample3 + last_sample3) * 0.5);
        dst[10] = (float) ((sample2 + last_sample2) * 0.5);
        dst[9] = (float) ((sample1 + last_sample1) * 0.5);
        dst[8] = (float) ((sample0 + last_sample0) * 0.5);
        dst[7] = (float) ((sample7 + (3.0 * last_sample7)) * 0.25);
        dst[6] = (float) ((sample6 + (3.0 * last_sample6)) * 0.25);
        dst[5] = (float) ((sample5 + (3.0 * last_sample5)) * 0.25);
        dst[4] = (float) ((sample4 + (3.0 * last_sample4)) * 0.25);
        dst[3] = (float) ((sample3 + (3.0 * last_sample3)) * 0.25);
        dst[2] = (float) ((sample2 + (3.0 * last_sample2)) * 0.25);
        dst[1] = (float) ((sample1 + (3.0 * last_sample1)) * 0.25);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32LSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32LSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatLE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatLE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatLE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatLE(src[3]);
    double last_sample4 = (double) SDL_SwapFloatLE(src[4]);
    double last_sample5 = (double) SDL_SwapFloatLE(src[5]);
    double last_sample6 = (double) SDL_SwapFloatLE(src[6]);
    double last_sample7 = (double) SDL_SwapFloatLE(src[7]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatLE(src[0]);
        const double sample1 = (double) SDL_SwapFloatLE(src[1]);
        const double sample2 = (double) SDL_SwapFloatLE(src[2]);
        const double sample3 = (double) SDL_SwapFloatLE(src[3]);
        const double sample4 = (double) SDL_SwapFloatLE(src[4]);
        const double sample5 = (double) SDL_SwapFloatLE(src[5]);
        const double sample6 = (double) SDL_SwapFloatLE(src[6]);
        const double sample7 = (double) SDL_SwapFloatLE(src[7]);
        src += 32;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        dst[4] = (float) ((sample4 + last_sample4) * 0.5);
        dst[5] = (float) ((sample5 + last_sample5) * 0.5);
        dst[6] = (float) ((sample6 + last_sample6) * 0.5);
        dst[7] = (float) ((sample7 + last_sample7) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 1;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 1;
    const float *target = ((const float *) cvt->buf) - 1;
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src--;
        dst[1] = (float) ((sample0 + last_sample0) * 0.5);
        dst[0] = (float) sample0;
        last_sample0 = sample0;
        dst -= 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_1c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src += 2;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 1;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 1;
    const float *target = ((const float *) cvt->buf) - 1;
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src--;
        dst[3] = (float) sample0;
        dst[2] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[1] = (float) ((sample0 + last_sample0) * 0.5);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_1c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32MSB, 1 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src += 4;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        last_sample0 = sample0;
        dst++;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 2;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 2;
    const float *target = ((const float *) cvt->buf) - 2;
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src -= 2;
        dst[3] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) sample1;
        dst[0] = (float) sample0;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_2c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        src += 4;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 2;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 2;
    const float *target = ((const float *) cvt->buf) - 2;
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src -= 2;
        dst[7] = (float) sample1;
        dst[6] = (float) sample0;
        dst[5] = (float) (((3.0 * sample1) + last_sample1) * 0.25);
        dst[4] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[3] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + (3.0 * last_sample1)) * 0.25);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_2c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32MSB, 2 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        src += 8;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        dst += 2;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 4;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 4;
    const float *target = ((const float *) cvt->buf) - 4;
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src -= 4;
        dst[7] = (float) ((sample3 + last_sample3) * 0.5);
        dst[6] = (float) ((sample2 + last_sample2) * 0.5);
        dst[5] = (float) ((sample1 + last_sample1) * 0.5);
        dst[4] = (float) ((sample0 + last_sample0) * 0.5);
        dst[3] = (float) sample3;
        dst[2] = (float) sample2;
        dst[1] = (float) sample1;
        dst[0] = (float) sample0;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_4c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        src += 8;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 4;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 4;
    const float *target = ((const float *) cvt->buf) - 4;
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src -= 4;
        dst[15] = (float) sample3;
        dst[14] = (float) sample2;
        dst[13] = (float) sample1;
        dst[12] = (float) sample0;
        dst[11] = (float) (((3.0 * sample3) + last_sample3) * 0.25);
        dst[10] = (float) (((3.0 * sample2) + last_sample2) * 0.25);
        dst[9] = (float) (((3.0 * sample1) + last_sample1) * 0.25);
        dst[8] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[7] = (float) ((sample3 + last_sample3) * 0.5);
        dst[6] = (float) ((sample2 + last_sample2) * 0.5);
        dst[5] = (float) ((sample1 + last_sample1) * 0.5);
        dst[4] = (float) ((sample0 + last_sample0) * 0.5);
        dst[3] = (float) ((sample3 + (3.0 * last_sample3)) * 0.25);
        dst[2] = (float) ((sample2 + (3.0 * last_sample2)) * 0.25);
        dst[1] = (float) ((sample1 + (3.0 * last_sample1)) * 0.25);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_4c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32MSB, 4 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        src += 16;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        dst += 4;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 6;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 6;
    const float *target = ((const float *) cvt->buf) - 6;
    double last_sample5 = (double) SDL_SwapFloatBE(src[5]);
    double last_sample4 = (double) SDL_SwapFloatBE(src[4]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample5 = (double) SDL_SwapFloatBE(src[5]);
        const double sample4 = (double) SDL_SwapFloatBE(src[4]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src -= 6;
        dst[11] = (float) ((sample5 + last_sample5) * 0.5);
        dst[10] = (float) ((sample4 + last_sample4) * 0.5);
        dst[9] = (float) ((sample3 + last_sample3) * 0.5);
        dst[8] = (float) ((sample2 + last_sample2) * 0.5);
        dst[7] = (float) ((sample1 + last_sample1) * 0.5);
        dst[6] = (float) ((sample0 + last_sample0) * 0.5);
        dst[5] = (float) sample5;
        dst[4] = (float) sample4;
        dst[3] = (float) sample3;
        dst[2] = (float) sample2;
        dst[1] = (float) sample1;
        dst[0] = (float) sample0;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 12;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_6c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample4 = (double) SDL_SwapFloatBE(src[4]);
    double last_sample5 = (double) SDL_SwapFloatBE(src[5]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample4 = (double) SDL_SwapFloatBE(src[4]);
        const double sample5 = (double) SDL_SwapFloatBE(src[5]);
        src += 12;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        dst[4] = (float) ((sample4 + last_sample4) * 0.5);
        dst[5] = (float) ((sample5 + last_sample5) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 6;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 6;
    const float *target = ((const float *) cvt->buf) - 6;
    double last_sample5 = (double) SDL_SwapFloatBE(src[5]);
    double last_sample4 = (double) SDL_SwapFloatBE(src[4]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample5 = (double) SDL_SwapFloatBE(src[5]);
        const double sample4 = (double) SDL_SwapFloatBE(src[4]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src -= 6;
        dst[23] = (float) sample5;
        dst[22] = (float) sample4;
        dst[21] = (float) sample3;
        dst[20] = (float) sample2;
        dst[19] = (float) sample1;
        dst[18] = (float) sample0;
        dst[17] = (float) (((3.0 * sample5) + last_sample5) * 0.25);
        dst[16] = (float) (((3.0 * sample4) + last_sample4) * 0.25);
        dst[15] = (float) (((3.0 * sample3) + last_sample3) * 0.25);
        dst[14] = (float) (((3.0 * sample2) + last_sample2) * 0.25);
        dst[13] = (float) (((3.0 * sample1) + last_sample1) * 0.25);
        dst[12] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[11] = (float) ((sample5 + last_sample5) * 0.5);
        dst[10] = (float) ((sample4 + last_sample4) * 0.5);
        dst[9] = (float) ((sample3 + last_sample3) * 0.5);
        dst[8] = (float) ((sample2 + last_sample2) * 0.5);
        dst[7] = (float) ((sample1 + last_sample1) * 0.5);
        dst[6] = (float) ((sample0 + last_sample0) * 0.5);
        dst[5] = (float) ((sample5 + (3.0 * last_sample5)) * 0.25);
        dst[4] = (float) ((sample4 + (3.0 * last_sample4)) * 0.25);
        dst[3] = (float) ((sample3 + (3.0 * last_sample3)) * 0.25);
        dst[2] = (float) ((sample2 + (3.0 * last_sample2)) * 0.25);
        dst[1] = (float) ((sample1 + (3.0 * last_sample1)) * 0.25);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 24;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_6c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32MSB, 6 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample4 = (double) SDL_SwapFloatBE(src[4]);
    double last_sample5 = (double) SDL_SwapFloatBE(src[5]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample4 = (double) SDL_SwapFloatBE(src[4]);
        const double sample5 = (double) SDL_SwapFloatBE(src[5]);
        src += 24;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        dst[4] = (float) ((sample4 + last_sample4) * 0.5);
        dst[5] = (float) ((sample5 + last_sample5) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        dst += 6;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x2) AUDIO_F32MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 2;
    float *dst = ((float *) (cvt->buf + dstsize)) - 8;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 8;
    const float *target = ((const float *) cvt->buf) - 8;
    double last_sample7 = (double) SDL_SwapFloatBE(src[7]);
    double last_sample6 = (double) SDL_SwapFloatBE(src[6]);
    double last_sample5 = (double) SDL_SwapFloatBE(src[5]);
    double last_sample4 = (double) SDL_SwapFloatBE(src[4]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample7 = (double) SDL_SwapFloatBE(src[7]);
        const double sample6 = (double) SDL_SwapFloatBE(src[6]);
        const double sample5 = (double) SDL_SwapFloatBE(src[5]);
        const double sample4 = (double) SDL_SwapFloatBE(src[4]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src -= 8;
        dst[15] = (float) ((sample7 + last_sample7) * 0.5);
        dst[14] = (float) ((sample6 + last_sample6) * 0.5);
        dst[13] = (float) ((sample5 + last_sample5) * 0.5);
        dst[12] = (float) ((sample4 + last_sample4) * 0.5);
        dst[11] = (float) ((sample3 + last_sample3) * 0.5);
        dst[10] = (float) ((sample2 + last_sample2) * 0.5);
        dst[9] = (float) ((sample1 + last_sample1) * 0.5);
        dst[8] = (float) ((sample0 + last_sample0) * 0.5);
        dst[7] = (float) sample7;
        dst[6] = (float) sample6;
        dst[5] = (float) sample5;
        dst[4] = (float) sample4;
        dst[3] = (float) sample3;
        dst[2] = (float) sample2;
        dst[1] = (float) sample1;
        dst[0] = (float) sample0;
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 16;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_8c_x2(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x2) AUDIO_F32MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 2;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample4 = (double) SDL_SwapFloatBE(src[4]);
    double last_sample5 = (double) SDL_SwapFloatBE(src[5]);
    double last_sample6 = (double) SDL_SwapFloatBE(src[6]);
    double last_sample7 = (double) SDL_SwapFloatBE(src[7]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample4 = (double) SDL_SwapFloatBE(src[4]);
        const double sample5 = (double) SDL_SwapFloatBE(src[5]);
        const double sample6 = (double) SDL_SwapFloatBE(src[6]);
        const double sample7 = (double) SDL_SwapFloatBE(src[7]);
        src += 16;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        dst[4] = (float) ((sample4 + last_sample4) * 0.5);
        dst[5] = (float) ((sample5 + last_sample5) * 0.5);
        dst[6] = (float) ((sample6 + last_sample6) * 0.5);
        dst[7] = (float) ((sample7 + last_sample7) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Upsample_F32MSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Upsample (x4) AUDIO_F32MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt * 4;
    float *dst = ((float *) (cvt->buf + dstsize)) - 8;
    const float *src = ((float *) (cvt->buf + cvt->len_cvt)) - 8;
    const float *target = ((const float *) cvt->buf) - 8;
    double last_sample7 = (double) SDL_SwapFloatBE(src[7]);
    double last_sample6 = (double) SDL_SwapFloatBE(src[6]);
    double last_sample5 = (double) SDL_SwapFloatBE(src[5]);
    double last_sample4 = (double) SDL_SwapFloatBE(src[4]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    while (dst > target) {
        const double sample7 = (double) SDL_SwapFloatBE(src[7]);
        const double sample6 = (double) SDL_SwapFloatBE(src[6]);
        const double sample5 = (double) SDL_SwapFloatBE(src[5]);
        const double sample4 = (double) SDL_SwapFloatBE(src[4]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        src -= 8;
        dst[31] = (float) sample7;
        dst[30] = (float) sample6;
        dst[29] = (float) sample5;
        dst[28] = (float) sample4;
        dst[27] = (float) sample3;
        dst[26] = (float) sample2;
        dst[25] = (float) sample1;
        dst[24] = (float) sample0;
        dst[23] = (float) (((3.0 * sample7) + last_sample7) * 0.25);
        dst[22] = (float) (((3.0 * sample6) + last_sample6) * 0.25);
        dst[21] = (float) (((3.0 * sample5) + last_sample5) * 0.25);
        dst[20] = (float) (((3.0 * sample4) + last_sample4) * 0.25);
        dst[19] = (float) (((3.0 * sample3) + last_sample3) * 0.25);
        dst[18] = (float) (((3.0 * sample2) + last_sample2) * 0.25);
        dst[17] = (float) (((3.0 * sample1) + last_sample1) * 0.25);
        dst[16] = (float) (((3.0 * sample0) + last_sample0) * 0.25);
        dst[15] = (float) ((sample7 + last_sample7) * 0.5);
        dst[14] = (float) ((sample6 + last_sample6) * 0.5);
        dst[13] = (float) ((sample5 + last_sample5) * 0.5);
        dst[12] = (float) ((sample4 + last_sample4) * 0.5);
        dst[11] = (float) ((sample3 + last_sample3) * 0.5);
        dst[10] = (float) ((sample2 + last_sample2) * 0.5);
        dst[9] = (float) ((sample1 + last_sample1) * 0.5);
        dst[8] = (float) ((sample0 + last_sample0) * 0.5);
        dst[7] = (float) ((sample7 + (3.0 * last_sample7)) * 0.25);
        dst[6] = (float) ((sample6 + (3.0 * last_sample6)) * 0.25);
        dst[5] = (float) ((sample5 + (3.0 * last_sample5)) * 0.25);
        dst[4] = (float) ((sample4 + (3.0 * last_sample4)) * 0.25);
        dst[3] = (float) ((sample3 + (3.0 * last_sample3)) * 0.25);
        dst[2] = (float) ((sample2 + (3.0 * last_sample2)) * 0.25);
        dst[1] = (float) ((sample1 + (3.0 * last_sample1)) * 0.25);
        dst[0] = (float) ((sample0 + (3.0 * last_sample0)) * 0.25);
        last_sample7 = sample7;
        last_sample6 = sample6;
        last_sample5 = sample5;
        last_sample4 = sample4;
        last_sample3 = sample3;
        last_sample2 = sample2;
        last_sample1 = sample1;
        last_sample0 = sample0;
        dst -= 32;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

static void SDLCALL
SDL_Downsample_F32MSB_8c_x4(SDL_AudioCVT * cvt, SDL_AudioFormat format)
{
#if DEBUG_CONVERT
    fprintf(stderr, "Downsample (x4) AUDIO_F32MSB, 8 channels.\n");
#endif

    const int srcsize = cvt->len_cvt;
    const int dstsize = cvt->len_cvt / 4;
    float *dst = (float *) cvt->buf;
    const float *src = (float *) cvt->buf;
    const float *target = (const float *) (cvt->buf + dstsize);
    double last_sample0 = (double) SDL_SwapFloatBE(src[0]);
    double last_sample1 = (double) SDL_SwapFloatBE(src[1]);
    double last_sample2 = (double) SDL_SwapFloatBE(src[2]);
    double last_sample3 = (double) SDL_SwapFloatBE(src[3]);
    double last_sample4 = (double) SDL_SwapFloatBE(src[4]);
    double last_sample5 = (double) SDL_SwapFloatBE(src[5]);
    double last_sample6 = (double) SDL_SwapFloatBE(src[6]);
    double last_sample7 = (double) SDL_SwapFloatBE(src[7]);
    while (dst < target) {
        const double sample0 = (double) SDL_SwapFloatBE(src[0]);
        const double sample1 = (double) SDL_SwapFloatBE(src[1]);
        const double sample2 = (double) SDL_SwapFloatBE(src[2]);
        const double sample3 = (double) SDL_SwapFloatBE(src[3]);
        const double sample4 = (double) SDL_SwapFloatBE(src[4]);
        const double sample5 = (double) SDL_SwapFloatBE(src[5]);
        const double sample6 = (double) SDL_SwapFloatBE(src[6]);
        const double sample7 = (double) SDL_SwapFloatBE(src[7]);
        src += 32;
        dst[0] = (float) ((sample0 + last_sample0) * 0.5);
        dst[1] = (float) ((sample1 + last_sample1) * 0.5);
        dst[2] = (float) ((sample2 + last_sample2) * 0.5);
        dst[3] = (float) ((sample3 + last_sample3) * 0.5);
        dst[4] = (float) ((sample4 + last_sample4) * 0.5);
        dst[5] = (float) ((sample5 + last_sample5) * 0.5);
        dst[6] = (float) ((sample6 + last_sample6) * 0.5);
        dst[7] = (float) ((sample7 + last_sample7) * 0.5);
        last_sample0 = sample0;
        last_sample1 = sample1;
        last_sample2 = sample2;
        last_sample3 = sample3;
        last_sample4 = sample4;
        last_sample5 = sample5;
        last_sample6 = sample6;
        last_sample7 = sample7;
        dst += 8;
    }

    cvt->len_cvt = dstsize;
    if (cvt->filters[++cvt->filter_index]) {
        cvt->filters[cvt->filter_index] (cvt, format);
    }
}

#endif  /* !LESS_RESAMPLERS */
#endif  /* !NO_RESAMPLERS */


const SDL_AudioRateFilters sdl_audio_rate_filters[] =
{
#if !NO_RESAMPLERS
    { AUDIO_U8, 1, 0, 0, SDL_Downsample_U8_1c },
    { AUDIO_U8, 1, 1, 0, SDL_Upsample_U8_1c },
    { AUDIO_U8, 2, 0, 0, SDL_Downsample_U8_2c },
    { AUDIO_U8, 2, 1, 0, SDL_Upsample_U8_2c },
    { AUDIO_U8, 4, 0, 0, SDL_Downsample_U8_4c },
    { AUDIO_U8, 4, 1, 0, SDL_Upsample_U8_4c },
    { AUDIO_U8, 6, 0, 0, SDL_Downsample_U8_6c },
    { AUDIO_U8, 6, 1, 0, SDL_Upsample_U8_6c },
    { AUDIO_U8, 8, 0, 0, SDL_Downsample_U8_8c },
    { AUDIO_U8, 8, 1, 0, SDL_Upsample_U8_8c },
    { AUDIO_S8, 1, 0, 0, SDL_Downsample_S8_1c },
    { AUDIO_S8, 1, 1, 0, SDL_Upsample_S8_1c },
    { AUDIO_S8, 2, 0, 0, SDL_Downsample_S8_2c },
    { AUDIO_S8, 2, 1, 0, SDL_Upsample_S8_2c },
    { AUDIO_S8, 4, 0, 0, SDL_Downsample_S8_4c },
    { AUDIO_S8, 4, 1, 0, SDL_Upsample_S8_4c },
    { AUDIO_S8, 6, 0, 0, SDL_Downsample_S8_6c },
    { AUDIO_S8, 6, 1, 0, SDL_Upsample_S8_6c },
    { AUDIO_S8, 8, 0, 0, SDL_Downsample_S8_8c },
    { AUDIO_S8, 8, 1, 0, SDL_Upsample_S8_8c },
    { AUDIO_U16LSB, 1, 0, 0, SDL_Downsample_U16LSB_1c },
    { AUDIO_U16LSB, 1, 1, 0, SDL_Upsample_U16LSB_1c },
    { AUDIO_U16LSB, 2, 0, 0, SDL_Downsample_U16LSB_2c },
    { AUDIO_U16LSB, 2, 1, 0, SDL_Upsample_U16LSB_2c },
    { AUDIO_U16LSB, 4, 0, 0, SDL_Downsample_U16LSB_4c },
    { AUDIO_U16LSB, 4, 1, 0, SDL_Upsample_U16LSB_4c },
    { AUDIO_U16LSB, 6, 0, 0, SDL_Downsample_U16LSB_6c },
    { AUDIO_U16LSB, 6, 1, 0, SDL_Upsample_U16LSB_6c },
    { AUDIO_U16LSB, 8, 0, 0, SDL_Downsample_U16LSB_8c },
    { AUDIO_U16LSB, 8, 1, 0, SDL_Upsample_U16LSB_8c },
    { AUDIO_S16LSB, 1, 0, 0, SDL_Downsample_S16LSB_1c },
    { AUDIO_S16LSB, 1, 1, 0, SDL_Upsample_S16LSB_1c },
    { AUDIO_S16LSB, 2, 0, 0, SDL_Downsample_S16LSB_2c },
    { AUDIO_S16LSB, 2, 1, 0, SDL_Upsample_S16LSB_2c },
    { AUDIO_S16LSB, 4, 0, 0, SDL_Downsample_S16LSB_4c },
    { AUDIO_S16LSB, 4, 1, 0, SDL_Upsample_S16LSB_4c },
    { AUDIO_S16LSB, 6, 0, 0, SDL_Downsample_S16LSB_6c },
    { AUDIO_S16LSB, 6, 1, 0, SDL_Upsample_S16LSB_6c },
    { AUDIO_S16LSB, 8, 0, 0, SDL_Downsample_S16LSB_8c },
    { AUDIO_S16LSB, 8, 1, 0, SDL_Upsample_S16LSB_8c },
    { AUDIO_U16MSB, 1, 0, 0, SDL_Downsample_U16MSB_1c },
    { AUDIO_U16MSB, 1, 1, 0, SDL_Upsample_U16MSB_1c },
    { AUDIO_U16MSB, 2, 0, 0, SDL_Downsample_U16MSB_2c },
    { AUDIO_U16MSB, 2, 1, 0, SDL_Upsample_U16MSB_2c },
    { AUDIO_U16MSB, 4, 0, 0, SDL_Downsample_U16MSB_4c },
    { AUDIO_U16MSB, 4, 1, 0, SDL_Upsample_U16MSB_4c },
    { AUDIO_U16MSB, 6, 0, 0, SDL_Downsample_U16MSB_6c },
    { AUDIO_U16MSB, 6, 1, 0, SDL_Upsample_U16MSB_6c },
    { AUDIO_U16MSB, 8, 0, 0, SDL_Downsample_U16MSB_8c },
    { AUDIO_U16MSB, 8, 1, 0, SDL_Upsample_U16MSB_8c },
    { AUDIO_S16MSB, 1, 0, 0, SDL_Downsample_S16MSB_1c },
    { AUDIO_S16MSB, 1, 1, 0, SDL_Upsample_S16MSB_1c },
    { AUDIO_S16MSB, 2, 0, 0, SDL_Downsample_S16MSB_2c },
    { AUDIO_S16MSB, 2, 1, 0, SDL_Upsample_S16MSB_2c },
    { AUDIO_S16MSB, 4, 0, 0, SDL_Downsample_S16MSB_4c },
    { AUDIO_S16MSB, 4, 1, 0, SDL_Upsample_S16MSB_4c },
    { AUDIO_S16MSB, 6, 0, 0, SDL_Downsample_S16MSB_6c },
    { AUDIO_S16MSB, 6, 1, 0, SDL_Upsample_S16MSB_6c },
    { AUDIO_S16MSB, 8, 0, 0, SDL_Downsample_S16MSB_8c },
    { AUDIO_S16MSB, 8, 1, 0, SDL_Upsample_S16MSB_8c },
    { AUDIO_S32LSB, 1, 0, 0, SDL_Downsample_S32LSB_1c },
    { AUDIO_S32LSB, 1, 1, 0, SDL_Upsample_S32LSB_1c },
    { AUDIO_S32LSB, 2, 0, 0, SDL_Downsample_S32LSB_2c },
    { AUDIO_S32LSB, 2, 1, 0, SDL_Upsample_S32LSB_2c },
    { AUDIO_S32LSB, 4, 0, 0, SDL_Downsample_S32LSB_4c },
    { AUDIO_S32LSB, 4, 1, 0, SDL_Upsample_S32LSB_4c },
    { AUDIO_S32LSB, 6, 0, 0, SDL_Downsample_S32LSB_6c },
    { AUDIO_S32LSB, 6, 1, 0, SDL_Upsample_S32LSB_6c },
    { AUDIO_S32LSB, 8, 0, 0, SDL_Downsample_S32LSB_8c },
    { AUDIO_S32LSB, 8, 1, 0, SDL_Upsample_S32LSB_8c },
    { AUDIO_S32MSB, 1, 0, 0, SDL_Downsample_S32MSB_1c },
    { AUDIO_S32MSB, 1, 1, 0, SDL_Upsample_S32MSB_1c },
    { AUDIO_S32MSB, 2, 0, 0, SDL_Downsample_S32MSB_2c },
    { AUDIO_S32MSB, 2, 1, 0, SDL_Upsample_S32MSB_2c },
    { AUDIO_S32MSB, 4, 0, 0, SDL_Downsample_S32MSB_4c },
    { AUDIO_S32MSB, 4, 1, 0, SDL_Upsample_S32MSB_4c },
    { AUDIO_S32MSB, 6, 0, 0, SDL_Downsample_S32MSB_6c },
    { AUDIO_S32MSB, 6, 1, 0, SDL_Upsample_S32MSB_6c },
    { AUDIO_S32MSB, 8, 0, 0, SDL_Downsample_S32MSB_8c },
    { AUDIO_S32MSB, 8, 1, 0, SDL_Upsample_S32MSB_8c },
    { AUDIO_F32LSB, 1, 0, 0, SDL_Downsample_F32LSB_1c },
    { AUDIO_F32LSB, 1, 1, 0, SDL_Upsample_F32LSB_1c },
    { AUDIO_F32LSB, 2, 0, 0, SDL_Downsample_F32LSB_2c },
    { AUDIO_F32LSB, 2, 1, 0, SDL_Upsample_F32LSB_2c },
    { AUDIO_F32LSB, 4, 0, 0, SDL_Downsample_F32LSB_4c },
    { AUDIO_F32LSB, 4, 1, 0, SDL_Upsample_F32LSB_4c },
    { AUDIO_F32LSB, 6, 0, 0, SDL_Downsample_F32LSB_6c },
    { AUDIO_F32LSB, 6, 1, 0, SDL_Upsample_F32LSB_6c },
    { AUDIO_F32LSB, 8, 0, 0, SDL_Downsample_F32LSB_8c },
    { AUDIO_F32LSB, 8, 1, 0, SDL_Upsample_F32LSB_8c },
    { AUDIO_F32MSB, 1, 0, 0, SDL_Downsample_F32MSB_1c },
    { AUDIO_F32MSB, 1, 1, 0, SDL_Upsample_F32MSB_1c },
    { AUDIO_F32MSB, 2, 0, 0, SDL_Downsample_F32MSB_2c },
    { AUDIO_F32MSB, 2, 1, 0, SDL_Upsample_F32MSB_2c },
    { AUDIO_F32MSB, 4, 0, 0, SDL_Downsample_F32MSB_4c },
    { AUDIO_F32MSB, 4, 1, 0, SDL_Upsample_F32MSB_4c },
    { AUDIO_F32MSB, 6, 0, 0, SDL_Downsample_F32MSB_6c },
    { AUDIO_F32MSB, 6, 1, 0, SDL_Upsample_F32MSB_6c },
    { AUDIO_F32MSB, 8, 0, 0, SDL_Downsample_F32MSB_8c },
    { AUDIO_F32MSB, 8, 1, 0, SDL_Upsample_F32MSB_8c },
#if !LESS_RESAMPLERS
    { AUDIO_U8, 1, 0, 2, SDL_Downsample_U8_1c_x2 },
    { AUDIO_U8, 1, 1, 2, SDL_Upsample_U8_1c_x2 },
    { AUDIO_U8, 1, 0, 4, SDL_Downsample_U8_1c_x4 },
    { AUDIO_U8, 1, 1, 4, SDL_Upsample_U8_1c_x4 },
    { AUDIO_U8, 2, 0, 2, SDL_Downsample_U8_2c_x2 },
    { AUDIO_U8, 2, 1, 2, SDL_Upsample_U8_2c_x2 },
    { AUDIO_U8, 2, 0, 4, SDL_Downsample_U8_2c_x4 },
    { AUDIO_U8, 2, 1, 4, SDL_Upsample_U8_2c_x4 },
    { AUDIO_U8, 4, 0, 2, SDL_Downsample_U8_4c_x2 },
    { AUDIO_U8, 4, 1, 2, SDL_Upsample_U8_4c_x2 },
    { AUDIO_U8, 4, 0, 4, SDL_Downsample_U8_4c_x4 },
    { AUDIO_U8, 4, 1, 4, SDL_Upsample_U8_4c_x4 },
    { AUDIO_U8, 6, 0, 2, SDL_Downsample_U8_6c_x2 },
    { AUDIO_U8, 6, 1, 2, SDL_Upsample_U8_6c_x2 },
    { AUDIO_U8, 6, 0, 4, SDL_Downsample_U8_6c_x4 },
    { AUDIO_U8, 6, 1, 4, SDL_Upsample_U8_6c_x4 },
    { AUDIO_U8, 8, 0, 2, SDL_Downsample_U8_8c_x2 },
    { AUDIO_U8, 8, 1, 2, SDL_Upsample_U8_8c_x2 },
    { AUDIO_U8, 8, 0, 4, SDL_Downsample_U8_8c_x4 },
    { AUDIO_U8, 8, 1, 4, SDL_Upsample_U8_8c_x4 },
    { AUDIO_S8, 1, 0, 2, SDL_Downsample_S8_1c_x2 },
    { AUDIO_S8, 1, 1, 2, SDL_Upsample_S8_1c_x2 },
    { AUDIO_S8, 1, 0, 4, SDL_Downsample_S8_1c_x4 },
    { AUDIO_S8, 1, 1, 4, SDL_Upsample_S8_1c_x4 },
    { AUDIO_S8, 2, 0, 2, SDL_Downsample_S8_2c_x2 },
    { AUDIO_S8, 2, 1, 2, SDL_Upsample_S8_2c_x2 },
    { AUDIO_S8, 2, 0, 4, SDL_Downsample_S8_2c_x4 },
    { AUDIO_S8, 2, 1, 4, SDL_Upsample_S8_2c_x4 },
    { AUDIO_S8, 4, 0, 2, SDL_Downsample_S8_4c_x2 },
    { AUDIO_S8, 4, 1, 2, SDL_Upsample_S8_4c_x2 },
    { AUDIO_S8, 4, 0, 4, SDL_Downsample_S8_4c_x4 },
    { AUDIO_S8, 4, 1, 4, SDL_Upsample_S8_4c_x4 },
    { AUDIO_S8, 6, 0, 2, SDL_Downsample_S8_6c_x2 },
    { AUDIO_S8, 6, 1, 2, SDL_Upsample_S8_6c_x2 },
    { AUDIO_S8, 6, 0, 4, SDL_Downsample_S8_6c_x4 },
    { AUDIO_S8, 6, 1, 4, SDL_Upsample_S8_6c_x4 },
    { AUDIO_S8, 8, 0, 2, SDL_Downsample_S8_8c_x2 },
    { AUDIO_S8, 8, 1, 2, SDL_Upsample_S8_8c_x2 },
    { AUDIO_S8, 8, 0, 4, SDL_Downsample_S8_8c_x4 },
    { AUDIO_S8, 8, 1, 4, SDL_Upsample_S8_8c_x4 },
    { AUDIO_U16LSB, 1, 0, 2, SDL_Downsample_U16LSB_1c_x2 },
    { AUDIO_U16LSB, 1, 1, 2, SDL_Upsample_U16LSB_1c_x2 },
    { AUDIO_U16LSB, 1, 0, 4, SDL_Downsample_U16LSB_1c_x4 },
    { AUDIO_U16LSB, 1, 1, 4, SDL_Upsample_U16LSB_1c_x4 },
    { AUDIO_U16LSB, 2, 0, 2, SDL_Downsample_U16LSB_2c_x2 },
    { AUDIO_U16LSB, 2, 1, 2, SDL_Upsample_U16LSB_2c_x2 },
    { AUDIO_U16LSB, 2, 0, 4, SDL_Downsample_U16LSB_2c_x4 },
    { AUDIO_U16LSB, 2, 1, 4, SDL_Upsample_U16LSB_2c_x4 },
    { AUDIO_U16LSB, 4, 0, 2, SDL_Downsample_U16LSB_4c_x2 },
    { AUDIO_U16LSB, 4, 1, 2, SDL_Upsample_U16LSB_4c_x2 },
    { AUDIO_U16LSB, 4, 0, 4, SDL_Downsample_U16LSB_4c_x4 },
    { AUDIO_U16LSB, 4, 1, 4, SDL_Upsample_U16LSB_4c_x4 },
    { AUDIO_U16LSB, 6, 0, 2, SDL_Downsample_U16LSB_6c_x2 },
    { AUDIO_U16LSB, 6, 1, 2, SDL_Upsample_U16LSB_6c_x2 },
    { AUDIO_U16LSB, 6, 0, 4, SDL_Downsample_U16LSB_6c_x4 },
    { AUDIO_U16LSB, 6, 1, 4, SDL_Upsample_U16LSB_6c_x4 },
    { AUDIO_U16LSB, 8, 0, 2, SDL_Downsample_U16LSB_8c_x2 },
    { AUDIO_U16LSB, 8, 1, 2, SDL_Upsample_U16LSB_8c_x2 },
    { AUDIO_U16LSB, 8, 0, 4, SDL_Downsample_U16LSB_8c_x4 },
    { AUDIO_U16LSB, 8, 1, 4, SDL_Upsample_U16LSB_8c_x4 },
    { AUDIO_S16LSB, 1, 0, 2, SDL_Downsample_S16LSB_1c_x2 },
    { AUDIO_S16LSB, 1, 1, 2, SDL_Upsample_S16LSB_1c_x2 },
    { AUDIO_S16LSB, 1, 0, 4, SDL_Downsample_S16LSB_1c_x4 },
    { AUDIO_S16LSB, 1, 1, 4, SDL_Upsample_S16LSB_1c_x4 },
    { AUDIO_S16LSB, 2, 0, 2, SDL_Downsample_S16LSB_2c_x2 },
    { AUDIO_S16LSB, 2, 1, 2, SDL_Upsample_S16LSB_2c_x2 },
    { AUDIO_S16LSB, 2, 0, 4, SDL_Downsample_S16LSB_2c_x4 },
    { AUDIO_S16LSB, 2, 1, 4, SDL_Upsample_S16LSB_2c_x4 },
    { AUDIO_S16LSB, 4, 0, 2, SDL_Downsample_S16LSB_4c_x2 },
    { AUDIO_S16LSB, 4, 1, 2, SDL_Upsample_S16LSB_4c_x2 },
    { AUDIO_S16LSB, 4, 0, 4, SDL_Downsample_S16LSB_4c_x4 },
    { AUDIO_S16LSB, 4, 1, 4, SDL_Upsample_S16LSB_4c_x4 },
    { AUDIO_S16LSB, 6, 0, 2, SDL_Downsample_S16LSB_6c_x2 },
    { AUDIO_S16LSB, 6, 1, 2, SDL_Upsample_S16LSB_6c_x2 },
    { AUDIO_S16LSB, 6, 0, 4, SDL_Downsample_S16LSB_6c_x4 },
    { AUDIO_S16LSB, 6, 1, 4, SDL_Upsample_S16LSB_6c_x4 },
    { AUDIO_S16LSB, 8, 0, 2, SDL_Downsample_S16LSB_8c_x2 },
    { AUDIO_S16LSB, 8, 1, 2, SDL_Upsample_S16LSB_8c_x2 },
    { AUDIO_S16LSB, 8, 0, 4, SDL_Downsample_S16LSB_8c_x4 },
    { AUDIO_S16LSB, 8, 1, 4, SDL_Upsample_S16LSB_8c_x4 },
    { AUDIO_U16MSB, 1, 0, 2, SDL_Downsample_U16MSB_1c_x2 },
    { AUDIO_U16MSB, 1, 1, 2, SDL_Upsample_U16MSB_1c_x2 },
    { AUDIO_U16MSB, 1, 0, 4, SDL_Downsample_U16MSB_1c_x4 },
    { AUDIO_U16MSB, 1, 1, 4, SDL_Upsample_U16MSB_1c_x4 },
    { AUDIO_U16MSB, 2, 0, 2, SDL_Downsample_U16MSB_2c_x2 },
    { AUDIO_U16MSB, 2, 1, 2, SDL_Upsample_U16MSB_2c_x2 },
    { AUDIO_U16MSB, 2, 0, 4, SDL_Downsample_U16MSB_2c_x4 },
    { AUDIO_U16MSB, 2, 1, 4, SDL_Upsample_U16MSB_2c_x4 },
    { AUDIO_U16MSB, 4, 0, 2, SDL_Downsample_U16MSB_4c_x2 },
    { AUDIO_U16MSB, 4, 1, 2, SDL_Upsample_U16MSB_4c_x2 },
    { AUDIO_U16MSB, 4, 0, 4, SDL_Downsample_U16MSB_4c_x4 },
    { AUDIO_U16MSB, 4, 1, 4, SDL_Upsample_U16MSB_4c_x4 },
    { AUDIO_U16MSB, 6, 0, 2, SDL_Downsample_U16MSB_6c_x2 },
    { AUDIO_U16MSB, 6, 1, 2, SDL_Upsample_U16MSB_6c_x2 },
    { AUDIO_U16MSB, 6, 0, 4, SDL_Downsample_U16MSB_6c_x4 },
    { AUDIO_U16MSB, 6, 1, 4, SDL_Upsample_U16MSB_6c_x4 },
    { AUDIO_U16MSB, 8, 0, 2, SDL_Downsample_U16MSB_8c_x2 },
    { AUDIO_U16MSB, 8, 1, 2, SDL_Upsample_U16MSB_8c_x2 },
    { AUDIO_U16MSB, 8, 0, 4, SDL_Downsample_U16MSB_8c_x4 },
    { AUDIO_U16MSB, 8, 1, 4, SDL_Upsample_U16MSB_8c_x4 },
    { AUDIO_S16MSB, 1, 0, 2, SDL_Downsample_S16MSB_1c_x2 },
    { AUDIO_S16MSB, 1, 1, 2, SDL_Upsample_S16MSB_1c_x2 },
    { AUDIO_S16MSB, 1, 0, 4, SDL_Downsample_S16MSB_1c_x4 },
    { AUDIO_S16MSB, 1, 1, 4, SDL_Upsample_S16MSB_1c_x4 },
    { AUDIO_S16MSB, 2, 0, 2, SDL_Downsample_S16MSB_2c_x2 },
    { AUDIO_S16MSB, 2, 1, 2, SDL_Upsample_S16MSB_2c_x2 },
    { AUDIO_S16MSB, 2, 0, 4, SDL_Downsample_S16MSB_2c_x4 },
    { AUDIO_S16MSB, 2, 1, 4, SDL_Upsample_S16MSB_2c_x4 },
    { AUDIO_S16MSB, 4, 0, 2, SDL_Downsample_S16MSB_4c_x2 },
    { AUDIO_S16MSB, 4, 1, 2, SDL_Upsample_S16MSB_4c_x2 },
    { AUDIO_S16MSB, 4, 0, 4, SDL_Downsample_S16MSB_4c_x4 },
    { AUDIO_S16MSB, 4, 1, 4, SDL_Upsample_S16MSB_4c_x4 },
    { AUDIO_S16MSB, 6, 0, 2, SDL_Downsample_S16MSB_6c_x2 },
    { AUDIO_S16MSB, 6, 1, 2, SDL_Upsample_S16MSB_6c_x2 },
    { AUDIO_S16MSB, 6, 0, 4, SDL_Downsample_S16MSB_6c_x4 },
    { AUDIO_S16MSB, 6, 1, 4, SDL_Upsample_S16MSB_6c_x4 },
    { AUDIO_S16MSB, 8, 0, 2, SDL_Downsample_S16MSB_8c_x2 },
    { AUDIO_S16MSB, 8, 1, 2, SDL_Upsample_S16MSB_8c_x2 },
    { AUDIO_S16MSB, 8, 0, 4, SDL_Downsample_S16MSB_8c_x4 },
    { AUDIO_S16MSB, 8, 1, 4, SDL_Upsample_S16MSB_8c_x4 },
    { AUDIO_S32LSB, 1, 0, 2, SDL_Downsample_S32LSB_1c_x2 },
    { AUDIO_S32LSB, 1, 1, 2, SDL_Upsample_S32LSB_1c_x2 },
    { AUDIO_S32LSB, 1, 0, 4, SDL_Downsample_S32LSB_1c_x4 },
    { AUDIO_S32LSB, 1, 1, 4, SDL_Upsample_S32LSB_1c_x4 },
    { AUDIO_S32LSB, 2, 0, 2, SDL_Downsample_S32LSB_2c_x2 },
    { AUDIO_S32LSB, 2, 1, 2, SDL_Upsample_S32LSB_2c_x2 },
    { AUDIO_S32LSB, 2, 0, 4, SDL_Downsample_S32LSB_2c_x4 },
    { AUDIO_S32LSB, 2, 1, 4, SDL_Upsample_S32LSB_2c_x4 },
    { AUDIO_S32LSB, 4, 0, 2, SDL_Downsample_S32LSB_4c_x2 },
    { AUDIO_S32LSB, 4, 1, 2, SDL_Upsample_S32LSB_4c_x2 },
    { AUDIO_S32LSB, 4, 0, 4, SDL_Downsample_S32LSB_4c_x4 },
    { AUDIO_S32LSB, 4, 1, 4, SDL_Upsample_S32LSB_4c_x4 },
    { AUDIO_S32LSB, 6, 0, 2, SDL_Downsample_S32LSB_6c_x2 },
    { AUDIO_S32LSB, 6, 1, 2, SDL_Upsample_S32LSB_6c_x2 },
    { AUDIO_S32LSB, 6, 0, 4, SDL_Downsample_S32LSB_6c_x4 },
    { AUDIO_S32LSB, 6, 1, 4, SDL_Upsample_S32LSB_6c_x4 },
    { AUDIO_S32LSB, 8, 0, 2, SDL_Downsample_S32LSB_8c_x2 },
    { AUDIO_S32LSB, 8, 1, 2, SDL_Upsample_S32LSB_8c_x2 },
    { AUDIO_S32LSB, 8, 0, 4, SDL_Downsample_S32LSB_8c_x4 },
    { AUDIO_S32LSB, 8, 1, 4, SDL_Upsample_S32LSB_8c_x4 },
    { AUDIO_S32MSB, 1, 0, 2, SDL_Downsample_S32MSB_1c_x2 },
    { AUDIO_S32MSB, 1, 1, 2, SDL_Upsample_S32MSB_1c_x2 },
    { AUDIO_S32MSB, 1, 0, 4, SDL_Downsample_S32MSB_1c_x4 },
    { AUDIO_S32MSB, 1, 1, 4, SDL_Upsample_S32MSB_1c_x4 },
    { AUDIO_S32MSB, 2, 0, 2, SDL_Downsample_S32MSB_2c_x2 },
    { AUDIO_S32MSB, 2, 1, 2, SDL_Upsample_S32MSB_2c_x2 },
    { AUDIO_S32MSB, 2, 0, 4, SDL_Downsample_S32MSB_2c_x4 },
    { AUDIO_S32MSB, 2, 1, 4, SDL_Upsample_S32MSB_2c_x4 },
    { AUDIO_S32MSB, 4, 0, 2, SDL_Downsample_S32MSB_4c_x2 },
    { AUDIO_S32MSB, 4, 1, 2, SDL_Upsample_S32MSB_4c_x2 },
    { AUDIO_S32MSB, 4, 0, 4, SDL_Downsample_S32MSB_4c_x4 },
    { AUDIO_S32MSB, 4, 1, 4, SDL_Upsample_S32MSB_4c_x4 },
    { AUDIO_S32MSB, 6, 0, 2, SDL_Downsample_S32MSB_6c_x2 },
    { AUDIO_S32MSB, 6, 1, 2, SDL_Upsample_S32MSB_6c_x2 },
    { AUDIO_S32MSB, 6, 0, 4, SDL_Downsample_S32MSB_6c_x4 },
    { AUDIO_S32MSB, 6, 1, 4, SDL_Upsample_S32MSB_6c_x4 },
    { AUDIO_S32MSB, 8, 0, 2, SDL_Downsample_S32MSB_8c_x2 },
    { AUDIO_S32MSB, 8, 1, 2, SDL_Upsample_S32MSB_8c_x2 },
    { AUDIO_S32MSB, 8, 0, 4, SDL_Downsample_S32MSB_8c_x4 },
    { AUDIO_S32MSB, 8, 1, 4, SDL_Upsample_S32MSB_8c_x4 },
    { AUDIO_F32LSB, 1, 0, 2, SDL_Downsample_F32LSB_1c_x2 },
    { AUDIO_F32LSB, 1, 1, 2, SDL_Upsample_F32LSB_1c_x2 },
    { AUDIO_F32LSB, 1, 0, 4, SDL_Downsample_F32LSB_1c_x4 },
    { AUDIO_F32LSB, 1, 1, 4, SDL_Upsample_F32LSB_1c_x4 },
    { AUDIO_F32LSB, 2, 0, 2, SDL_Downsample_F32LSB_2c_x2 },
    { AUDIO_F32LSB, 2, 1, 2, SDL_Upsample_F32LSB_2c_x2 },
    { AUDIO_F32LSB, 2, 0, 4, SDL_Downsample_F32LSB_2c_x4 },
    { AUDIO_F32LSB, 2, 1, 4, SDL_Upsample_F32LSB_2c_x4 },
    { AUDIO_F32LSB, 4, 0, 2, SDL_Downsample_F32LSB_4c_x2 },
    { AUDIO_F32LSB, 4, 1, 2, SDL_Upsample_F32LSB_4c_x2 },
    { AUDIO_F32LSB, 4, 0, 4, SDL_Downsample_F32LSB_4c_x4 },
    { AUDIO_F32LSB, 4, 1, 4, SDL_Upsample_F32LSB_4c_x4 },
    { AUDIO_F32LSB, 6, 0, 2, SDL_Downsample_F32LSB_6c_x2 },
    { AUDIO_F32LSB, 6, 1, 2, SDL_Upsample_F32LSB_6c_x2 },
    { AUDIO_F32LSB, 6, 0, 4, SDL_Downsample_F32LSB_6c_x4 },
    { AUDIO_F32LSB, 6, 1, 4, SDL_Upsample_F32LSB_6c_x4 },
    { AUDIO_F32LSB, 8, 0, 2, SDL_Downsample_F32LSB_8c_x2 },
    { AUDIO_F32LSB, 8, 1, 2, SDL_Upsample_F32LSB_8c_x2 },
    { AUDIO_F32LSB, 8, 0, 4, SDL_Downsample_F32LSB_8c_x4 },
    { AUDIO_F32LSB, 8, 1, 4, SDL_Upsample_F32LSB_8c_x4 },
    { AUDIO_F32MSB, 1, 0, 2, SDL_Downsample_F32MSB_1c_x2 },
    { AUDIO_F32MSB, 1, 1, 2, SDL_Upsample_F32MSB_1c_x2 },
    { AUDIO_F32MSB, 1, 0, 4, SDL_Downsample_F32MSB_1c_x4 },
    { AUDIO_F32MSB, 1, 1, 4, SDL_Upsample_F32MSB_1c_x4 },
    { AUDIO_F32MSB, 2, 0, 2, SDL_Downsample_F32MSB_2c_x2 },
    { AUDIO_F32MSB, 2, 1, 2, SDL_Upsample_F32MSB_2c_x2 },
    { AUDIO_F32MSB, 2, 0, 4, SDL_Downsample_F32MSB_2c_x4 },
    { AUDIO_F32MSB, 2, 1, 4, SDL_Upsample_F32MSB_2c_x4 },
    { AUDIO_F32MSB, 4, 0, 2, SDL_Downsample_F32MSB_4c_x2 },
    { AUDIO_F32MSB, 4, 1, 2, SDL_Upsample_F32MSB_4c_x2 },
    { AUDIO_F32MSB, 4, 0, 4, SDL_Downsample_F32MSB_4c_x4 },
    { AUDIO_F32MSB, 4, 1, 4, SDL_Upsample_F32MSB_4c_x4 },
    { AUDIO_F32MSB, 6, 0, 2, SDL_Downsample_F32MSB_6c_x2 },
    { AUDIO_F32MSB, 6, 1, 2, SDL_Upsample_F32MSB_6c_x2 },
    { AUDIO_F32MSB, 6, 0, 4, SDL_Downsample_F32MSB_6c_x4 },
    { AUDIO_F32MSB, 6, 1, 4, SDL_Upsample_F32MSB_6c_x4 },
    { AUDIO_F32MSB, 8, 0, 2, SDL_Downsample_F32MSB_8c_x2 },
    { AUDIO_F32MSB, 8, 1, 2, SDL_Upsample_F32MSB_8c_x2 },
    { AUDIO_F32MSB, 8, 0, 4, SDL_Downsample_F32MSB_8c_x4 },
    { AUDIO_F32MSB, 8, 1, 4, SDL_Upsample_F32MSB_8c_x4 },
#endif  /* !LESS_RESAMPLERS */
#endif  /* !NO_RESAMPLERS */
    { 0, 0, 0, 0, NULL }
};

/* 390 converters generated. */

/* *INDENT-ON* */

/* vi: set ts=4 sw=4 expandtab: */
